﻿---
title: Configure security in Kibana
description: This document describes security settings you may need to configure in self-managed deployments of Kibana. These settings help secure access, manage connections,...
url: https://www.elastic.co/docs/deploy-manage/security/using-kibana-with-security
products:
  - Kibana
applies_to:
  - Self-managed Elastic deployments: Generally available
---

# Configure security in Kibana
This document describes security settings you may need to configure in self-managed deployments of Kibana. These settings help secure access, manage connections, and ensure consistent behavior across multiple instances.
Additional Kibana security features that apply to all deployment types, such as session management, saved objects encryption, and audit logging, are covered in a separate section [at the end of this document](#additional-security-topics).

## Configure encryption keys

Set an encryption key so that sessions are not invalidated. You can optionally configure additional security settings and authentication.
<important>
  When Kibana traffic is balanced across multiple instances connected to the same deployment, it is critical to configure these settings with identical values across all instances. Refer to [High Availability and load balancing in Kibana](https://www.elastic.co/docs/deploy-manage/production-guidance/kibana-load-balance-traffic) for more information.
</important>

1. Set the `xpack.security.encryptionKey` property in the [`kibana.yml`](https://www.elastic.co/docs/deploy-manage/stack-settings) configuration file. You can use any text string that is 32 characters or longer as the encryption key. Refer to [`xpack.security.encryptionKey`](https://www.elastic.co/docs/reference/kibana/configuration-reference/security-settings#xpack-security-encryptionkey).
   ```yaml
   xpack.security.encryptionKey: "something_at_least_32_characters"
   ```
   Kibana's reporting and saved objects features also have encryption key settings. Refer to [`xpack.reporting.encryptionKey`](https://www.elastic.co/docs/reference/kibana/configuration-reference/reporting-settings#xpack-reporting-encryptionkey) and [`xpack.encryptedSavedObjects.encryptionKey`](https://www.elastic.co/docs/reference/kibana/configuration-reference/security-settings#xpack-encryptedsavedobjects-encryptionkey) respectively.
2. Optional: [Configure Kibana's session expiration settings](https://www.elastic.co/docs/deploy-manage/security/kibana-session-management).
3. Restart Kibana.


## Use secure HTTP headers

The Kibana server can instruct browsers to enable additional security controls using HTTP headers.
1. Enable `HTTP Strict Transport Security (HSTS)`.
   Use [`strictTransportSecurity`](https://www.elastic.co/docs/reference/kibana/configuration-reference/general-settings#server-securityresponseheaders-stricttransportsecurity) to ensure that browsers will only attempt to access [Kibana with SSL/TLS encryption](/docs/deploy-manage/security/set-up-basic-security-plus-https#encrypt-kibana-browser). This is designed to prevent manipulator-in-the-middle attacks. To configure this with a lifetime of one year in your [`kibana.yml`](https://www.elastic.co/docs/deploy-manage/stack-settings):
   ```js
   server.securityResponseHeaders.strictTransportSecurity: "max-age=31536000"
   ```
   <warning>
   This header will block unencrypted connections for the entire domain. If you host more than one web application on the same domain using different ports or paths, all of them will be affected.
   </warning>
2. Disable embedding.
   Use [`disableEmbedding`](https://www.elastic.co/docs/reference/kibana/configuration-reference/general-settings#server-securityresponseheaders-disableembedding) to ensure that Kibana cannot be embedded in other websites. To configure this in your [`kibana.yml`](https://www.elastic.co/docs/deploy-manage/stack-settings):
   ```js
   server.securityResponseHeaders.disableEmbedding: true
   ```


## Require a Content Security Policy

Kibana uses a Content Security Policy (CSP) to prevent the browser from allowing unsafe scripting, but older browsers will silently ignore this policy. If your organization does not need to support very old versions of our supported browsers, we recommend that you enable Kibana's `strict` mode for the CSP. This will block access to Kibana for any browser that does not enforce even a rudimentary set of CSP protections.
To do this, set `csp.strict` to `true` in your [`kibana.yml`](https://www.elastic.co/docs/deploy-manage/stack-settings):
```js
csp.strict: true
```


## Additional security topics

For guidance on managing user access to Kibana, refer to [Kibana privileges](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/kibana-privileges) and [Cluster or deployment users](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth).
For TLS encryption configuration, refer to [Set up HTTPS > Encrypt traffic between your browser and Kibana](/docs/deploy-manage/security/set-up-basic-security-plus-https#encrypt-kibana-browser).
The following Kibana security features are not covered in this document because they apply to all deployment types, not just self-managed ones. However, they’re also important to consider:
- [Session management](https://www.elastic.co/docs/deploy-manage/security/kibana-session-management)
- [Saved objects encryption](https://www.elastic.co/docs/deploy-manage/security/secure-saved-objects)
- [Secure settings](https://www.elastic.co/docs/deploy-manage/security/secure-settings)
- [Security events audit logging](https://www.elastic.co/docs/deploy-manage/security/logging-configuration/security-event-audit-logging)

For a complete overview of available security features, refer to [Secure your cluster, deployment, or project](https://www.elastic.co/docs/deploy-manage/security/secure-your-cluster-deployment).