﻿---
title: Set up transport TLS
description: Configuring TLS between nodes is the basic security setup to prevent unauthorized nodes from accessing to your Elasticsearch cluster, and it's required...
url: https://www.elastic.co/docs/deploy-manage/security/set-up-basic-security
products:
  - Elasticsearch
applies_to:
  - Self-managed Elastic deployments: Generally available
---

# Set up transport TLS
Configuring TLS between nodes is the basic security setup to prevent unauthorized nodes from accessing to your Elasticsearch cluster, and it's required by multi-node clusters. [Production mode](/docs/deploy-manage/deploy/self-managed/bootstrap-checks#dev-vs-prod-mode) clusters will not start if you do not enable TLS.
This document focuses on the **manual configuration** of TLS for [Elasticsearch transport protocol](/docs/deploy-manage/security/secure-cluster-communications#encrypt-internode-communication) in self-managed environments. Use this approach if you want to provide your own TLS certificates, generate them with Elastic’s tools, or have full control over the configuration. Alternatively, Elasticsearch can [automatically generate and configure HTTPS certificates](https://www.elastic.co/docs/deploy-manage/security/self-auto-setup) for you.
In this guide, you will learn how to:
- [Generate or provide security certificates](#obtain-certificates).
- [Configure your Elasticsearch nodes to use the generated certificate for the transport layer](#encrypt-internode-communication).

Refer to [Transport TLS/SSL settings](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/security-settings#transport-tls-ssl-settings) for the complete list of available settings in Elasticsearch.
<note>
  For other deployment types, such as Elastic Cloud Hosted, Elastic Cloud Enterprise, or Elastic Cloud on Kubernetes, refer to [TLS encryption for cluster communications](https://www.elastic.co/docs/deploy-manage/security/secure-cluster-communications).
</note>


## Obtain certificates

You can add as many nodes as you want in a cluster but they must be able to communicate with each other. The communication between nodes in a cluster is handled by the transport module. To secure your cluster, you must ensure that internode communications are encrypted and verified, which is achieved with mutual TLS.
In a secured cluster, Elasticsearch nodes use certificates to identify themselves when communicating with other nodes.
The cluster must validate the authenticity of these certificates. The recommended approach is to trust a specific certificate authority (CA). When nodes are added to your cluster they must use a certificate signed by the same CA.
For the transport layer, we recommend using a separate, dedicated CA instead of an existing, possibly shared CA so that node membership is tightly controlled.
When you manually set up transport TLS, you can choose from the following CA options:
- [Use the `elasticsearch-certutil` tool to generate a CA unique to your cluster](#generate-certificates) (recommended)
- [Provide certificates from an external CA](#external-ca)


### Generate the certificate authority using `elasticsearch-certutil`

You can use the `elasticsearch-certutil` tool to generate a CA for your cluster. Using `elasticsearch-certutil` guarantees that your certificates meet Elasticsearch certificate requirements and security best practices.
1. Before starting Elasticsearch, generate the CA:
   1. Use the `elasticsearch-certutil` tool on any single node to generate a CA for your cluster.
   ```shell
   ./bin/elasticsearch-certutil ca
   ```
   1. When prompted, accept the default file name, which is `elastic-stack-ca.p12`. This file contains the public certificate for your CA and the private key used to sign certificates for each node.
2. Enter a password for your CA. You can choose to leave the password blank if you’re not deploying to a production environment.
2. Generate the certificate:
   1. On any single node, generate a certificate and private key for the nodes in your cluster. Include the `elastic-stack-ca.p12` output file that you generated in the previous step.
   ```shell
   ./bin/elasticsearch-certutil cert --ca elastic-stack-ca.p12 
   ```
2. Enter the password for your CA, or press **Enter** if you did not configure one in the previous step.
3. Create a password for the certificate and accept the default file name.
   The output file is a keystore named `elastic-certificates.p12`. This file contains a node certificate, node key, and CA certificate.


### Provide certificates from an external CA

You might choose to use an external CA to generate transport certificates for node-to-node connections. An external CA is any CA that is not managed using `elasticsearch-certutil`.
Transport connections between Elasticsearch nodes are security-critical and you must protect them carefully. Malicious actors who can observe or interfere with unencrypted node-to-node transport traffic can read or modify cluster data. A malicious actor who can establish a transport connection might be able to invoke system-internal APIs, including APIs that read or modify cluster data.
Carefully review [Using an external certificate authority to secure node-to-node connections](https://www.elastic.co/docs/deploy-manage/security/external-ca-transport) to ensure that your certificates meet the security requirements for transport connections.

## Encrypt internode communications with TLS

The transport networking layer is used for internal communication between nodes in a cluster. When security features are enabled, you must use TLS to ensure that communication between the nodes is encrypted.
Now that you’ve obtained your certificates, you’ll update your cluster to use these files.
These steps assume that you [generated a CA and certificates](#generate-certificates) using `elasticsearch-certutil`. The `xpack.security.transport.ssl` settings that you need to set differ if you're using a certificate generated with an external CA. Refer to [Transport TLS/SSL settings](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/security-settings#transport-tls-ssl-settings) for a full list of available settings.
<note>
  Elasticsearch monitors all files such as certificates, keys, keystores, or truststores that are configured as values of TLS-related node settings. If you update any of these files, such as when your hostnames change or your certificates are due to expire, Elasticsearch reloads them. The files are polled for changes at a frequency determined by the global Elasticsearch `resource.reload.interval.high` setting, which defaults to 5 seconds.
</note>

Complete the following steps **for each node in your cluster**. To join the same cluster, all nodes must share the same `cluster.name` value.
1. Place the certificate or keystore file that you obtained in the `$ES_PATH_CONF` directory on **every** node in your cluster. If you generated a CA using `elasticsearch-certutil`, then this file is named `elastic-certificates.p12`.
2. Open the `$ES_PATH_CONF/elasticsearch.yml` file and make the following changes:
   1. Add the [`cluster-name`](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/miscellaneous-cluster-settings#cluster-name) setting and enter a name for your cluster:
   ```yaml
   cluster.name: my-cluster
   ```
2. Add the [`node.name`](/docs/deploy-manage/deploy/self-managed/important-settings-configuration#node-name) setting and enter a name for the node. The node name defaults to the hostname of the machine when Elasticsearch starts.
   ```yaml
   node.name: node-1
   ```
3. Add the following settings to enable internode communication and provide access to the node’s certificate.
   Because you are using the same `elastic-certificates.p12` file on every node in your cluster, set the verification mode to `certificate`:
   ```yaml
   xpack.security.transport.ssl.enabled: true
   xpack.security.transport.ssl.verification_mode: certificate 
   xpack.security.transport.ssl.client_authentication: required
   xpack.security.transport.ssl.keystore.path: elastic-certificates.p12
   xpack.security.transport.ssl.truststore.path: elastic-certificates.p12
   ```
3. If you entered a password when creating the node certificate, run the following commands to store the password in the Elasticsearch keystore:
   ```shell
   ./bin/elasticsearch-keystore add xpack.security.transport.ssl.keystore.secure_password
   ```
   ```shell
   ./bin/elasticsearch-keystore add xpack.security.transport.ssl.truststore.secure_password
   ```
4. Complete the previous steps for each node in your cluster.
5. On **every** node in your cluster, start Elasticsearch. The method for [starting](https://www.elastic.co/docs/deploy-manage/maintenance/start-stop-services/start-stop-elasticsearch) and [stopping](https://www.elastic.co/docs/deploy-manage/maintenance/start-stop-services/start-stop-elasticsearch) Elasticsearch varies depending on how you installed it.
   For example, if you installed Elasticsearch with an archive distribution (`tar.gz` or `.zip`), you can enter `Ctrl+C` on the command line to stop Elasticsearch.
   <warning>
   You must perform a full cluster restart. Nodes that are configured to use TLS for transport cannot communicate with nodes that use unencrypted transport connection (and vice-versa).
   </warning>


## What’s next?

Congratulations! You’ve encrypted communications between the nodes in your cluster and can pass the [TLS bootstrap check](/docs/deploy-manage/deploy/self-managed/bootstrap-checks#bootstrap-checks-tls).
To add another layer of security, [set up HTTP TLS](https://www.elastic.co/docs/deploy-manage/security/set-up-basic-security-plus-https) to encrypt client communications with both Elasticsearch and Kibana.
For other tasks related with TLS encryption in self-managed deployments, refer to [Manage TLS encryption in self-managed deployments](https://www.elastic.co/docs/deploy-manage/security/self-tls).