﻿---
title: Set up HTTPS
description: Enabling TLS on the HTTP layer, widely known as HTTPS, ensures that all client communications with your cluster are encrypted, adding a critical layer...
url: https://www.elastic.co/docs/deploy-manage/security/set-up-basic-security-plus-https
products:
  - Elasticsearch
applies_to:
  - Self-managed Elastic deployments: Generally available
---

# Set up HTTPS
Enabling TLS on the HTTP layer, widely known as HTTPS, ensures that all client communications with your cluster are encrypted, adding a critical layer of security.
This document focuses on the **manual configuration** of HTTPS for Elasticsearch and Kibana. Use this approach if you want to provide your own TLS certificates, generate them with Elastic’s tools, or have full control over the configuration.
Note that HTTPS configuration for Kibana is always manual. Alternatively, Elasticsearch supports [automatic HTTPS setup](https://www.elastic.co/docs/deploy-manage/security/self-auto-setup), which can simplify the process if full customization isn't required.
In this guide, you will learn how to:
- [Generate and configure TLS certificates for the HTTP endpoints of your Elasticsearch nodes](#encrypt-http-communication).
- [Configure Kibana to securely connect to Elasticsearch over HTTPS](#encrypt-kibana-elasticsearch) by trusting the Certificate Authority (CA) used by Elasticsearch.
- [Generate and configure TLS certificates for the Kibana HTTP interface to secure Kibana access](#encrypt-kibana-browser).

Refer to [HTTP TLS/SSL settings](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/security-settings#http-tls-ssl-settings) for the complete list of available settings in Elasticsearch.
<note>
  This guide uses the `elasticsearch-certutil` tool to generate Certificate Authorities (CAs) and TLS certificates. However, using this tool is not required. You can use publicly trusted certificates, your organization's internal certificate management system, or any other method that produces valid certificates.If you already have certificates available, you can skip the certificate generation steps and proceed directly to the Elasticsearch and Kibana configuration steps.
</note>

<tip>
  When running `elasticsearch-certutil` in `http` mode, the tool prompts you to choose how to generate the TLS certificates. One key question is whether you want to generate a Certificate Signing Request (CSR).
  - Answer `n` to skip the CSR and sign your certificates using a Certificate Authority (CA) [you previously created](/docs/deploy-manage/security/set-up-basic-security#generate-certificates). You’ll be prompted to provide the path to your CA, which the tool will use to generate a `.p12` certificate. The steps in this guide follow this workflow for Elasticsearch certificates.
  - Answer `y` to generate a CSR that can be signed by your organization's internal CA or external certificate provider. This is common in environments where trust is managed centrally. The steps in this guide follow this workflow for Kibana certificate.
  Both workflows are supported. Choose the one that best fits your infrastructure and trust model.
</tip>


## Prerequisites

If security feature wasn't already enabled in your cluster, complete all steps in [Minimal security setup](https://www.elastic.co/docs/deploy-manage/security/set-up-minimal-security).
For multi-node clusters, ensure you have completed the [transport TLS setup](https://www.elastic.co/docs/deploy-manage/security/set-up-basic-security). As part of that process, you will have created a Certificate Authority (CA) that this guide reuses to issue HTTP certificates.
If you prefer to use a separate CA for HTTP, you can generate a new one using the same process. For example:
```bash
elasticsearch-certutil ca --out http-ca.p12
```

Then, use this CA to sign your HTTP certificates in the next section and for Kibana HTTP endpoint.

## Generate and configure TLS certificates for Elasticsearch nodes

Once TLS is enabled, all client communications with the cluster will be encrypted. Clients must connect using `https` and be configured to trust the Certificate Authority (CA) that signed the Elasticsearch certificates.
1. On **every** node in your cluster, stop Elasticsearch and Kibana if they are running.
2. On any single node, from the directory where you installed Elasticsearch, run the Elasticsearch HTTP certificate tool to generate TLS certificates for your nodes.
   ```shell
   ./bin/elasticsearch-certutil http
   ```
   This command generates a `.zip` file that contains certificates and keys to use with Elasticsearch and Kibana. Each folder contains a `README.txt` explaining how to use these files.
   1. When asked if you want to generate a CSR, enter `n`.
2. When asked if you want to use an existing CA, enter `y`.
3. Enter the path to your CA. This is the absolute path to the `elastic-stack-ca.p12` file that you generated for your cluster.
4. Enter the password for your CA.
5. Enter an expiration value for your certificate. You can enter the validity period in years, months, or days. For example, enter `90D` for 90 days.
6. When asked if you want to generate one certificate per node, enter `y`.
   Each certificate will have its own private key, and will be issued for a specific hostname or IP address.
7. When prompted, enter the name of the first node in your cluster.
8. Enter all hostnames used to connect to your first node. These hostnames will be added as DNS names in the Subject Alternative Name (SAN) field in your certificate.
   List every hostname and variant used to connect to your cluster over HTTPS.
9. Enter the IP addresses that clients can use to connect to your node.
10. Repeat these steps for each additional node in your cluster.
3. After generating a certificate for each of your nodes, enter a password for your private key when prompted.
4. Unzip the generated `elasticsearch-ssl-http.zip` file. This compressed file contains one directory for both Elasticsearch and Kibana.
   ```txt
   /elasticsearch
   |_ README.txt
   |_ http.p12
   |_ sample-elasticsearch.yml
   ```
   ```txt
   /kibana
   |_ README.txt
   |_ elasticsearch-ca.pem
   |_ sample-kibana.yml
   ```
5. On **every** node in your cluster, complete the following steps:
   1. Copy the relevant `http.p12` certificate to the `$ES_PATH_CONF` directory.
2. Edit the [`elasticsearch.yml`](https://www.elastic.co/docs/deploy-manage/stack-settings) file to enable HTTPS security and specify the location of the `http.p12` security certificate.
   ```yaml
   xpack.security.http.ssl.enabled: true
   xpack.security.http.ssl.keystore.path: http.p12
   ```
3. Add the password for your private key to the [secure settings](https://www.elastic.co/docs/deploy-manage/security/secure-settings) in Elasticsearch.
   ```shell
   ./bin/elasticsearch-keystore add xpack.security.http.ssl.keystore.secure_password
   ```
4. Start Elasticsearch.


## Encrypt HTTP communications for Kibana

Kibana handles two separate types of HTTP traffic that should be encrypted:
- **Outgoing requests from Kibana to Elasticsearch**: Kibana acts as an HTTP client and must be configured to trust the TLS certificate used by Elasticsearch.
- **Incoming requests from browsers or API clients to Kibana**: Kibana acts as an HTTP server, and you should configure a TLS certificate for its public-facing endpoint to secure clients traffic.


### Encrypt traffic between Kibana and Elasticsearch

When you ran the `elasticsearch-certutil` tool with the `http` option to create the Elasticsearch certificates, it created a `/kibana` directory containing an `elasticsearch-ca.pem` file. You use this file to configure Kibana to trust the Elasticsearch CA for the HTTP layer.
<note>
  If you obtained the Elasticsearch certificates using a different method, you must provide Kibana with the appropriate CA certificates to establish trust. This may include the root CA and one or more intermediate CAs, depending on how the certificates were issued.
</note>

1. Copy the `elasticsearch-ca.pem` file to the Kibana configuration directory, as defined by the `$KBN_PATH_CONF` path.
2. Open [`kibana.yml`](https://www.elastic.co/docs/deploy-manage/stack-settings) and add the following line to specify the location of the security certificate for the HTTP layer.
   ```yaml
   elasticsearch.ssl.certificateAuthorities: $KBN_PATH_CONF/elasticsearch-ca.pem
   ```
3. Add the following line to specify the HTTPS URL for your Elasticsearch cluster.
   ```yaml
   elasticsearch.hosts: https://<your_elasticsearch_host>:9200
   ```
4. Restart Kibana.

<admonition title="Connect to a secure monitoring cluster">
  If the Elastic monitoring features are enabled and you configured a separate Elasticsearch monitoring cluster, you can also configure Kibana to connect to the monitoring cluster through HTTPS. The steps are the same, but each setting is prefixed by `monitoring.ui`. For example, `monitoring.ui.elasticsearch.hosts` and `monitoring.ui.elasticsearch.ssl.certificateAuthorities`.If the monitoring cluster uses certificates signed by a different CA than the main cluster, you must provide a separate `elasticsearch-ca.pem` file that corresponds to the monitoring cluster's CA.
</admonition>


### Encrypt traffic between your browser and Kibana

To secure browser access to Kibana, you need to generate a TLS certificate and private key for the server. Kibana uses these to encrypt HTTP traffic and establish trust with connecting browsers or API clients.
<important>
  When creating or requesting a TLS certificate, make sure to include one or more valid **Subject Alternative Names (SANs)** that match how users will access Kibana, typically a fully qualified domain name (FQDN), hostname, or IP address. Most browsers will reject the certificate if none of the SANs match the address used to connect.
</important>

The following steps guide you through creating a Certificate Signing Request (CSR) for Kibana. A CSR is used to obtain a TLS certificate from a Certificate Authority (CA). For production environments, use a trusted CA such as [Let’s Encrypt](https://letsencrypt.org/) or your organization’s internal CA to ensure browser trust.
1. Generate a CSR and private key for Kibana.
   ```shell
   ./bin/elasticsearch-certutil csr -name kibana-server -dns example.com,www.example.com
   ```
   The CSR has a common name (CN) of `kibana-server`, a SAN of `example.com`, and another SAN of `www.example.com`.
   This command generates a `csr-bundle.zip` file by default with the following contents:
   ```txt
   /kibana-server
   |_ kibana-server.csr
   |_ kibana-server.key
   ```
2. Unzip the `csr-bundle.zip` file to obtain the `kibana-server.csr` unsigned security certificate and the `kibana-server.key` unencrypted private key.
3. Submit the `kibana-server.csr` certificate signing request to your organization’s security team or certificate authority to obtain a signed certificate. The resulting certificate might be in different formats, such as a `.crt` file like `kibana-server.crt`.
4. Open [`kibana.yml`](https://www.elastic.co/docs/deploy-manage/stack-settings) and add the following lines to configure Kibana HTTPS endpoint to use the server certificate and unencrypted private key.
   ```yaml
   server.ssl.certificate: $KBN_PATH_CONF/kibana-server.crt
   server.ssl.key: $KBN_PATH_CONF/kibana-server.key
   ```
   <note>
   `$KBN_PATH_CONF` contains the path for the Kibana configuration files. If you installed Kibana using archive distributions (`zip` or `tar.gz`), the path defaults to `$KBN_HOME/config`. If you used package distributions (Debian or RPM), the path defaults to `/etc/kibana`.
   </note>
5. Add the following line to [`kibana.yml`](https://www.elastic.co/docs/deploy-manage/stack-settings) to enable HTTPS for incoming connections.
   ```yaml
   server.ssl.enabled: true
   ```
6. Start Kibana.
   After making these changes, you must always access Kibana through HTTPS. For example, `https://<your_kibana_host>.com:5601`.


## What’s next?

After having enabled HTTPS, you should configure any other client that interacts with Elasticsearch or Kibana to use HTTPS and trust the appropriate CA certificate. Refer to [Secure other Elastic Stack components](https://www.elastic.co/docs/deploy-manage/security/secure-clients-integrations) and [Securing HTTP client applications](https://www.elastic.co/docs/deploy-manage/security/httprest-clients-security) for more details.
For other tasks related with TLS encryption in self-managed deployments, refer to [Manage TLS encryption in self-managed deployments](https://www.elastic.co/docs/deploy-manage/security/self-tls).
For other security features, refer to [Secure your cluster, deployment, or project](https://www.elastic.co/docs/deploy-manage/security/secure-your-cluster-deployment).