﻿---
title: Manage TLS encryption in self-managed deployments
description: This section provides guidance on managing TLS certificates in self-managed deployments after the initial security setup. It covers tasks such as configuring...
url: https://www.elastic.co/docs/deploy-manage/security/self-tls
applies_to:
  - Self-managed Elastic deployments: Generally available
---

# Manage TLS encryption in self-managed deployments
This section provides guidance on managing TLS certificates in self-managed deployments after the initial security setup. It covers tasks such as configuring mutual authentication, renewing certificates, and customizing supported TLS versions and cipher suites.
If you're looking to secure a new or existing cluster by setting up TLS for the first time, refer to [Set up security in self-managed deployments](https://www.elastic.co/docs/deploy-manage/security/self-setup), which covers both the [automatic](https://www.elastic.co/docs/deploy-manage/security/self-auto-setup) and [manual](/docs/deploy-manage/security/self-setup#manual-configuration) configuration procedures.
The topics in this section focus on post-setup tasks:
- [Mutual TLS authentication between Kibana and Elasticsearch](https://www.elastic.co/docs/deploy-manage/security/kibana-es-mutual-tls): Strengthen security by requiring Kibana to use a client certificate when connecting to Elasticsearch.
- [Update TLS certificates](https://www.elastic.co/docs/deploy-manage/security/updating-certificates): Renew or replace existing TLS certificates before they expire.
- [Supported SSL/TLS versions by JDK version](https://www.elastic.co/docs/deploy-manage/security/supported-ssltls-versions-by-jdk-version): Customize the list of supported SSL/TLS versions in your cluster.
- [Enabling cipher suites for stronger encryption](https://www.elastic.co/docs/deploy-manage/security/enabling-cipher-suites-for-stronger-encryption): Enable additional cipher suites for TLS communications, including those used with authentication providers.

For an overview of the endpoints that can be secured in Elasticsearch and Kibana, refer to [Communication channels](/docs/deploy-manage/security/secure-cluster-communications#communication-channels).

## Certificates lifecycle

In self-managed deployments, you are responsible for certificate lifecycle management, including monitoring expiration dates, renewing certificates, and redeploying them as needed. If you used Elastic tools to generate your certificates, refer to [Update TLS certificates](https://www.elastic.co/docs/deploy-manage/security/updating-certificates) for guidance on rotating or replacing them.

## Advanced configuration references

Refer to [Transport TLS/SSL settings](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/security-settings#transport-tls-ssl-settings) and [HTTP TLS/SSL settings](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/security-settings#http-tls-ssl-settings) for the complete list of TLS-related settings in Elasticsearch.
For Kibana, refer to [Kibana general settings](https://www.elastic.co/docs/reference/kibana/configuration-reference/general-settings), and search for all `ssl`-related settings. TLS settings for the HTTPS server are under the `server.ssl` namespace, while settings for the connection to Elasticsearch are under `elasticsearch.ssl`.