﻿---
title: Set up security in self-managed deployments
description: This section explains the initial security setup for self-managed deployments, including configuring TLS certificates to secure Elasticsearch and Kibana...
url: https://www.elastic.co/docs/deploy-manage/security/self-setup
products:
  - Elasticsearch
applies_to:
  - Self-managed Elastic deployments: Generally available
---

# Set up security in self-managed deployments
This section explains the initial security setup for self-managed deployments, including configuring TLS certificates to secure Elasticsearch and Kibana endpoints, setting passwords for built-in users, and generating enrollment tokens to connect Kibana or additional Elasticsearch nodes to the cluster.
Self-managed deployments support two approaches for the initial setup: automatic and manual. Note that securing Kibana always requires some manual configuration.
For guidance on configuring additional security features, refer to [Secure your cluster, deployment, or project](https://www.elastic.co/docs/deploy-manage/security/secure-your-cluster-deployment).

## Automatic configuration

Since version 8.0, Elasticsearch automatically enables security features on first startup when the node is not part of an existing cluster and none of the [incompatible settings](/docs/deploy-manage/security/self-auto-setup#stack-existing-settings-detected) have been explicitly configured.
The automatic configuration:
- Generates TLS certificates for the [transport and HTTP layers](/docs/deploy-manage/security/secure-cluster-communications#communication-channels)
- Applies TLS configuration settings to [`elasticsearch.yml`](https://www.elastic.co/docs/deploy-manage/stack-settings)
- Sets a password for the `elastic` superuser
- Creates an enrollment token to securely connect Kibana to Elasticsearch

This automatic setup is the quickest way to get started and ensures your cluster is protected by default. To start this process, follow one of our [Elasticsearch installation guides](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/installing-elasticsearch).
<warning>
  The automatic configuration does not enable TLS on the Kibana HTTP endpoint. To encrypt browser traffic to Kibana, follow the steps in [Set up HTTPS > Encrypt traffic between your browser and Kibana](/docs/deploy-manage/security/set-up-basic-security-plus-https#encrypt-kibana-browser).
</warning>

Refer to [Automatic security setup](https://www.elastic.co/docs/deploy-manage/security/self-auto-setup) to learn more, including a list of automatically generated security certificates and keys, and [cases where the security setup may be skipped](/docs/deploy-manage/security/self-auto-setup#stack-skip-auto-configuration).

## Manual configuration

If you’re securing an existing unsecured cluster, or prefer to use your own TLS certificates, follow the manual approach. It involves enabling different layers of protection in sequence, depending on your cluster architecture and security requirements.
1. **[Set up minimal security](https://www.elastic.co/docs/deploy-manage/security/set-up-minimal-security)**: Enables password-based authentication for built-in users and configures Kibana to connect using credentials. Suitable for single-node clusters, but not sufficient for production or multi-node clusters.
2. **[Configure transport TLS](https://www.elastic.co/docs/deploy-manage/security/set-up-basic-security)**: Required for multi-node clusters running in [production mode](/docs/deploy-manage/deploy/self-managed/bootstrap-checks#dev-vs-prod-mode). Secures communication between nodes and prevents unauthorized nodes from joining the cluster.
3. **[Configure HTTP TLS](https://www.elastic.co/docs/deploy-manage/security/set-up-basic-security-plus-https)**: Secures all client communications over HTTPS, including traffic between Kibana and Elasticsearch, and between browsers and Kibana. Recommended for all clusters, even single-node setups.

Each step builds on the previous one. For production environments, it’s strongly recommended to complete all three.
For additional TLS configuration options, refer to [Manage TLS encryption in self-managed deployments](https://www.elastic.co/docs/deploy-manage/security/self-tls).

## Kibana security configuration

Refer to [Configure security in Kibana](https://www.elastic.co/docs/deploy-manage/security/using-kibana-with-security) to learn how to implement the following security best practices for Kibana:
- Set an encryption key for client sessions
- Use secure HTTP headers
- Require a Content Security Policy (CSP)