﻿---
title: Automatic security setup
description: To learn how to start Elasticsearch and Kibana with security enabled, follow one of our installation guides. Select the product that you want to install,...
url: https://www.elastic.co/docs/deploy-manage/security/self-auto-setup
products:
  - Elasticsearch
applies_to:
  - Self-managed Elastic deployments: Generally available
---

# Automatic security setup
When you start your first Elasticsearch node for the first time, it automatically performs the following security setup:
- Generates [TLS certificates](#stack-security-certificates) for the [transport and HTTP layers](/docs/deploy-manage/security/secure-cluster-communications#communication-channels)
- Applies TLS configuration settings to [`elasticsearch.yml`](https://www.elastic.co/docs/deploy-manage/stack-settings)
- Sets a password for the `elastic` superuser
- Creates an enrollment token to securely connect Kibana to Elasticsearch

You can then start Kibana and enter the enrollment token, which is valid for 30 minutes. This token automatically applies the security settings from your Elasticsearch cluster, authenticates to Elasticsearch with the built-in `kibana` service account, and writes the security configuration to [`kibana.yml`](https://www.elastic.co/docs/deploy-manage/stack-settings).
<note>
  There are [some cases](#stack-skip-auto-configuration) where security can’t be configured automatically because the node startup process detects that the node is already part of a cluster, or that security is already configured or explicitly disabled.
</note>

<note>
  In Elasticsearch RPM and Debian package installations, the `elastic` user password is not output at startup and must be [manually reset](/docs/deploy-manage/users-roles/cluster-or-deployment-auth/built-in-sm#using-elasticsearch-reset-password).
</note>

To learn how to start Elasticsearch and Kibana with security enabled, follow one of our installation guides. Select the product that you want to install, and then select the guide your preferred installation method:
- [Install Elasticsearch](/docs/deploy-manage/deploy/self-managed/installing-elasticsearch#installation-methods)
- [Install Kibana](/docs/deploy-manage/deploy/self-managed/install-kibana#install)


## Security certificates and keys

When you install Elasticsearch, the following certificates and keys are generated in the Elasticsearch configuration directory. These files are used to connect a Kibana instance to your secured Elasticsearch cluster and to encrypt internode communication. The files are listed here for reference.
<definitions>
  <definition term="http_ca.crt">
    The CA certificate that is used to sign the certificates for the HTTP layer of this Elasticsearch cluster.
  </definition>
  <definition term="http.p12">
    Keystore that contains the key and certificate for the HTTP layer for this node.
  </definition>
  <definition term="transport.p12">
    Keystore that contains the key and certificate for the transport layer for all the nodes in your cluster.
  </definition>
</definitions>

`http.p12` and `transport.p12` are password-protected PKCS#12 keystores. Elasticsearch stores the passwords for these keystores as [secure settings](https://www.elastic.co/docs/deploy-manage/security/secure-settings). To retrieve the passwords so that you can inspect or change the keystore contents, use the [`bin/elasticsearch-keystore`](https://www.elastic.co/docs/reference/elasticsearch/command-line-tools/elasticsearch-keystore) tool.
Use the following command to retrieve the password for `http.p12`:
```sh
bin/elasticsearch-keystore show xpack.security.http.ssl.keystore.secure_password
```

Use the following command to retrieve the password for `transport.p12`:
```sh
bin/elasticsearch-keystore show xpack.security.transport.ssl.keystore.secure_password
```


## Cases when security auto configuration is skipped

When you start Elasticsearch for the first time, the node startup process tries to automatically configure security for you. The process runs some checks to determine:
- If this is the first time that the node is starting
- Whether security is already configured
- If the startup process can modify the node configuration

If any of those checks fail, there’s a good indication that you manually configured security, or don’t want security to be configured automatically. In these cases, the node starts normally using the existing configuration.
<important>
  If you redirect Elasticsearch output to a file, security autoconfiguration is skipped. Autoconfigured credentials can only be viewed on the terminal the first time you start Elasticsearch. If you need to redirect output to a file, start Elasticsearch without redirection the first time and use redirection on all subsequent starts.
</important>


### Existing environment detected

If certain directories already exist, there’s a strong indication that the node was started previously. Similarly, if certain files *don’t* exist, or we can’t read or write to specific files or directories, then we’re likely not running as the user who installed Elasticsearch or an administrator imposed restrictions. If any of the following environment checks are true, security isn’t configured automatically.
<definitions>
  <definition term="The Elasticsearch /data directory exists and isn’t empty">
    The existence of this directory is a strong indicator that the node was started previously, and might already be part of a cluster.
  </definition>
  <definition term="The elasticsearch.yml file doesn’t exist (or isn’t readable), or the elasticsearch.keystore isn’t readable">
    If either of these files aren’t readable, we can’t determine whether Elasticsearch security features are already enabled. This state can also indicate that the node startup process isn’t running as a user with sufficient privileges to modify the node configuration.
  </definition>
  <definition term="The Elasticsearch configuration directory isn’t writable">
    This state likely indicates that an administrator made this directory read-only, or that the user who is starting Elasticsearch is not the user that installed Elasticsearch.
  </definition>
</definitions>


### Existing settings detected

The following settings are incompatible with security auto configuration. If any of these settings exist, the node startup process skips configuring security automatically and the node starts normally.
- [`node.roles`](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/node-settings#node-roles) is set to a value where the node can’t be elected as `master`, or if the node can’t hold data
- [`xpack.security.autoconfiguration.enabled`](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/security-settings#general-security-settings) is set to `false`
- [`xpack.security.enabled`](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/security-settings#general-security-settings) has a value set
- Any of the [`xpack.security.transport.ssl.*`](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/security-settings#transport-tls-ssl-settings) or [`xpack.security.http.ssl.*`](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/security-settings#http-tls-ssl-settings) settings have a value set in the [`elasticsearch.yml`](https://www.elastic.co/docs/deploy-manage/stack-settings) configuration file or in the [`elasticsearch.keystore`](https://www.elastic.co/docs/deploy-manage/security/secure-settings)
- Any of the `discovery.type`, `discovery.seed_hosts`, or `cluster.initial_master_nodes` [discovery and cluster formation settings](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/discovery-cluster-formation-settings) have a value set
  <note>
  Exceptions are when `discovery.type` is set to `single-node`, or when `cluster.initial_master_nodes` exists but contains only the name of the current node.
  </note>