﻿---
title: Manage security certificates
description: During installation, Elastic Cloud Enterprise generates certificates so that you can connect to your installation securely. In order to connect securely,...
url: https://www.elastic.co/docs/deploy-manage/security/secure-your-elastic-cloud-enterprise-installation/manage-security-certificates
products:
  - Elastic Cloud Enterprise
applies_to:
  - Elastic Cloud Enterprise: Generally available
---

# Manage security certificates
During installation, Elastic Cloud Enterprise generates certificates so that you can connect to your installation securely. In order to connect securely, you must first download and trust the CA certificates generated during installation before issuing any requests to ECE. If your organization operates as its own certificate authority, you can provide your certificates for ECE to avoid a security warning when connecting to the Cloud UI over HTTPS.
In these instructions, we show you how you can download the security certificate that gets generated during the ECE installation and use it to add your own TLS/SSL certificates. You can add your TLS/SSL certificates any time after you have installed ECE on your hosts. In addition to the steps shown here, you might also need to import your CA certificate into your browser certificate chain, if you don’t already use the same certificate within your organization.
You can change the certificates for the following ECE components separately:
<definitions>
  <definition term="Cloud UI certificate">
    Used to connect securely to the Cloud UI and to make RESTful API calls.
  </definition>
  <definition term="Proxy certificate">
    Used to connect securely to Elasticsearch clusters and other components such as Kibana, etc.
    We strongly recommend using a wildcard certificate configured for a subdomain at the [cluster endpoint you set](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/change-endpoint-urls) (for example, `*.ece.mycompany.com`).
    If you wish to enable [custom endpoint aliases](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/enable-custom-endpoint-aliases) in ECE 2.10 or later, also follow the directions for adding Subject Alternative Name (SAN) entries to support these aliases.
    A wildcard DNS certificate is more performant, scalable, and operationally safe than a static SAN certificate. Review [Wildcard DNS record and certificates](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/ece-wildcard-dns) for more guidance.
    After the certificates have been installed, connecting securely to Elasticsearch, Kibana, and the Cloud UI or making secure RESTful API calls to ECE should not result in any security warnings or errors.
  </definition>
  <definition term="Adminconsole certificate">
    This certificate facilitates a secure connection to an alternative API port, which can be used in rare scenarios where the UI is unavailable. We recommend using the same certificate as the one configured for the Cloud UI.
  </definition>
</definitions>


## Before you begin

When uploading the certificate chain to ECE, the following requirements apply:
- You must upload the full certificate chain, including certificate authorities.
- The chain must be in this order: Private key > SSL certificate > Interim CA (optional) > Root CA.
- The certificates must be in PEM format and the result should be a single file containing the full chain.

The PEM file should be structured like this:
```sh
-----BEGIN RSA PRIVATE KEY-----
(Your Private Key: your_domain_name.key)
-----END RSA PRIVATE KEY-----
-----BEGIN CERTIFICATE-----
(Your Primary SSL certificate: your_domain_name.crt)
-----END CERTIFICATE-----
-----BEGIN CERTIFICATE-----
(Your Intermediate certificate: Intermediate.crt)
-----END CERTIFICATE-----
-----BEGIN CERTIFICATE-----
(Your Root certificate: TrustedRoot.crt)
-----END CERTIFICATE-----
```

Each key and certificate would be generated by you or your IT team.
<note>
  Elastic Cloud Enterprise requires the private key to begin with the header `-----BEGIN RSA PRIVATE KEY-----`. If your key instead starts with a different header, such as `-----BEGIN PRIVATE KEY-----` (without `RSA`), an error occurs:
  ```json
  {
      "code" : "cert.invalid_cert_chain",
      "message" : "Certificate chain was invalid [Invalid Entry: expected unencrypted rsa private key (is start of file corrupted?)]"
  }
  ```
  Review the documentation for your certificate generation tool to determine how to obtain the private key header expected by Elastic Cloud Enterprise. For example, with OpenSSL you can add the `-traditional` option when generating the key.
</note>


## Get existing ECE security certificates

Obtain the existing certificate generated during the installation of ECE.
1. You can use the [openssl](https://www.openssl.org/source/) command line tool to display the whole server certificate chain. Run the command against the Cloud UI URL provided at the end of the installation process on your first host, `192.168.43.10:12343` in our example:
   ```sh
   openssl s_client -showcerts -connect 192.168.43.10:12343 < /dev/zero

   CONNECTED(00000003)
   depth=2 CN = elastic ce master
   verify error:num=19:self signed certificate in certificate chain
   ---
   Certificate chain
    0 s:/CN=elastic ce admin console a954e2668da4
      i:/CN=elastic ce admin console root
   -----BEGIN CERTIFICATE-----
   MIIDjzCCAnegAwIBAgIGAVqk1eYJMA0GCSqGSIb3DQEBCwUAMCgxJjAkBgNVBAMT
   HWVsYXN0aWMgY2UgYWRtaW4gY29uc29sZSByb290MB4XDTE3MDMwNjE4MTYwNVoX
   DTI3MDMwNDE4MTYwNVowMDEuMCwGA1UEAxMlZWxhc3RpYyBjZSBhZG1pbiBjb25z
   b2xlIGE5NTRlMjY2OGRhNDCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEB
   ALqsQZexkEWoOnhK5uDrGC4kjEWVSWoYOR6ymd8ySHIqhqAZTGoRhiO46jlrCr+e
   Jqn3a+qlNNCmEBc5BqjDlKpEKmaLQJoAZock2fOXLiKVQZiJK+ygShoMq2KGpIeY
   m/gzQ01atAuETBut8AgpjMN2/xbm3FI0KiqPEpglC8wKQ4hKukbVn5YJBZmBjJxr
   17vzhDpC/qJJ+owRNUoz9vd4VEfDjNhaZWJ8ihDWUCL9rDwVp8XVLUQ38SBurd7A
   zJjfzHfrpI9+C8F2UBHjDdqus253Qho5a8S+hGq7VRVqcGoo0nvqThVvR2s0tEDk
   fsN0rDOL3or9BwUbv0gIiAECAwEAAaOBtjCBszAsBgNVHREEJTAjggxlY2UtMC1y
   dW5uZXKCDTE5Mi4xNjguNDMuMTCHBMCoKwowSQYDVR0jBEIwQIAUgB4X3GsrUoGz
   SzJ4IQ8nuB6cosOhIKQeMBwxGjAYBgNVBAMTEWVsYXN0aWMgY2UgbWFzdGVyggYB
   WqTVH5EwHQYDVR0OBBYEFA7euGA6jC4XSKCRNt1ZWqABUa/EMAkGA1UdEwQCMAAw
   DgYDVR0PAQH/BAQDAgTwMA0GCSqGSIb3DQEBCwUAA4IBAQA9xskIXZ8byN0I+M/R
   cXKbvVzsu//gVgswCSZ/KpidWZnSxhuQ4tIryby6DqTKSvzp17ASld1VrYp3vZw+
   zIgU7k7f/w2ATnm39Sn/DxuKUGEblMjUs2X9cF+ijFZklgX1LyWwIK9iKCATuS7J
   OThTFGuV0NScsvhiFTTaCXteQql+WwFOI2vL5XZKE8XiQesDiJfNbWg2K/EhxBih
   sFPWgik9aljciAHXK/pH9vQNf2rfpSL9HSTc89RetDFkmkXGIPKd3lxORE6wCdKm
   mUi6uktMCnBSyMapNEbiWR3sAPf30y81UAVJKcnzd7r8bP3V/19ZBEfvEUSy80DT
   th3x
   -----END CERTIFICATE-----
    1 s:/CN=elastic ce admin console root
      i:/CN=elastic ce master
   -----BEGIN CERTIFICATE-----
   MIIDUDCCAjigAwIBAgIGAVqk1R+RMA0GCSqGSIb3DQEBCwUAMBwxGjAYBgNVBAMT
   EWVsYXN0aWMgY2UgbWFzdGVyMB4XDTE3MDMwNjE4MTUxNVoXDTI3MDMwNDE4MTUx
   NVowKDEmMCQGA1UEAxMdZWxhc3RpYyBjZSBhZG1pbiBjb25zb2xlIHJvb3QwggEi
   MA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCbse8n9LOSSnrBI6KSFieNZKKL
   MEjK+TqbA5dYmyC7935Jkpe2aWBhVT2o29+EgKotlWF6/3i+db4SPRVTJ21rLYJu
   usPkPr9jkEvKxExPG9hgzvXBQvbgKx4kzw9wEi5Mmh1bEsEBqkQsfXG5Tgk8J+VA
   IUIueiqZXhkmZvEx4e7m2rVhxWoVMHkzlQGOmZ77cQ9F68yFeCnbXUrvIIVs1Doj
   vFOybEFfYKuMjUqG+i6M0WrvOxij6QHnOfLEBc/Th0ckU60yKFnTYRHaym6xBcZN
   oDdkGwl7imbn62jvBUF7VLs7QLnkjF7ExxDksY3uxdcL9+q7BRwFW3bDTWDfAgMB
   AAGjgYswgYgwSQYDVR0jBEIwQIAUZdT53vvMI/XLUKahehVoLA5z4RGhIKQeMBwx
   GjAYBgNVBAMTEWVsYXN0aWMgY2UgbWFzdGVyggYBWqTVFtIwHQYDVR0OBBYEFIAe
   F9xrK1KBs0syeCEPJ7genKLDMAwGA1UdEwQFMAMBAf8wDgYDVR0PAQH/BAQDAgH2
   MA0GCSqGSIb3DQEBCwUAA4IBAQDR6vYhPau8ue0D/+iUha1NA6zAoImSEqr06dGe
   fyDJ5BCRWIEXvF4e//th55h/8eObCZhyeDPhcg1u73MWWGub3WO1EFqo4+Se7fKS
   6uz5tTQplfSHI6fUaRzQ6lIClmc5RaAtnV86if/pfcK9Vb0yoLxOR4510gFZTp2x
   WRi8Q9E2LHkTYoMxoWZG9CyNrZ1apsV8GE1DG9f8OaxJ99exymVctySQynJqPSPP
   S2Xzb6TYzvW6ZiApzAgM6oS2KejA2CRNO+HjNWsJCceBuM8Z60Jq8Rm5Wh1rHjWw
   vFJZB0z0J6l/rOKAIIpeoPxoyDr/4RlommC3BRMEcOF0NdTk
   -----END CERTIFICATE-----
    2 s:/CN=elastic ce master
      i:/CN=elastic ce master
   -----BEGIN CERTIFICATE-----
   MIIDRDCCAiygAwIBAgIGAVqk1RbSMA0GCSqGSIb3DQEBCwUAMBwxGjAYBgNVBAMT
   EWVsYXN0aWMgY2UgbWFzdGVyMB4XDTE3MDMwNjE4MTUxMloXDTI3MDMwNDE4MTUx
   MlowHDEaMBgGA1UEAxMRZWxhc3RpYyBjZSBtYXN0ZXIwggEiMA0GCSqGSIb3DQEB
   AQUAA4IBDwAwggEKAoIBAQDbwOBtXjKvw4B10HDfoXatlXn8qUHkesV9+lWT0NT1
   WU1X4rc9TwCsWHbH1S0YmOiTw9YVrzFjbYtjNgW5M3DXiewfvnfVm6ifrcuU1C0L
   yN8WxqBmvQt/7H2hyKwgsmiXfoULbT5PGuhizvRntlD2OgnPjshwetkRN//O3NWo
   Osd2LKMyzUvRPxNP2CwbQLetLgEpQjrjB+nfv4WZHkAQ4vGwxFkN6WaIpqhuhg2q
   I8xEHHh1IYTEOiQJZXXg7nU3vqY3kQ2Yu9kopuUJoXY5CviZLZO/xCriNVEPaOhX
   6pWM+dDHaEzx1EiZNg3bjpAXAP+aErSDVAlqbYqCoeAvAgMBAAGjgYswgYgwHQYD
   VR0OBBYEFGXU+d77zCP1y1CmoXoVaCwOc+ERMEkGA1UdIwRCMECAFGXU+d77zCP1
   y1CmoXoVaCwOc+ERoSCkHjAcMRowGAYDVQQDExFlbGFzdGljIGNlIG1hc3RlcoIG
   AVqk1RbSMAwGA1UdEwQFMAMBAf8wDgYDVR0PAQH/BAQDAgH2MA0GCSqGSIb3DQEB
   CwUAA4IBAQBclrkSxPRhN6uxPmJ4QIlZ8OOBKuPPul5434Au8UWAzQX8p6tKLBBT
   Zpl9py/fg8YS1iTlPBkRCjssZG9x3x0gG2ftDqrO4AqL7L0X3oZRy+sIkG17h3GI
   CcHO596EGzhFPSa183kIwGXb4mI5nNUe43KkDXEyid/VIn27jokeqslfu2KQJnC1
   ggwLRgrNpeNO4pb7cK4aBu3oLZ0tPnhdbIG+bVgHE6a6ZYyBH266oJmNpqmNOTzn
   JjrgOt5gEB5JcL1VWXZ3lU3ukd5Jq/rGFkqytBj+uQccpuWkGUMqU82xjREES8D8
   AIHl4ghc6SM1jl2SqZR7aoAjP0uGwW31
   -----END CERTIFICATE-----
   ---
   Server certificate
   subject=/CN=elastic ce admin console a954e2668da4
   issuer=/CN=elastic ce admin console root
   ---
   No client certificate CA names sent
   Peer signing digest: SHA512
   Server Temp Key: ECDH, P-256, 256 bits
   ---
   SSL handshake has read 3120 bytes and written 433 bytes
   ---
   New, TLSv1/SSLv3, Cipher is ECDHE-RSA-AES256-GCM-SHA384
   Server public key is 2048 bit
   Secure Renegotiation IS supported
   Compression: NONE
   Expansion: NONE
   No ALPN negotiated
   SSL-Session:
       Protocol  : TLSv1.2
       Cipher    : ECDHE-RSA-AES256-GCM-SHA384
       Session-ID: C9FA70D80592981C4174F490EF47AF0091326AED6ED4115CED30A9861EBD7758
       Session-ID-ctx:
       Master-Key: 0EF40D4B72E102395352FE7935CAA47CA84BF743E8BF102B98856AFCB76E4BDDCEFDE3E0F7D4D4681A3BCFB170864C9F
       Key-Arg   : None
       PSK identity: None
       PSK identity hint: None
       SRP username: None
       Start Time: 1488824550
       Timeout   : 300 (sec)
       Verify return code: 19 (self signed certificate in certificate chain)
   ---
   HTTP/1.1 501 Not Implemented
   Server: fac/9431ee
   Date: Mon, 06 Mar 2017 18:21:19 GMT
   Content-Type: text/plain; charset=UTF-8
   Connection: close
   Content-Length: 23
   Unsupported HTTP methodclosed
   ```
2. Save the last certificate shown in the output to a local file, `elastic-ece-ca-cert.pem` in this example:
   ```sh
   cat << EOF > ~/elastic-ece-ca-cert.pem
   -----BEGIN CERTIFICATE-----
   MIIDRDCCAiygAwIBAgIGAVqk1RbSMA0GCSqGSIb3DQEBCwUAMBwxGjAYBgNVBAMT
   EWVsYXN0aWMgY2UgbWFzdGVyMB4XDTE3MDMwNjE4MTUxMloXDTI3MDMwNDE4MTUx
   MlowHDEaMBgGA1UEAxMRZWxhc3RpYyBjZSBtYXN0ZXIwggEiMA0GCSqGSIb3DQEB
   AQUAA4IBDwAwggEKAoIBAQDbwOBtXjKvw4B10HDfoXatlXn8qUHkesV9+lWT0NT1
   WU1X4rc9TwCsWHbH1S0YmOiTw9YVrzFjbYtjNgW5M3DXiewfvnfVm6ifrcuU1C0L
   yN8WxqBmvQt/7H2hyKwgsmiXfoULbT5PGuhizvRntlD2OgnPjshwetkRN//O3NWo
   Osd2LKMyzUvRPxNP2CwbQLetLgEpQjrjB+nfv4WZHkAQ4vGwxFkN6WaIpqhuhg2q
   I8xEHHh1IYTEOiQJZXXg7nU3vqY3kQ2Yu9kopuUJoXY5CviZLZO/xCriNVEPaOhX
   6pWM+dDHaEzx1EiZNg3bjpAXAP+aErSDVAlqbYqCoeAvAgMBAAGjgYswgYgwHQYD
   VR0OBBYEFGXU+d77zCP1y1CmoXoVaCwOc+ERMEkGA1UdIwRCMECAFGXU+d77zCP1
   y1CmoXoVaCwOc+ERoSCkHjAcMRowGAYDVQQDExFlbGFzdGljIGNlIG1hc3RlcoIG
   AVqk1RbSMAwGA1UdEwQFMAMBAf8wDgYDVR0PAQH/BAQDAgH2MA0GCSqGSIb3DQEB
   CwUAA4IBAQBclrkSxPRhN6uxPmJ4QIlZ8OOBKuPPul5434Au8UWAzQX8p6tKLBBT
   Zpl9py/fg8YS1iTlPBkRCjssZG9x3x0gG2ftDqrO4AqL7L0X3oZRy+sIkG17h3GI
   CcHO596EGzhFPSa183kIwGXb4mI5nNUe43KkDXEyid/VIn27jokeqslfu2KQJnC1
   ggwLRgrNpeNO4pb7cK4aBu3oLZ0tPnhdbIG+bVgHE6a6ZYyBH266oJmNpqmNOTzn
   JjrgOt5gEB5JcL1VWXZ3lU3ukd5Jq/rGFkqytBj+uQccpuWkGUMqU82xjREES8D8
   AIHl4ghc6SM1jl2SqZR7aoAjP0uGwW31
   -----END CERTIFICATE-----
   EOF
   ```
   In subsequent steps, this `elastic-ece-ca-cert.pem` file is referred to as the `CA_CERTIFICATE_FILENAME` and used to add your own TLS/SSL certificates.


## Generate a CA certificate and X.509 certificate chain

The steps in this section provide high-level instructions on what you need to do if you do not already have a CA certificate and X.509 certificate chain. The method by which you generate the certificate and certificate chain differs by operating system, and the exact steps are outside the scope of these instructions.
The high-level steps to generate the necessary files include:
1. Generate a certificate authority (CA) RSA key pair.
2. Create a self-signed CA certificate.
3. Generate a server RSA key pair.
4. Create a certificate signing request (CSR) for server certificate with the common name and the alternative name set.
5. Sign the server CSR with CA key pair.
6. Concatenate the PEM encode server RSA private key, the server certificate, and the CA certificate into a single file.

Use the concatenated file containing the unencrypted RSA private key, server certificate, and CA certificate when adding your own TLS/SSL certificates in subsequent steps.
<note>
  If your organization already uses a CA certificate and X.509 certificate chain, you need to have these files ready. You also need your unencrypted RSA private key.
</note>


## Add a Cloud UI certificate

To add a Cloud UI certificate from the Cloud UI:
1. [Log into the Cloud UI](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/log-into-cloud-ui).
2. From the **Platform** menu, select **Settings**.
3. Under **TLS settings** for the Cloud UI, choose **Upload new certificate** and select a concatenated file containing your RSA private key, server certificate, and CA certificate. Upload the selected file.

To get the details of the certificate you added, select **Show certificate chain**.
To add a Cloud UI certificate from the command line:
1. Add the certificate for the Cloud UI to your ECE installation, where `CA_CERTIFICATE_FILENAME` is the name of the CA certificate you downloaded earlier and `CLOUDUI_PEM_FILENAME` is the name of the concatenated file containing your RSA private key, server certificate, and CA certificate:
   ```
   curl --cacert CA_CERTIFICATE_FILENAME -H 'Content-Type: application/json' --data-binary @CLOUDUI_PEM_FILENAME --user "admin:PASSWORD" "https://admin:12443/api/v1/platform/configuration/security/tls/ui"
   ```
2. Log out of the Cloud UI and log in again.
3. Verify that you are now using the new certificate chain. There should be no security warnings when you connect to the  Cloud UI over HTTPS in your web browser.
   Alternatively, you can also check the certificate using the openssl command:
   ```
   openssl s_client -CAfile CA_CERTIFICATE_FILENAME -showcerts -connect containerhost:12443 < /dev/zero
   ```

After adding your certificate, API requests made through the Cloud UI should use your certificate. When you use the `curl` command, include the path to your CA certificate with the `--cacert` parameter.

## Add a proxy certificate

To add a proxy certificate from the Cloud UI:
1. [Log into the Cloud UI](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/log-into-cloud-ui).
2. From the **Platform** menu, select **Settings**.
3. Under **TLS settings** for the proxy, choose **Upload new certificate** and select a concatenated file containing your RSA private key, server certificate, and CA certificate. Upload the file.
   To get the details of the certificate you added, select **Show certificate chain**.

To add a proxy certificate from the command line:
1. Add the wildcard certificate chain for the proxy to your ECE installation, where `CA_CERTIFICATE_FILENAME` is the name of the CA certificate you downloaded earlier and `PROXY_PEM_FILENAME` is the name of the concatenated file containing your RSA private key, server certificate, and CA certificate:
   ```
   curl --cacert CA_CERTIFICATE_FILENAME -H 'Content-Type: application/json' --data-binary @PROXY_PEM_FILENAME --user "admin:PASSWORD" "https://admin:12343/api/v1/platform/configuration/security/tls/proxy"
   ```
2. Log out of any Kibana instances you might be logged into and log in again.
3. Verify that you are now using the new certificate chain. There should be no security warnings when you connect to the Elasticsearch or Kibana endpoints over HTTPS in your web browser.
   Alternatively, you can also use the openssl command to check the proxy certificates, where HOSTNAME_OR_IP is the hostname or IP address of the proxy host:
   ```
   openssl s_client -CAfile CA_CERTIFICATE_FILENAME -showcerts -connect HOSTNAME_OR_IP:9243 < /dev/zero
   openssl s_client -CAfile CA_CERTIFICATE_FILENAME -showcerts -connect HOSTNAME_OR_IP:9343 < /dev/zero
   ```


## Add an Adminconsole certificate

<note>
  In Elastic Cloud Enterprise, this certificate is treated identically to the [Cloud UI certificate](#ece-tls-ui). You can use the same certificate bundle generated for Cloud UI.
</note>

To add an Adminconsole certificate from the Cloud UI:
1. [Log into the Cloud UI](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/log-into-cloud-ui).
2. From the **Platform** menu, select **Settings**.
3. Under **TLS settings** for the Adminconsole, choose **Upload new certificate** and select a concatenated file containing your RSA private key, server certificate, and CA certificate. Upload the selected file.

To get the details of the certificate you added, select **Show certificate chain**.
You can verify the new certificate chain by using the openssl command:
`openssl s_client -CAfile CA_CERTIFICATE_FILENAME -showcerts -connect containerhost:12343 < /dev/zero`

## Limitations

- You cannot add certificates signed by an internal certificate authority to be used for outbound connections.
- In versions 2.6 up to 2.10, some or all platform certificates were generated with a 398-day expiration. If your Elastic Cloud Enterprise installation ever ran on these versions, even momentarily before an upgrade, you must rotate the certificates manually before expiry. For details, check [our KB article](https://ela.st/ece-certificate-rotation).