﻿---
title: Secure your Elastic Cloud Enterprise installation
description: This section covers security settings for your Elastic Cloud Enterprise orchestrator. Orchestrator-level security Enforcing SELinux with RHEL/Podman installations:...
url: https://www.elastic.co/docs/deploy-manage/security/secure-your-elastic-cloud-enterprise-installation
products:
  - Elastic Cloud Enterprise
applies_to:
  - Elastic Cloud Enterprise: Generally available
---

# Secure your Elastic Cloud Enterprise installation
This section covers security settings for your Elastic Cloud Enterprise orchestrator.
**Orchestrator-level security**
- [**Enforcing SELinux with RHEL/Podman installations**](https://www.elastic.co/docs/deploy-manage/security/secure-your-elastic-cloud-enterprise-installation/migrate-ece-on-podman-hosts-to-selinux-enforce): SELinux (Security-Enhanced Linux) is a security module that enforces mandatory access controls, helping to protect systems from unauthorized access and privilege escalation.
- [**TLS certificates**](https://www.elastic.co/docs/deploy-manage/security/secure-your-elastic-cloud-enterprise-installation/manage-security-certificates): Apply security controls to network communications. With Elastic Cloud Enterprise, you manage proxy certificates for the HTTP layer. The transport layer is managed by ECE.
- [**Platform role-based access control**](https://www.elastic.co/docs/deploy-manage/users-roles/cloud-enterprise-orchestrator): Define the roles of users who have access to your organization and its resources. Note that you can also [manage non-cloud users and roles](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/defining-roles).
- [**Authentication providers**](https://www.elastic.co/docs/deploy-manage/users-roles/cloud-enterprise-orchestrator): Integrate with external authentication providers, including Active Directory, LDAP, and SAML.

**Additional deployment-level security settings**
Additional security settings are available for you to configure individually for each deployment orchestrated using Elastic Cloud Enterprise. Refer to [Secure your cluster, deployment, or project](https://www.elastic.co/docs/deploy-manage/security/secure-your-cluster-deployment) for more information.

## Notes about Elastic Cloud Enterprise security


### Users with admin privileges

In Elastic Cloud Enterprise, every user who can manage your installation through the Cloud UI or the RESTful API is a user with admin privileges. This includes both the `admin` user and the `readonly` user that get created when you install ECE on your first host. Initially, only the `admin` user has the required privileges to make changes to resources on ECE.
[Role-based access control](https://www.elastic.co/docs/deploy-manage/users-roles/cloud-enterprise-orchestrator/manage-users-roles) for Elastic Cloud Enterprise allows you to connect multiple users or user groups to the platform.
All Elasticsearch clusters come with X-Pack security features and support role-based access control. To learn more, check [Secure Your Clusters](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth).

### Encryption

Elastic Cloud Enterprise does not implement encryption at rest out of the box. To ensure encryption at rest for all data managed by Elastic Cloud Enterprise, the hosts running Elastic Cloud Enterprise must be configured with disk-level encryption, such as dm-crypt. In addition, snapshot targets must ensure that data is encrypted at rest as well.
Configuring dm-crypt or similar technologies is outside the scope of the Elastic Cloud Enterprise documentation, and issues related to disk encryption are outside the scope of support.
Elastic Cloud Enterprise provides full encryption of all network traffic by default.
TLS is supported when interacting with the [RESTful API of Elastic Cloud Enterprise](https://www.elastic.co/docs/api/doc/cloud-enterprise/) and for the proxy layer that routes user requests to clusters of all versions. Internally, our administrative services also ensure transport-level encryption.

### Attack vectors versus separation of roles

As covered in [Separation of Roles](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/ece-roles), it is important to not mix certain roles in a production environment.
Specifically, a host that is used as an allocator should hold *only* the allocator role. Allocators run the Elasticsearch and Kibana nodes that handle your workloads, which can expose a larger attack surface than the internal admin services. By separating the allocator role from other roles, you reduce any potential security exposure.
Elastic Cloud Enterprise is designed to ensure that an allocator has access only to the keys necessary to manage the clusters that it has been assigned. If there is a compromise of Elasticsearch or Kibana combined with a zero-day or Linux kernel exploit, for example, this design ensures that the entire Elastic Cloud Enterprise installation or clusters other than those already managed by that allocator are not affected.
Security comes in layers, and running separate services on separate infrastructure is the last layer of defense, on top of other security features like the JVM security manager, system call filtering, and running nodes in isolated containers with no shared secrets.

### Hardware isolation


The Elasticsearch clusters you create on Elastic Cloud Enterprise share the same resources. It is currently not possible to run a specific cluster on entirely dedicated hardware not shared by other clusters.