﻿---
title: Secure Kibana saved objects
description: Kibana stores entities such as dashboards, visualizations, alerts, actions, and advanced settings as saved objects, which are kept in a dedicated, internal...
url: https://www.elastic.co/docs/deploy-manage/security/secure-saved-objects
products:
  - Kibana
applies_to:
  - Elastic Cloud on Kubernetes: Generally available
  - Elastic Cloud Enterprise: Generally available
  - Self-managed Elastic deployments: Generally available
---

# Secure Kibana saved objects
Kibana stores entities such as dashboards, visualizations, alerts, actions, and advanced settings as saved objects, which are kept in a dedicated, internal Elasticsearch index. If such an object includes sensitive information, for example a PagerDuty integration key or email server credentials used by the alert action, Kibana encrypts it and makes sure it cannot be accidentally leaked or tampered with.
Encrypting sensitive information means that a malicious party with access to the Kibana internal indices won’t be able to extract that information without also knowing the encryption key.
Example [`kibana.yml`](https://www.elastic.co/docs/deploy-manage/stack-settings):
```yaml
xpack.encryptedSavedObjects:
  encryptionKey: "min-32-byte-long-strong-encryption-key"
```

<important>
  If you don’t specify an encryption key, Kibana might disable features that rely on encrypted saved objects.
</important>

<tip>
  For help generating the encryption key, refer to the [`kibana-encryption-keys`](https://www.elastic.co/docs/reference/kibana/commands/kibana-encryption-keys) script.
</tip>


## Encryption key rotation

Many policies and best practices stipulate that encryption keys should be periodically rotated to decrease the amount of content encrypted with one key and therefore limit the potential damage if the key is compromised. Kibana allows you to rotate encryption keys whenever there is a need.
When you change an encryption key, be sure to keep the old one for some time. Although Kibana only uses a new encryption key to encrypt all new and updated data, it still may need the old one to decrypt data that was encrypted using the old key. It’s possible to have multiple old keys used only for decryption. Kibana doesn’t automatically re-encrypt existing saved objects with the new encryption key. Re-encryption only happens when you update existing object or use the [rotate encryption key API](https://www.elastic.co/docs/api/doc/kibana/group/endpoint-saved-objects).
Here is how your [`kibana.yml`](https://www.elastic.co/docs/deploy-manage/stack-settings) might look if you use key rotation functionality:
```yaml
xpack.encryptedSavedObjects:
  encryptionKey: "min-32-byte-long-NEW-encryption-key" 
  keyRotation:
    decryptionOnlyKeys: ["min-32-byte-long-OLD#1-encryption-key", "min-32-byte-long-OLD#2-encryption-key"] 
```

<note>
  You might also leverage this functionality if multiple Kibana instances connected to the same Elasticsearch cluster use different encryption keys. In this case, you might have a mix of saved objects encrypted with different keys, and every Kibana instance can only deal with a specific subset of objects. To fix this, you must choose a single primary encryption key for `xpack.encryptedSavedObjects.encryptionKey`, move all other encryption keys to `xpack.encryptedSavedObjects.keyRotation.decryptionOnlyKeys`, and sync this configuration across all Kibana instances.
</note>

At some point, you might want to dispose of old encryption keys completely. Make sure there are no saved objects that Kibana encrypted with these encryption keys. You can use the [rotate encryption key API](https://www.elastic.co/docs/api/doc/kibana/group/endpoint-saved-objects) to determine which existing saved objects require decryption-only keys and re-encrypt them with the primary key.

## Docker configuration

It’s also possible to configure the encryption keys using [Docker environment variables](/docs/deploy-manage/deploy/self-managed/install-kibana-with-docker#environment-variable-config).
Docker environment variable examples:
```sh
XPACK_ENCRYPTEDSAVEDOBJECTS_ENCRYPTIONKEY="min-32-byte-long-NEW-encryption-key"
XPACK_ENCRYPTEDSAVEDOBJECTS_KEYROTATION_DECRYPTIONONLYKEYS[0]="min-32-byte-long-OLD#1-encryption-key"
XPACK_ENCRYPTEDSAVEDOBJECTS_KEYROTATION_DECRYPTIONONLYKEYS[1]="min-32-byte-long-OLD#2-encryption-key"
```