﻿---
title: TLS encryption for cluster communications
description: This page explains how to secure communications and set up TLS certificates in your Elastic Stack deployments. For Elastic Cloud Hosted deployments and...
url: https://www.elastic.co/docs/deploy-manage/security/secure-cluster-communications
products:
  - Elasticsearch
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Cloud Hosted: Generally available
  - Elastic Cloud on Kubernetes: Generally available
  - Elastic Cloud Enterprise: Generally available
  - Self-managed Elastic deployments: Generally available
---

# TLS encryption for cluster communications
This page explains how to secure communications and set up TLS certificates in your Elastic Stack deployments.
For Elastic Cloud Hosted deployments and Elastic Cloud Serverless projects, communication security is [fully managed by Elastic](/docs/deploy-manage/security#managed-security-in-elastic-cloud) with no configuration required, including TLS certificates.
For ECE, ECK, and self-managed deployments, some of this process can be automated, with opportunities for manual configuration depending on your requirements. This page provides specific configuration guidance to secure the various communication channels between components.
For a complete comparison of security feature availability and responsibility by deployment type, refer to [Security features by deployment type](/docs/deploy-manage/security#comparison-table).
<admonition title="Understanding transport contexts">
  The term *transport* can be confusing in Elasticsearch because it's used in two different contexts:
  - **Transport Layer Security (TLS)** is an industry-standard protocol that secures network communication. It's the modern name for SSL, and the Elastic documentation uses the terms TLS and SSL interchangeably.
  - In Elasticsearch, the **transport layer** refers to internal node-to-node communication, which occurs over port 9300. This communication uses the [transport interface](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/networking-settings), which implements a binary protocol specific to Elasticsearch.
  Keep this distinction in mind when configuring security settings.
</admonition>


## Communication channels overview

Both Elasticsearch and Kibana, the core components of the Elastic Stack, expose service endpoints that must be secured. Elasticsearch handles traffic at two levels:
- The **transport layer** (defaults to port `9300`), used for internal communication between nodes in the cluster.
- The **HTTP layer** (defaults to port `9200`), used by external clients — including Kibana — to send requests using the REST API.

Additionally, Kibana functions as a web server, exposing its own **HTTP endpoint** (defaults to port `5601`) to users, and also acts as a client when sending requests to Elasticsearch.
To ensure secure operation, it’s important to understand the communication channels and their specific security requirements.

| **Channel**                                                       | **Description**                                                               | **TLS requirements**                            |
|-------------------------------------------------------------------|-------------------------------------------------------------------------------|-------------------------------------------------|
| [Elasticsearch transport layer](#encrypt-internode-communication) | Communication between Elasticsearch nodes within a cluster                    | Mutual TLS/SSL required for multi-node clusters |
| [Elasticsearch HTTP layer](#encrypt-http-communication)           | Communication between external clients and Elasticsearch through the REST API | TLS/SSL optional (but recommended)              |
| [Kibana HTTP layer](#encrypt-http-communication)                  | Communication between external browsers or REST clients and Kibana            | TLS/SSL optional (but recommended)              |


### Transport layer security

The transport layer is used for communication between Elasticsearch nodes in a cluster. It relies on mutual TLS for both encryption and authentication of nodes.
Securing this layer prevents unauthorized nodes from joining your cluster and protects internode data. While implementing username and password authentication at the HTTP layer is useful for securing external access, the security of communication between nodes requires TLS.
The way that transport layer security is managed depends on your deployment type:
<applies-switch>
  <applies-item title="{ serverless:, ess: }" applies-to="Elastic Cloud Serverless: Generally available, Elastic Cloud Hosted: Generally available">
    Elasticsearch transport security is fully managed by Elastic, and no configuration is required.
  </applies-item>

  <applies-item title="ece:" applies-to="Elastic Cloud Enterprise: Generally available">
    Elasticsearch transport security is fully managed by the Elastic Cloud Enterprise platform, and no configuration is required.
  </applies-item>

  <applies-item title="eck:" applies-to="Elastic Cloud on Kubernetes: Generally available">
    Elasticsearch transport security and TLS certificates are automatically configured by the operator, but you can still [customize the Elasticsearch transport service, certificate authority, and certificates](https://www.elastic.co/docs/deploy-manage/security/k8s-transport-settings).
    <warning>
      Transport connections between Elasticsearch nodes are security-critical and you must protect them carefully. Malicious actors who can observe or interfere with node-to-node transport traffic can read or modify cluster data. A malicious actor who can establish a transport connection might be able to invoke system-internal APIs, including APIs that read or modify cluster data.If you choose to issue node transport certificates using an external CA, then carefully review [Using an external certificate authority to secure node-to-node connections](https://www.elastic.co/docs/deploy-manage/security/external-ca-transport) to ensure that your certificates meet the security requirements for transport connections.
    </warning>
  </applies-item>

  <applies-item title="self:" applies-to="Self-managed Elastic deployments: Generally available">
    Elasticsearch transport security can be [automatically configured](https://www.elastic.co/docs/deploy-manage/security/self-auto-setup), or manually set up by following the steps in [Set up transport TLS](https://www.elastic.co/docs/deploy-manage/security/set-up-basic-security).For additional TLS configuration options, refer to [Manage TLS encryption in self-managed deployments](https://www.elastic.co/docs/deploy-manage/security/self-tls).
    <warning>
      Transport connections between Elasticsearch nodes are security-critical and you must protect them carefully. Malicious actors who can observe or interfere with node-to-node transport traffic can read or modify cluster data. A malicious actor who can establish a transport connection might be able to invoke system-internal APIs, including APIs that read or modify cluster data.If you choose to issue node transport certificates using an external CA, then carefully review [Using an external certificate authority to secure node-to-node connections](https://www.elastic.co/docs/deploy-manage/security/external-ca-transport) to ensure that your certificates meet the security requirements for transport connections.
    </warning>
  </applies-item>
</applies-switch>


### HTTP layer security

The HTTP layer includes the service endpoints exposed by both Elasticsearch and Kibana, supporting communications such as REST API requests, browser access to Kibana, and Kibana’s own traffic to Elasticsearch. Securing these endpoints helps prevent unauthorized access and protects sensitive data in transit.
<important>
  While HTTP TLS encryption is optional in self-managed environments, it is strongly recommended for both production and non-production deployments. Even in non-production environments, unsecured endpoints can expose sensitive data or introduce avoidable risks.
</important>

The way that HTTP layer security is managed depends on your deployment type:
<applies-switch>
  <applies-item title="{ serverless:, ess: }" applies-to="Elastic Cloud Serverless: Generally available, Elastic Cloud Hosted: Generally available">
    HTTP TLS for Elasticsearch and Kibana is fully managed by Elastic. No configuration is required.
    Kibana instances are automatically configured to connect securely to Elasticsearch, without requiring manual setup.
  </applies-item>

  <applies-item title="ece:" applies-to="Elastic Cloud Enterprise: Generally available">
    HTTP TLS for deployments is managed at the platform proxy level. Refer to these guides for ECE-specific security customizations:
    - [Manage security certificates in ECE](https://www.elastic.co/docs/deploy-manage/security/secure-your-elastic-cloud-enterprise-installation/manage-security-certificates)
    - [Allow x509 Certificates Signed with SHA-1](https://www.elastic.co/docs/deploy-manage/security/secure-your-elastic-cloud-enterprise-installation/allow-x509-certificates-signed-with-sha-1)
    - [Configure TLS version](https://www.elastic.co/docs/deploy-manage/security/secure-your-elastic-cloud-enterprise-installation/configure-tls-version)
    Kibana instances are automatically configured to connect securely to Elasticsearch, without requiring manual setup.
  </applies-item>

  <applies-item title="eck:" applies-to="Elastic Cloud on Kubernetes: Generally available">
    HTTP TLS is automatically enabled for Elasticsearch and Kibana using self-signed certificates, with [several options available for customization](https://www.elastic.co/docs/deploy-manage/security/k8s-https-settings), including custom certificates and domain names.
    Kibana instances are automatically configured to connect securely to Elasticsearch, without requiring manual setup.
  </applies-item>

  <applies-item title="self:" applies-to="Self-managed Elastic deployments: Generally available">
    HTTP TLS certificates for Elasticsearch can be [automatically configured](https://www.elastic.co/docs/deploy-manage/security/self-auto-setup), or manually set up by following the steps in [Set up HTTP SSL](https://www.elastic.co/docs/deploy-manage/security/set-up-basic-security-plus-https).Kibana acts as both an HTTP client to Elasticsearch and a server for browser access. It performs operations on behalf of users, so it must be properly configured to trust the Elasticsearch certificates, and to present its own TLS certificate for secure browser connections. These configurations must be performed manually in self-managed deployments.
    <note>
      The automatic configuration does not enable TLS on the Kibana HTTP endpoint. To encrypt browser traffic to Kibana, follow the steps in [Set up HTTPS > Encrypt traffic between your browser and Kibana](/docs/deploy-manage/security/set-up-basic-security-plus-https#encrypt-kibana-browser).
    </note>
    For environments with stricter security requirements, refer to [Mutual TLS authentication between Kibana and Elasticsearch](https://www.elastic.co/docs/deploy-manage/security/kibana-es-mutual-tls).For additional TLS configuration options, refer to [Manage TLS encryption in self-managed deployments](https://www.elastic.co/docs/deploy-manage/security/self-tls).
  </applies-item>
</applies-switch>


## Certificates lifecycle

Managing certificates is critical for secure communications. Certificates have limited lifetimes and must be renewed before expiry to prevent service disruptions. Each deployment type provides different tools or responsibilities for managing certificates lifecycle.
<applies-switch>
  <applies-item title="{ serverless:, ess: }" applies-to="Elastic Cloud Serverless: Generally available, Elastic Cloud Hosted: Generally available">
    Certificate lifecycle is fully managed by Elastic, including renewal and rotation.
  </applies-item>

  <applies-item title="ece:" applies-to="Elastic Cloud Enterprise: Generally available">
    In ECE, the platform automatically renews internal certificates. However, you must manually renew your custom proxy and Cloud UI certificates. For more details, refer to [Manage security certificates](https://www.elastic.co/docs/deploy-manage/security/secure-your-elastic-cloud-enterprise-installation/manage-security-certificates).
  </applies-item>

  <applies-item title="eck:" applies-to="Elastic Cloud on Kubernetes: Generally available">
    ECK provides flexible options for managing SSL certificates in your deployments, including automatic certificate generation and rotation, integration with external tools like `cert-manager`, or using your own custom certificates. Custom HTTP certificates require manual management.
    ECK automatically rotates any certificates and CAs that were generated by the operator and are under its management.
    For certificate management configuration options, refer to [ECK configuration flags](https://www.elastic.co/docs/reference/cloud-on-k8s/eck-configuration-flags).
  </applies-item>

  <applies-item title="self:" applies-to="Self-managed Elastic deployments: Generally available">
    You are responsible for certificate lifecycle management, including monitoring expiration dates, renewing certificates, and redeploying them as needed. If you used Elastic tools to generate your certificates, refer to [Update TLS certificates](https://www.elastic.co/docs/deploy-manage/security/updating-certificates) for guidance on rotating or replacing them.
  </applies-item>
</applies-switch>