﻿---
title: Secure other Elastic Stack components
description: The Elasticsearch security features enable you to secure your Elasticsearch cluster. However, Elasticsearch itself is only one product within the Elastic...
url: https://www.elastic.co/docs/deploy-manage/security/secure-clients-integrations
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Hosted: Generally available
  - Elastic Cloud on Kubernetes: Generally available
  - Elastic Cloud Enterprise: Generally available
  - Self-managed Elastic deployments: Generally available
---

# Secure other Elastic Stack components
The Elasticsearch security features enable you to secure your Elasticsearch cluster. However, Elasticsearch itself is only one product within the Elastic Stack. Other products in the Elastic Stack are connected to the cluster and therefore need to be secured as well, or at least communicate with the cluster in a secured way. Review the guides for other Elasticsearch products:
- [Apache Hadoop](https://www.elastic.co/docs/reference/elasticsearch-hadoop/security)
- [Auditbeat](https://www.elastic.co/docs/reference/beats/auditbeat/securing-auditbeat)
- [Filebeat](https://www.elastic.co/docs/reference/beats/filebeat/securing-filebeat)
- [Fleet & Elastic Agent](https://www.elastic.co/docs/reference/fleet/secure)
- [Heartbeat](https://www.elastic.co/docs/reference/beats/heartbeat/securing-heartbeat)
- [Logstash](https://www.elastic.co/docs/reference/logstash/secure-connection)
- [Metricbeat](https://www.elastic.co/docs/reference/beats/metricbeat/securing-metricbeat)
- [Packetbeat](https://www.elastic.co/docs/reference/beats/packetbeat/securing-packetbeat)
- [Reporting](https://www.elastic.co/docs/explore-analyze/report-and-share)
- [Winlogbeat](https://www.elastic.co/docs/reference/beats/winlogbeat/securing-winlogbeat)