﻿---
title: Remote cluster filtering
description: In Elastic Cloud Hosted (ECH) and Elastic Cloud Enterprise (ECE), remote cluster filters let you control incoming traffic from other deployments that...
url: https://www.elastic.co/docs/deploy-manage/security/remote-cluster-filtering
applies_to:
  - Elastic Cloud Hosted: Generally available
  - Elastic Cloud Enterprise: Generally available
---

# Remote cluster filtering
In Elastic Cloud Hosted (ECH) and Elastic Cloud Enterprise (ECE), remote cluster filters let you control incoming traffic from other deployments that use the [remote clusters functionality](https://www.elastic.co/docs/deploy-manage/remote-clusters) with API key–based authentication.
<note>
  In the case of remote clusters, the Elasticsearch cluster or deployment initiating the connection and requests is often referred to as the **local cluster**, while the Elasticsearch cluster or deployment receiving the requests is referred to as the **remote cluster**.
</note>

These filters are supported only when the local and remote clusters run on the same platform (both on the same ECE environment, or both on ECH), as they rely on the certificates and proxy mechanisms provided by these environments.
Refer to [Remote clusters and network security](/docs/deploy-manage/remote-clusters#network-security) for more information about the remote clusters functionality, its relationship to network security, and the supported [use cases](/docs/deploy-manage/remote-clusters#use-cases-network-security).

## How remote cluster filters work

Remote cluster filters operate at the proxy level, allowing incoming connections based on the organization ID or Elasticsearch cluster ID of the local cluster that initiates the connection to the remote cluster service endpoint (default port `9443`).
<note>
  In Elastic Cloud Enterprise, the equivalent of the organization ID in Elastic Cloud Hosted is the **environment ID**, which serves the same purpose for remote cluster filtering.
</note>

Because of [how network security works](/docs/deploy-manage/security/network-security#how-network-security-works), these filters are only relevant when network security is enabled on the remote cluster.
- If network security is disabled, all traffic is allowed by default and remote clusters work without any filtering policy.
- If network security is enabled, all traffic is blocked unless explicitly allowed. In this case, you must add a remote cluster filter in the remote cluster to permit remote cluster connections from the local clusters.

To apply a filter to a deployment, you must first create a security policy at the organization or platform level, and then apply it to your deployment.
This guide covers the following remote cluster filtering tasks:
- [Create a remote cluster filter](#create-remote-cluster-filter)
- [Associate a remote cluster filter with your deployment](#apply-remote-cluster-filter)
- [Remove a filter association from your deployment](#remove-association)
- [Edit a remote cluster filter](#edit-remote-cluster-filter)
- [Delete a remote cluster filter](#delete-remote-cluster-filter)


## Create a remote cluster filter

<applies-switch>
  <applies-item title="ess:" applies-to="Elastic Cloud Hosted: Generally available">
    Remote cluster filters are presented in Elastic Cloud as a type of Private Connection filter. To create a remote cluster filter:
    1. Log in to the [Elastic Cloud Console](https://cloud.elastic.co?page=docs&placement=docs-body).
    2. From any deployment or project on the home page, select **Manage**.
    3. From the left navigation menu, select **Access and security** > **Network security**.

    1. Select **Create** > **Private connection**.
    2. Select the cloud provider and region for the remote cluster filter.
       <note>
       Network security policies are bound to a single region, and can be assigned only to deployments or projects in the same region. If you want to associate a policy with resources in multiple regions, then you have to create the same policy in all the regions you want to apply it to.
       </note>
    3. Under **Connectivity**, select **Remote cluster**.
    4. Add a meaningful name and description for the filter.
    5. In the **Organization ID** and **Elasticsearch ID** fields, enter the organization or cluster ID of the Elastic Cloud deployments from which you want to allow traffic. Provide one or both values; traffic is allowed if it matches either ID. To add multiple rules to the filter, use the plus (`+`) button.
       <tip>
       You can find the organization ID on the organization page in the top-right menu, and the Elasticsearch cluster ID of a deployment by selecting **Copy cluster ID** on the deployment management page.
       </tip>
    6. Optional: Under **Apply to resources**, associate the new filter with one or more deployments. After you associate the filter with a deployment, it will allow remote cluster traffic coming from the organization or Elasticsearch IDs defined in the rules.
       <note>
       You can apply multiple policies to a single deployment. For Elastic Cloud Hosted deployments, you can apply both IP filter policies and private connection policies. In case of multiple policies, traffic can match any associated policy to be forwarded to the resource. If none of the policies match, the request is rejected with `403 Forbidden`.[Learn more about how network security policies affect your deployment](https://www.elastic.co/docs/deploy-manage/security/network-security-policies).
       </note>
    7. To automatically attach this filter to new deployments, select **Apply by default**.
    8. Click **Create**.
  </applies-item>

  <applies-item title="ece:" applies-to="Elastic Cloud Enterprise: Generally available">
    To create a remote cluster filter:
    1. [Log into the Cloud UI](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/log-into-cloud-ui).
    2. From the **Platform** menu, select **Security**.
    3. Select **Create filter**.
    4. Select **Remote cluster rule set** as the filter type.
    5. Add a meaningful name and description for the rule set.
    6. In the **Organization ID** and **Elasticsearch ID** fields, enter the ECE environment ID or cluster ID of the deployments from which you want to allow traffic.
       - Use the **ECE environment ID** as the organization ID to allow traffic from all deployments in that environment.
    - Use the **Elasticsearch cluster ID** to allow traffic only from specific deployments.
       Provide one or both values; traffic is allowed if it matches either ID. To add multiple rules to the filter, use the plus (`+`) button.
       <tip>
       You can find the ECE environment ID under **Platform → Trust Management → Trust parameters**, and the Elasticsearch cluster ID of a deployment by selecting **Copy cluster ID** on the deployment management page.
       </tip>
    7. Select if this rule set should be automatically attached to new deployments.
    8. Select **Create filter** to create the remote cluster filter.
  </applies-item>
</applies-switch>


## Associate a remote cluster filter with your deployment

After you've created the network security policy or rule set, you'll need to associate it with your deployment. To do that:
<applies-switch>
  <applies-item title="ess:" applies-to="Elastic Cloud Hosted: Generally available">
    #### From a deployment

    1. Find your deployment on the home page or on the **Hosted deployments** page, then select **Manage** to access its settings menus.
       On the **Hosted deployments** page, you can narrow your deployments by name, ID, or choose from several other filters. To customize your view, use a combination of filters, or change the format from a grid to a list.
    2. On the **Security** page, under **Network security**, select **Apply policies** > **Private connection**.
    3. Choose the policy you want to apply and select **Apply**.


    #### From the policy settings

    1. Log in to the [Elastic Cloud Console](https://cloud.elastic.co?page=docs&placement=docs-body).
    2. From any deployment or project on the home page, select **Manage**.
    3. From the left navigation menu, select **Access and security** > **Network security**.

    1. Find the policy you want to edit.
    2. Under **Apply to resources**, associate the policy with one or more deployments.
    3. Click **Update** to save your changes.
  </applies-item>

  <applies-item title="ece:" applies-to="Elastic Cloud Enterprise: Generally available">
    1. Open the deployment management page in the Cloud UI.
    2. Select the **Security** tab on the left-hand side menu bar.
    3. Under **Traffic filters**, select **Apply filter**.
    4. Choose the filter you want to apply and select **Apply filter**.
  </applies-item>
</applies-switch>


## Remove a filter association from your deployment

To remove a network security policy or rule set association from your deployment:
<applies-switch>
  <applies-item title="ess:" applies-to="Elastic Cloud Hosted: Generally available">
    You can remove associations from your deployments directly from the policy settings or from the deployment security page.

    #### From your deployment security page

    1. Log in to the [Elastic Cloud Console](https://cloud.elastic.co?page=docs&placement=docs-body).
    2. On the **Hosted deployments** page, select your deployment.
    3. Select the **Security** tab on the left-hand side menu bar.
    4. Under **Network security**, find the security policy you want to disconnect.
    5. Under **Actions**, click the **Delete** icon.


    #### From the network security policy settings

    1. Log in to the [Elastic Cloud Console](https://cloud.elastic.co?page=docs&placement=docs-body).
    2. From any deployment or project on the home page, select **Manage**.
    3. From the left navigation menu, select **Access and security** > **Network security**.

    1. Find the remote cluster policy you want to edit, then select the **Edit** `pencil` button.
    2. Under **Apply to resources**, click the `x` beside the resource that you want to disconnect.
    3. Click **Update** to save your changes.
  </applies-item>

  <applies-item title="ece:" applies-to="Elastic Cloud Enterprise: Generally available">
    1. Open the deployment management page in the Cloud UI.
    2. Select the **Security** tab on the left-hand side menu bar.
    3. Under **Traffic filters**, choose the filter you want to detach and select the **X** icon in the **Actions** column.
    4. In the confirmation dialog, select **Remove filter**.
  </applies-item>
</applies-switch>


## Edit a remote cluster filter

You can edit a remote cluster filter policy name or change the list of allowed Organization IDs and Elasticsearch cluster IDs. To do that:
<applies-switch>
  <applies-item title="ess:" applies-to="Elastic Cloud Hosted: Generally available">
    1. Log in to the [Elastic Cloud Console](https://cloud.elastic.co?page=docs&placement=docs-body).
    2. From any deployment or project on the home page, select **Manage**.
    3. From the left navigation menu, select **Access and security** > **Network security**.

    1. Find the remote cluster policy you want to edit, then select the **Edit** `pencil` button.
    2. Select **Update** to save your changes.
  </applies-item>

  <applies-item title="ece:" applies-to="Elastic Cloud Enterprise: Generally available">
    1. [Log into the Cloud UI](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/log-into-cloud-ui).
    2. From the **Platform** menu, select **Security**.
    3. Find the rule set you want to edit.
    4. Select the **Edit** `pencil` button.
    5. Click **Update** to save your changes.
  </applies-item>
</applies-switch>


## Delete a remote cluster filter

If you need to remove a remote cluster filter policy, you must first [remove any associations](#remove-association) with deployments.
To delete a filter:
<applies-switch>
  <applies-item title="ess:" applies-to="Elastic Cloud Hosted: Generally available">
    1. Log in to the [Elastic Cloud Console](https://cloud.elastic.co?page=docs&placement=docs-body).
    2. From any deployment or project on the home page, select **Manage**.
    3. From the left navigation menu, select **Access and security** > **Network security**.

    1. Find the rule set you want to edit, then select the **Delete** `trash` button. The icon is inactive if there are deployments associated with the filter.
  </applies-item>

  <applies-item title="ece:" applies-to="Elastic Cloud Enterprise: Generally available">
    1. [Log into the Cloud UI](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/log-into-cloud-ui).
    2. From the **Platform** menu, select **Security**.
    3. Find the rule set you want to edit.
    4. Click the **Delete** `trash` button. The button is inactive if there are deployments assigned to the rule set.
  </applies-item>
</applies-switch>