﻿---
title: Private connectivity
description: Private connectivity is a secure way for your Elastic Cloud deployments and projects to communicate with other cloud provider services over your cloud...
url: https://www.elastic.co/docs/deploy-manage/security/private-connectivity
products:
  - Elastic Cloud Hosted
applies_to:
  - Elastic Cloud Hosted: Generally available
---

# Private connectivity
Private connectivity is a secure way for your Elastic Cloud deployments and projects to communicate with other cloud provider services over your cloud provider's private network. You can create a virtual private connection (VPC) using your provider's private link service, and then manage it in Elastic Cloud using a private connection policy. You can also optionally filter traffic to your deployments by creating ingress filters for your VPC in Elastic Cloud.
<tip>
  Private connection policies are a type of [network security policy](https://www.elastic.co/docs/deploy-manage/security/network-security-policies).
</tip>

Choose the relevant option for your cloud service provider:

| Cloud service provider | Service                                                                                                    |
|------------------------|------------------------------------------------------------------------------------------------------------|
| AWS                    | [AWS PrivateLink](https://www.elastic.co/docs/deploy-manage/security/private-connectivity-aws)             |
| Azure                  | [Azure Private Link](https://www.elastic.co/docs/deploy-manage/security/private-connectivity-azure)        |
| GCP                    | [GCP Private Service Connect](https://www.elastic.co/docs/deploy-manage/security/private-connectivity-gcp) |

After you set up your private connection, you can [claim ownership of your private connection ID](https://www.elastic.co/docs/deploy-manage/security/claim-private-connection-api) to prevent other organizations from using it.
To learn how private connection policies work, how they affect your deployment, and how they interact with [IP filter policies](https://www.elastic.co/docs/deploy-manage/security/ip-filtering-cloud), refer to [Network security policies in Elastic Cloud](https://www.elastic.co/docs/deploy-manage/security/network-security-policies).
<tip>
  Elastic Cloud Hosted and Elastic Cloud Serverless also support [IP filters](https://www.elastic.co/docs/deploy-manage/security/ip-filtering-cloud). You can apply both IP filters and private connections to a single Elastic Cloud resource.
</tip>

<note>
  Private connection policies were formerly referred to as PrivateLink traffic filters.
</note>