﻿---
title: Network security
description: Network security allows you to control how your deployments and clusters can be accessed. Add another layer of security to your installation and deployments...
url: https://www.elastic.co/docs/deploy-manage/security/network-security
products:
  - Elastic Cloud Enterprise
  - Elastic Cloud Hosted
  - Elastic Cloud Serverless
  - Elastic Cloud on Kubernetes
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Cloud Hosted: Generally available
  - Elastic Cloud on Kubernetes: Generally available
  - Elastic Cloud Enterprise: Generally available
  - Self-managed Elastic deployments: Generally available
---

# Network security
Network security allows you to control how your deployments and clusters can be accessed. Add another layer of security to your installation and deployments by restricting traffic to only the sources that you trust.
Elastic also offers other network security features, such as TLS encryption. For an overview of the available security features, refer to [Security](https://www.elastic.co/docs/deploy-manage/security).
<note>
  The network security feature was formerly referred to as traffic filtering.Network security policies were formerly referred to as traffic filter rules.
</note>


## Network security methods

Depending on your deployment type you can use different mechanisms to control access.
<note>
  This section covers network security at the deployment level. If you need the IP addresses used by Elastic Cloud Hosted to configure them in your network firewalls, refer to [Elastic Cloud Static IPs](https://www.elastic.co/docs/deploy-manage/security/elastic-cloud-static-ips).You can also allow traffic to or from a [remote cluster](https://www.elastic.co/docs/deploy-manage/remote-clusters) for use with cross-cluster replication or search.
</note>


| Filter type                                                                                                       | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | Applicable deployment types                                                                               |
|-------------------------------------------------------------------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------|
| [IP filters](https://www.elastic.co/docs/deploy-manage/security/ip-filtering)                                     | Filter traffic from the public internet by allowlisting specific IP addresses and Classless Inter-Domain Routing (CIDR) masks.• [In Serverless or ECH](https://www.elastic.co/docs/deploy-manage/security/ip-filtering-cloud)• [In ECE](https://www.elastic.co/docs/deploy-manage/security/ip-filtering-ece)• [In ECK or self-managed](https://www.elastic.co/docs/deploy-manage/security/ip-filtering-basic)                                                                                                                                                                                          | Serverless, ECH, ECE, ECK, and self-managed clusters                                                      |
| [Remote cluster filters](https://www.elastic.co/docs/deploy-manage/security/remote-cluster-filtering)             | Filter incoming remote cluster traffic by validating the client certificate against its `organization_id` and `cluster_id`.Only applicable with the API key–based authentication model.Not supported for ECE → ECH traffic.                                                                                                                                                                                                                                                                                                                                                                            | ECH and ECE, limited to [these use cases](/docs/deploy-manage/remote-clusters#use-cases-network-security) |
| [Private connectivity and VPC filtering](https://www.elastic.co/docs/deploy-manage/security/private-connectivity) | Establish private connections between Elasticsearch and other resources hosted by the same cloud provider using private link services, and further secure these connections using VPC filtering. Choose the relevant option for your region:• AWS regions: [AWS PrivateLink](https://www.elastic.co/docs/deploy-manage/security/private-connectivity-aws)• Azure regions: [Azure Private Link](https://www.elastic.co/docs/deploy-manage/security/private-connectivity-azure)• GCP regions: [GCP Private Service Connect](https://www.elastic.co/docs/deploy-manage/security/private-connectivity-gcp) | Elastic Cloud Hosted only                                                                                 |
| [Kubernetes network policies](https://www.elastic.co/docs/deploy-manage/security/k8s-network-policies)            | Isolate pods by restricting incoming and outgoing network connections to a trusted set of sources and destinations.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | Elastic Cloud on Kubernetes only                                                                          |

<tip>
  Elastic recommends that you use Kubernetes network policies over IP filters for Elastic Cloud on Kubernetes. This is because, in containerized environments like Kubernetes, IP addresses are usually dynamic, making network policies a more robust option.
</tip>


## How network security works

<applies-to>
  - Elastic Cloud Serverless: Generally available
  - Elastic Cloud Hosted: Generally available
  - Elastic Cloud Enterprise: Generally available
</applies-to>

By default, in Elastic Cloud Serverless, Elastic Cloud Hosted, and Elastic Cloud Enterprise, all external traffic is allowed. After you apply a network security mechanism, such as an IP filtering rule in an Elastic Cloud Enterprise deployment or a network security policy in an Elastic Cloud deployment or project, only traffic that matches the configured rules or policies is allowed; all other traffic is denied.
For details about how these policies and rules interact with your deployment or project, other policies or rules, and the internet, refer to the topic for your deployment type:
- [Network security policies in Elastic Cloud](https://www.elastic.co/docs/deploy-manage/security/network-security-policies)
- [IP filtering rules in Elastic Cloud Enterprise](https://www.elastic.co/docs/deploy-manage/security/ece-filter-rules)

<note>
  For details about how basic IP filters and Kubernetes network policies impact your cluster, refer to the guide for the feature:
  - [Manage IP filtering in ECK and self-managed clusters](https://www.elastic.co/docs/deploy-manage/security/ip-filtering-basic)
  - [Kubernetes network policies](https://www.elastic.co/docs/deploy-manage/security/k8s-network-policies)
</note>