﻿---
title: Manage network security through the API
description: This example demonstrates how to use the Elastic Cloud RESTful API, Elastic Cloud Enterprise RESTful API, or Elastic Cloud Serverless RESTful API or to...
url: https://www.elastic.co/docs/deploy-manage/security/network-security-api
products:
  - Elastic Cloud Enterprise
  - Elastic Cloud Hosted
  - Elastic Cloud Serverless
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Cloud Hosted: Generally available
  - Elastic Cloud Enterprise: Generally available
---

# Manage network security through the API
This example demonstrates how to use the Elastic Cloud RESTful API, Elastic Cloud Enterprise RESTful API, or Elastic Cloud Serverless RESTful API or to manage different types of network security policies and rules.
We cover the following examples:
- [Create an IP filter policy or IP filtering rule set](#create-ip-filter-policy)
  - [Ingress](#ip-filter-policy-ingress)
- [Egress](#ip-filter-policy-egress) <applies-to>Elastic Cloud Hosted: Beta</applies-to>
- [Create a private connection policy](#private-connection) <applies-to>Elastic Cloud Hosted: Generally available</applies-to>
  - [AWS Privatelink](#private-connection-policy-aws)
- [Azure Private Link](#private-connection-policy-azure)
- [GCP Private Service Connect](#private-connection-policy-gcp)
- [Update a policy or rule set](#update-policy-rs)
- [Associate a policy or rule set with a project or deployment](#associate-policy-rs-with-deployment)
- [Remove a policy or rule set from a project or deployment](#delete-policy-rs-association-with-deployment)
- [Delete a policy or rule set](#delete-policy-rs)

Refer to [Network security](https://www.elastic.co/docs/deploy-manage/security/network-security) to learn more about network security across all deployment types.
<tip>
  Policies in Elastic Cloud are the equivalent of rule sets in Elastic Cloud Enterprise and the Elastic Cloud API.
</tip>


## API reference

To learn more about these endpoints, refer to the reference for your deployment type:
- [Elastic Cloud API](https://www.elastic.co/docs/api/doc/cloud/group/endpoint-deploymentstrafficfilter)
- [Elastic Cloud Enterprise API](https://www.elastic.co/docs/api/doc/cloud-enterprise/group/endpoint-deploymentstrafficfilter)


## Terminology in the Elastic Cloud console and APIs

<applies-to>
  - Elastic Cloud Serverless: Generally available
  - Elastic Cloud Hosted: Generally available
</applies-to>

In Elastic Cloud, terminology related to network security has changed to more accurately reflect functionality. Terminology in the related APIs has not yet been updated.

| Elastic Cloud concept     | API terminology             |
|---------------------------|-----------------------------|
| Network security          | Traffic filters             |
| Network security policy   | Traffic filter              |
| IP filter policy          | IP filtering rule set       |
| IP filter source          | IP filter rule              |
| Private connection policy | Private link traffic filter |
| VPC filter                | Private link filter rule    |


## Create an IP filter policy or IP filtering rule set

IP filter policies in Elastic Cloud are the equivalent of IP filtering rule sets in Elastic Cloud Enterprise.
Both policies and rule sets consist of multiple unique entries, each representing a source IP address or CIDR range. In Elastic Cloud, these entries are referred to as sources. In Elastic Cloud Enterprise and the Elastic Cloud API, these entries are referred to as rules.

### Ingress

Send a request like the following to create an IP filter ingress policy or rule set:
<applies-switch>
  <applies-item title="serverless:" applies-to="Elastic Cloud Serverless: Generally available">
    ```json
    curl \
    -H "Authorization: ApiKey $API_KEY" \
    -H 'content-type: application/json' \
    https://api.elastic-cloud.com/api/v1/serverless/traffic-filters \
    -d '
    {
      "name": "My ingress IP filter policy",
      "region": "ap-southeast-1" 
      "description": "",
      "type": "ip", 
      "rules": [
        {
          "description": "Allow inbound traffic from IP address 192.168.131.0",
          "source": "192.168.131.0"
        },
        {
          "description": "Allow inbound traffic within CIDR block 192.168.132.6/22",
          "source": "192.168.132.6/22"
        }
      ],
      "include_by_default": false
    }
    '
    ```
  </applies-item>

  <applies-item title="ess:" applies-to="Elastic Cloud Hosted: Generally available">
    ```json
    curl \
    -H "Authorization: ApiKey $API_KEY" \
    -H 'content-type: application/json' \
    https://api.elastic-cloud.com/api/v1/deployments/traffic-filter/rulesets \
    -d '
    {
      "name": "My ingress IP filter policy",
      "region": "azure-japaneast", 
      "description": "",
      "type": "ip", 
      "rules": [
        {
          "description": "Allow inbound traffic from IP address 192.168.131.0",
          "source": "192.168.131.0"
        },
        {
          "description": "Allow inbound traffic within CIDR block 192.168.132.6/22",
          "source": "192.168.132.6/22"
        }
      ],
      "include_by_default": false
    }
    '
    ```
  </applies-item>

  <applies-item title="ece:" applies-to="Elastic Cloud Enterprise: Generally available">
    ```json
    curl \
    -H "Authorization: ApiKey $API_KEY" \
    -H 'content-type: application/json' \
    https://$COORDINATOR_HOST:12443/api/v1/deployments/traffic-filter/rulesets \
    -d '
    {
      "name": "My IP filtering Ingress Rule Set",
      "region": "ece-region",
      "description": "",
      "type": "ip",
      "rules": [
        {
          "description": "Allow inbound traffic from IP address 192.168.131.0",
          "source": "192.168.131.0"
        },
        {
          "description": "Allow inbound traffic within CIDR block 192.168.132.6/22",
          "source": "192.168.132.6/22"
        }
      ],
      "include_by_default": false
    }
    '
    ```
  </applies-item>
</applies-switch>

If the request is successful, a response containing an ID for the policy or rule set is returned. This ID is required to update or delete the policy or rule set itself, or it can be used to associate the policy or rule set to a deployment or project. It is referred to as `$POLICY_ID` or `$RULESET_ID` in the following examples.
```json
{
  "id" : "5470a0010ebf437bb9294ea9fcba0ba0"
}
```


### Egress

<applies-to>
  - Elastic Cloud Hosted: Beta
</applies-to>

Send a request like the following to create an IP filter ingress policy:
```json
curl \
-H "Authorization: ApiKey $API_KEY" \
-H 'content-type: application/json' \
https://api.elastic-cloud.com/api/v1/deployments/traffic-filter/rulesets \
-d '
{
  "name": "My IP filtering Egress Rule Set",
  "region": "azure-japaneast",
  "description": "",
  "type": "egress_firewall",
  "rules": [
    {
       "description": "Allow outbound traffic to IP address 192.168.131.0",
       "egress_rule":
       {
           "target": "192.168.131.0",
           "protocol": "all" 
       }
    },
    {
       "description": "Allow outbound traffic to CIDR block 192.168.132.6/22",
       "egress_rule":
       {
           "target": "192.168.132.6/22",
           "protocol": "all"
       }
    },
  ],
  "include_by_default": false
}
'
```


## Create a private connection policy

<applies-to>
  - Elastic Cloud Hosted: Generally available
</applies-to>

Learn how to create a private connection policy using the Elastic Cloud API. In the API, a VPC filter in a private connection policy is referred to as a rule.
<tip>
  Private connection policies are optional for AWS PrivateLink and GCP Private Service Connect. After the VPC endpoint and DNS record are created, private connectivity is established. For these services, a private connection policy is only required to filter traffic to your deployment using VPC filters.A private connection policy is always required to establish a private connection with Azure Private Link.
</tip>


### AWS Privatelink

Send a request like the following to create an AWS PrivateLink private connection policy:
```json
curl -XPOST \
-H "Authorization: ApiKey $API_KEY" \
-H 'content-type: application/json' \
https://api.elastic-cloud.com/api/v1/deployments/traffic-filter/rulesets \
-d '
{
  "name": "AWS Private Link private connection policy",
  "region": "ap-northeast-1",
  "description": "",
  "type": "vpce",
  "rules": [
    {
      "source": "vpce-00000000000" 
    }
  ],
  "include_by_default": false
}
'
```


### Azure Private Link

Send a request like the following to create an Azure Private Link private connection policy:
```json
curl -XPOST \
-H "Authorization: ApiKey $API_KEY" \
-H 'content-type: application/json' \
https://api.elastic-cloud.com/api/v1/deployments/traffic-filter/rulesets \
-d '
{
  "name": "Azure Private Link private connection policy",
  "region": "azure-japaneast",
  "description": "",
  "type": "azure_private_endpoint",
  "rules": [
    {
      "azure_endpoint_name": "azure-demo", 
      "azure_endpoint_guid": "7c0f05e4-e32b-4b10-a246-7b77f7dcc63c" 
    }
  ],
  "include_by_default": false
}
'
```


### GCP Private Service Connect

Send a request like the following to create a GCP Private Service Connect private connection policy:
```json
curl -XPOST \
-H "Authorization: ApiKey $API_KEY" \
-H 'content-type: application/json' \
https://api.elastic-cloud.com/api/v1/deployments/traffic-filter/rulesets \
-d '
{
  "name": "GCP Private Service Connect private connection policy",
  "region": "gcp-asia-northeast1",
  "description": "",
  "type": "gcp_private_service_connect_endpoint",
  "rules": [
    {
      "source": "18446744072646845332" 
    }
  ],
  "include_by_default": false
}
'
```


## Update a policy or rule set

Send a request like the following to update an IP filter ingress policy or rule set.
Policies in Elastic Cloud are the equivalent of rule sets in Elastic Cloud Enterprise.
<applies-switch>
  <applies-item title="ess:" applies-to="Elastic Cloud Hosted: Generally available">
    ```json
    curl -XPUT \
    -H "Authorization: ApiKey $API_KEY" \
    -H 'content-type: application/json' \
    https://api.elastic-cloud.com/api/v1/deployments/traffic-filter/rulesets/$POLICY_ID \
    -d '
    {
      "name": "My ingress IP filter policy",
      "region": "azure-japaneast",
      "description": "",
      "type": "ip",
      "rules": [
        {
          "description": "Allow inbound traffic from IP address 192.168.131.0",
          "source": "192.168.131.0"
        },
        {
          "description": "Allow inbound traffic within CIDR block 192.168.132.6/22",
          "source": "192.168.132.6/22"
        }
      ],
      "include_by_default": true
    }
    '
    ```
  </applies-item>

  <applies-item title="serverless:" applies-to="Elastic Cloud Serverless: Generally available">
    ```json
    curl -X PATCH \
    -H "Authorization: ApiKey $API_KEY" \
    -H 'content-type: application/json' \
    https://api.elastic-cloud.com/api/v1/serverless/traffic-filters/$POLICY_ID \
    -d '
    {
      "description": "Updated description of the policy",
      "rules": [
        {
          "description": "Updated description of the source",
          "source": "192.168.131.0"
        },
      ],
      "include_by_default": true
    }
    '
    ```
  </applies-item>

  <applies-item title="ece:" applies-to="Elastic Cloud Enterprise: Generally available">
    ```json
    curl -XPUT \
    -H "Authorization: ApiKey $API_KEY" \
    -H 'content-type: application/json' \
    https://$COORDINATOR_HOST:12443/api/v1/deployments/traffic-filter/rulesets/$RULESET_ID \
    -d '
    {
      "name": "My IP filtering Ingress Rule Set",
      "region": "ece-region",
      "description": "",
      "type": "ip",
      "rules": [
        {
          "description": "Allow inbound traffic from IP address 192.168.131.0",
          "source": "192.168.131.0"
        },
        {
          "description": "Allow inbound traffic within CIDR block 192.168.132.6/22",
          "source": "192.168.132.6/22"
        }
      ],
      "include_by_default": true
    }
    '
    ```
  </applies-item>
</applies-switch>


## Associate a policy or rule set with a project or deployment

Send a request like the following to associate a policy or rule set with a project or deployment.
Policies in Elastic Cloud are the equivalent of rule sets in Elastic Cloud Enterprise.
<applies-switch>
  <applies-item title="ess:" applies-to="Elastic Cloud Hosted: Generally available">
    ```json
    curl -XPOST \
    -H "Authorization: ApiKey $API_KEY" \
    -H 'content-type: application/json' \
    https://api.elastic-cloud.com/api/v1/deployments/traffic-filter/rulesets/$POLICY_ID/associations \
    -d '
    {
       "entity_type" : "deployment",
       "id" : "'"$DEPLOYMENT_ID"'"
    }
    '
    ```
  </applies-item>

  <applies-item title="serverless:" applies-to="Elastic Cloud Serverless: Generally available">
    To associate a network security policy to a project, you must update the project object.
    ```json
    curl -X PATCH \
    -H "Authorization: ApiKey $API_KEY" \
    -H 'content-type: application/json' \
    https://api.elastic-cloud.com/api/v1/admin/serverless/projects/elasticsearch \ 
    -d '
    {
      "traffic_filters": [
        {
          "id": "$POLICY_ID"
        },
        {
          "id": "$ANOTHER_POLICY_ID"
        }
      ]
    }
    '
    ```

    <warning>
      When adding, updating, or removing a policy association, you must provide a complete list of policies to be associated with the project in the `PATCH` request body. Any policies not included in this list will be removed from the project.
    </warning>
  </applies-item>

  <applies-item title="ece:" applies-to="Elastic Cloud Enterprise: Generally available">
    ```json
    curl -XPOST \
    -H "Authorization: ApiKey $API_KEY" \
    -H 'content-type: application/json' \
    https://$COORDINATOR_HOST:12443/api/v1/deployments/traffic-filter/rulesets/$RULESET_ID/associations \
    -d '
    {
       "entity_type" : "deployment",
       "id" : "'"$DEPLOYMENT_ID"'"
    }
    '
    ```
  </applies-item>
</applies-switch>


## Remove a policy or rule set from a project or deployment

Send a request like the following to remove a policy or rule set from a project or deployment.
Policies in Elastic Cloud are the equivalent of rule sets in Elastic Cloud Enterprise.
<applies-switch>
  <applies-item title="ess:" applies-to="Elastic Cloud Hosted: Generally available">
    ```json
    curl -XDELETE \
    -H "Authorization: ApiKey $API_KEY" \
    -H 'content-type: application/json' \
    https://api.elastic-cloud.com/api/v1/deployments/traffic-filter/rulesets/$POLICY_ID/associations/deployment/$DEPLOYMENT_ID \
    ```
  </applies-item>

  <applies-item title="serverless:" applies-to="Elastic Cloud Serverless: Generally available">
    To remove a network security policy from a project, you must update the project object. Pass a complete list of policies in the `PATCH` request body, excluding the policy that you want to remove from the list.
    ```json
    curl -X PATCH \
    -H "Authorization: ApiKey $API_KEY" \
    -H 'content-type: application/json' \
    https://api.elastic-cloud.com/api/v1/admin/serverless/projects/elasticsearch \ 
    -d '
    {
      "traffic_filters": [
        {
          "id": "$REMAINING_POLICY_ID" 
        }
      ]
    }
    '
    ```
  </applies-item>

  <applies-item title="ece:" applies-to="Elastic Cloud Enterprise: Generally available">
    ```json
    curl -XDELETE \
    -H "Authorization: ApiKey $API_KEY" \
    -H 'content-type: application/json' \
    https://$COORDINATOR_HOST:12443/api/v1/deployments/traffic-filter/rulesets/$RULESET_ID/associations/deployment/$DEPLOYMENT_ID \
    ```
  </applies-item>
</applies-switch>


## Delete a policy or rule set

Send a request like the following to delete a policy or rule set.
Policies in Elastic Cloud are the equivalent of rule sets in Elastic Cloud Enterprise.
<applies-switch>
  <applies-item title="ess:" applies-to="Elastic Cloud Hosted: Generally available">
    ```json
    curl -XDELETE \
    -H "Authorization: ApiKey $API_KEY" \
    https://api.elastic-cloud.com/api/v1/deployments/traffic-filter/rulesets/$POLICY_ID \
    ```
  </applies-item>

  <applies-item title="serverless:" applies-to="Elastic Cloud Serverless: Generally available">
    ```json
    curl -XDELETE \
    -H "Authorization: ApiKey $API_KEY" \
    https://api.elastic-cloud.com/api/v1/serverless/traffic-filters/$POLICY_ID \
    ```
  </applies-item>

  <applies-item title="ece:" applies-to="Elastic Cloud Enterprise: Generally available">
    ```json
    curl -XDELETE \
    -H "Authorization: ApiKey $API_KEY" \
    https://$COORDINATOR_HOST:12443/api/v1/deployments/traffic-filter/rulesets/$RULESET_ID \
    ```
  </applies-item>
</applies-switch>