﻿---
title: Security event audit logging
description: Audit logging is a powerful feature that helps you monitor and track security-related events within the Elastic Stack. By enabling audit logs, you can...
url: https://www.elastic.co/docs/deploy-manage/security/logging-configuration/security-event-audit-logging
applies_to:
  - Elastic Cloud Serverless: Unavailable
  - Elastic Cloud Hosted: Generally available
  - Elastic Cloud on Kubernetes: Generally available
  - Elastic Cloud Enterprise: Generally available
  - Self-managed Elastic deployments: Generally available
---

# Security event audit logging
<important>
  Audit logs are only available on certain [subscription levels](https://www.elastic.co/subscriptions).
</important>

Audit logging is a powerful feature that helps you monitor and track security-related events within the Elastic Stack. By enabling audit logs, you can gain visibility into authentication attempts, authorization decisions, and other system activity.
Audit logging also provides forensic evidence in the event of an attack, and can be enabled independently for Elasticsearch and Kibana.
Use the Kibana audit logs in conjunction with Elasticsearch audit logging to get a holistic view of all security related events. Kibana defers to the Elasticsearch security model for authentication, data index authorization, and features that are driven by cluster-wide privileges.
In this section, you'll learn how to:
- [Enable audit logging](https://www.elastic.co/docs/deploy-manage/security/logging-configuration/enabling-audit-logs): Activate Elasticsearch or Kibana audit logs for all supported deployment types.
- [Configure audit logging](https://www.elastic.co/docs/deploy-manage/security/logging-configuration/configuring-audit-logs): Filter and control what security events get logged in the audit log output.
- [Audit Elasticsearch search queries](https://www.elastic.co/docs/deploy-manage/security/logging-configuration/auditing-search-queries): Audit and log search request bodies.
- [Correlate audit events](https://www.elastic.co/docs/deploy-manage/security/logging-configuration/correlating-kibana-elasticsearch-audit-logs): Explore audit logs and understand how events from the same request are correlated.

By following these guidelines, you can effectively audit system activity, enhance security monitoring, and meet compliance requirements.
For a complete description of audit event details and format, refer to:
- [Elasticsearch audit events](https://www.elastic.co/docs/reference/elasticsearch/elasticsearch-audit-events)
- [Kibana audit events](https://www.elastic.co/docs/reference/kibana/kibana-audit-events)