﻿---
title: Elasticsearch audit events ignore policies
description: The comprehensive audit trail is necessary to ensure accountability. It offers tremendous value during incident response and can even be required for...
url: https://www.elastic.co/docs/deploy-manage/security/logging-configuration/logfile-audit-events-ignore-policies
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Unavailable
  - Elastic Cloud Hosted: Generally available
  - Elastic Cloud on Kubernetes: Generally available
  - Elastic Cloud Enterprise: Generally available
  - Self-managed Elastic deployments: Generally available
---

# Elasticsearch audit events ignore policies
The comprehensive audit trail is necessary to ensure accountability. It offers tremendous value during incident response and can even be required for demonstrating compliance.
The drawback of an audited system is represented by the inevitable performance penalty incurred. In all truth, the audit trail spends *I/O ops* that are not available anymore for the user’s queries. Sometimes the verbosity of the audit trail may become a problem that the event type restrictions, [defined by `include` and `exclude`](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/auding-settings#event-audit-settings), will not alleviate.
**Audit events ignore policies** are a finer way to tune the verbosity of the audit trail. These policies define rules that match audit events which will be *ignored* (read as: not printed). Rules match on the values of attributes of audit events and complement the `include` or `exclude` method. Imagine the corpus of audit events and the policies chopping off unwanted events. With a sole exception, all audit events are subject to the ignore policies. The exception are events of type `security_config_change`, which cannot be filtered out, unless excluded altogether.
<important>
  When utilizing audit events ignore policies you are acknowledging potential accountability gaps that could render illegitimate actions undetectable. Take time to review these policies whenever your system architecture changes.
</important>

A policy is a named set of filter rules. Each filter rule applies to a single event attribute, one of the `users`, `realms`, `actions`, `roles` or `indices` attributes. The filter rule defines a list of [wildcard patterns](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-wildcard-query) or [Lucene regexp](https://www.elastic.co/docs/reference/query-languages/query-dsl/regexp-syntax), **any** of which has to match the value of the audit event attribute for the rule to match. A policy matches an event if **all** the rules comprising it match the event. An audit event is ignored, therefore not printed, if it matches **any** policy. All other non-matching events are printed as usual.
All policies are defined under the `xpack.security.audit.logfile.events.ignore_filters` settings namespace. For example, the following policy named *example1* matches events from the *kibana_system* or *admin_user* principals that operate over indices of the wildcard form *app-logs**:
```yaml
xpack.security.audit.logfile.events.ignore_filters:
  example1:
    users: ["kibana_system", "admin_user"]
    indices: ["app-logs*"]
```

An audit event generated by the *kibana_system* user and operating over multiple indices, some of which do not match the indices wildcard, will not match. As expected, operations generated by all other users (even operating only on indices that match the *indices* filter) will not match this policy either.
The following policy named *example2* matches events that operate over any index except *logs-app1* and *logs-app2*:
```yaml
xpack.security.audit.logfile.events.ignore_filters:
  example2:
    indices: ["/~(logs-app1|logs-app2)/"]
```

Only events operating over *logs-app1* and *logs-app2* indices will not match and will not be ignored by the policy.
Audit events of different types may have [different attributes](https://www.elastic.co/docs/reference/elasticsearch/elasticsearch-audit-events#audit-event-attributes). If an event does not contain an attribute for which some policy defines filters, the event will not match the policy. For example, the following policy will never match `authentication_success` or `authentication_failed` events, irrespective of the user’s roles, because these event schemas do not contain the `role` attribute:
```yaml
xpack.security.audit.logfile.events.ignore_filters:
  example2:
    roles: ["admin", "ops_admin_*"]
```

Likewise, any events of users with multiple roles, some of which do not match the wildcard patterns or the regexps will not match this policy.
For completeness, although practical use cases should be sparse, a filter can match a missing attribute of an event, using the empty string ("") or the empty list ([]). For example, the following policy will match events that do not have the `indices` attribute (`anonymous_access_denied`, `authentication_success` and other types) as well as events over the *next* index.
```yaml
xpack.security.audit.logfile.events.ignore_filters:
  example3:
    indices: ["next", ""]
```