﻿---
title: Enable audit logging
description: You can log security-related events such as authentication failures and refused connections to monitor your cluster for suspicious activity (including...
url: https://www.elastic.co/docs/deploy-manage/security/logging-configuration/enabling-audit-logs
products:
  - Elastic Cloud Enterprise
  - Elastic Cloud Hosted
  - Elastic Cloud on Kubernetes
  - Elasticsearch
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Unavailable
  - Elastic Cloud Hosted: Generally available
  - Elastic Cloud on Kubernetes: Generally available
  - Elastic Cloud Enterprise: Generally available
  - Self-managed Elastic deployments: Generally available
---

# Enable audit logging
<important>
  Audit logs are only available on certain [subscription levels](https://www.elastic.co/subscriptions).
</important>

You can log security-related events such as authentication failures and refused connections to monitor your cluster for suspicious activity (including data access authorization and user security configuration changes). Audit logging can be enabled independently for Elasticsearch and Kibana.
This section describes how to enable and configure audit logging in both Elasticsearch and Kibana for all supported deployment types, including self-managed clusters, Elastic Cloud Hosted, Elastic Cloud Enterprise (ECE), and Elastic Cloud on Kubernetes (ECK).
<important>
  In orchestrated deployments, audit logs must be shipped to a monitoring deployment; otherwise, they remain at container level and won't be accessible to users. For details on configuring log forwarding in orchestrated environments, refer to [logging configuration](https://www.elastic.co/docs/deploy-manage/monitor/logging-configuration).
</important>

When audit logging is enabled, security events are persisted to a dedicated `<clustername>_audit.json` file on the host’s file system, on every cluster node. For more information, refer to [Elasticsearch logfile audit output](https://www.elastic.co/docs/deploy-manage/security/logging-configuration/logfile-audit-output).

## Before you  begin

- If you're using ECE or ECH, then you need to [enable monitoring and logging](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/ece-ech-stack-monitoring) on your deployment. As part of enabling monitoring and logging, you choose a location where logs will be delivered.
- In production environments, consider creating a separate monitoring cluster that can consume the logs.


## Enable audit logging

To enable Elasticsearch or Kibana audit logs, configure `xpack.security.audit.enabled` to `true` in **all Elasticsearch or Kibana nodes**, then restart the nodes to apply the changes. For detailed instructions, select your deployment type:
<note>
  Audit logs are disabled by default and must be explicitly enabled.
</note>

<applies-switch>
  <applies-item title="self:" applies-to="Self-managed Elastic deployments: Generally available">
    **To enable audit logging in Elasticsearch**:
    1. In all nodes, set `xpack.security.audit.enabled` to `true` in [`elasticsearch.yml`](https://www.elastic.co/docs/deploy-manage/stack-settings).
    2. Restart the cluster by following the [rolling restart](https://www.elastic.co/docs/deploy-manage/maintenance/start-stop-services/full-cluster-restart-rolling-restart-procedures) procedure.
    **To enable audit logging in Kibana**:
    1. Set `xpack.security.audit.enabled` to `true` in [`kibana.yml`](https://www.elastic.co/docs/deploy-manage/stack-settings).
    2. Restart Kibana.
    To learn how to consume these logs in an Elasticsearch cluster, refer to [Collecting log data with Filebeat](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/collecting-log-data-with-filebeat).
  </applies-item>

  <applies-item title="ess:" applies-to="Elastic Cloud Hosted: Generally available">
    To enable audit logging in an Elastic Cloud Hosted deployment:
    1. Log in to the [Elastic Cloud Console](https://cloud.elastic.co?page=docs&placement=docs-body).
    2. Find your deployment on the home page or on the **Hosted deployments** page, then select **Manage** to access its settings menus.
    3. From your deployment menu, go to the **Edit** page.
    4. To enable auditing for Elasticsearch:
       - In the **Elasticsearch** section, select **Manage user settings and extensions**. For deployments with existing user settings, you may have to expand the **Edit elasticsearch.yml** caret for each node instead.
    - Add the setting `xpack.security.audit.enabled: true`.
    5. To enable auditing for Kibana:
       - In the **Kibana** section, select **Edit user settings**. For deployments with existing user settings, you may have to expand the **Edit kibana.yml** caret instead.
    - Add the setting `xpack.security.audit.enabled: true`.
    6. Select **Save changes**.
    A plan change will run on your deployment. When it finishes, audit logs will be delivered to your monitoring deployment.
  </applies-item>

  <applies-item title="ece:" applies-to="Elastic Cloud Enterprise: Generally available">
    To enable audit logging in an ECE deployment:
    1. [Log in to the Cloud UI](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/log-into-cloud-ui).
    2. On the **Deployments** page, select your deployment.
    3. From your deployment menu, go to the **Edit** page.
    4. To enable auditing for Elasticsearch:
       - In the **Elasticsearch** section, select **Edit user settings and plugins**. For deployments with existing user settings, you may have to expand the **Edit elasticsearch.yml** caret for the first node instead.
    - Add the setting `xpack.security.audit.enabled: true`.
    5. To enable auditing for Kibana:
       - In the **Kibana** section, select **Edit user settings**. For deployments with existing user settings, you may have to expand the **Edit kibana.yml** caret instead.
    - Add the setting `xpack.security.audit.enabled: true`.
    - If your Elastic Stack version is below 7.6.0, add the setting `logging.quiet: false`.
    6. Select **Save**.
    A plan change will run on your deployment. When it finishes, audit logs will be delivered to your monitoring deployment.
  </applies-item>

  <applies-item title="eck:" applies-to="Elastic Cloud on Kubernetes: Generally available">
    To enable audit logging in an ECK-managed cluster, add `xpack.security.audit.enabled: true` to the `config` section of each Elasticsearch `nodeSet` and to the `config` section of the Kibana object's specification.The following example shows this configuration, along with logs and metrics delivery towards a remote cluster:
    ```yaml
    apiVersion: elasticsearch.k8s.elastic.co/v1
    kind: Elasticsearch
    spec:
      monitoring:
        metrics:
          elasticsearchRefs:
          - name: monitoring
            namespace: observability
        logs:
          elasticsearchRefs:
          - name: monitoring
            namespace: observability
      nodeSets:
      - name: default
        config:
          xpack.security.audit.enabled: true
    ---
    apiVersion: kibana.k8s.elastic.co/v1
    kind: Kibana
    spec:
      monitoring:
        metrics:
          elasticsearchRefs:
          - name: monitoring
            namespace: observability
        logs:
          elasticsearchRefs:
          - name: monitoring
            namespace: observability
      config:
        xpack.security.audit.enabled: true
    ```
    When enabled, audit logs are collected and shipped to the monitoring cluster referenced in the `monitoring.logs` section. If monitoring is not enabled, audit logs will only be visible at container level.
  </applies-item>
</applies-switch>


## Next steps

You can configure additional options to control what events are logged and what information is included in the audit log. For more information, refer to [Configure audit logging](https://www.elastic.co/docs/deploy-manage/security/logging-configuration/configuring-audit-logs).