﻿---
title: Configure audit logging
description: When auditing security events, a single client request might generate multiple audit events across multiple cluster nodes, potentially leading to a high...
url: https://www.elastic.co/docs/deploy-manage/security/logging-configuration/configuring-audit-logs
applies_to:
  - Elastic Cloud Serverless: Unavailable
  - Elastic Cloud Hosted: Generally available
  - Elastic Cloud on Kubernetes: Generally available
  - Elastic Cloud Enterprise: Generally available
  - Self-managed Elastic deployments: Generally available
---

# Configure audit logging
When auditing security events, a single client request might generate multiple audit events across multiple cluster nodes, potentially leading to a high volume of log data and I/O operations. To maintain clarity and ensure logs remain actionable, Elasticsearch and Kibana provide configuration mechanisms to control what events are logged and which can be ignored.

### Elasticsearch auditing configuration

Elasticsearch configuration options include:
- [Elasticsearch audited events settings](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/auding-settings#event-audit-settings): Use include and exclude filters to control the types of events that get logged.
- [Elasticsearch node information settings](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/auding-settings#node-audit-settings): Control whether to add or hide node information such as hostname or IP address in the audited events.
- [Elasticsearch ignore policies settings](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/auding-settings#audit-event-ignore-policies): Use ignore policies for fine-grained control over which audit events are printed to the log file.
  <tip>
  In Elasticsearch, all auditing settings except `xpack.security.audit.enabled` are dynamic. This means you can configure them using the [cluster update settings API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cluster-put-settings), allowing changes to take effect immediately without requiring a restart. This approach is faster and more convenient than modifying [`elasticsearch.yml`](https://www.elastic.co/docs/deploy-manage/stack-settings).
  </tip>

For a complete description of event details and format, refer to the following resources:
- [Elasticsearch audit events details and schema](https://www.elastic.co/docs/reference/elasticsearch/elasticsearch-audit-events)
- [Elasticsearch log entry output format](/docs/deploy-manage/security/logging-configuration/logfile-audit-output#audit-log-entry-format)


### Kibana auditing configuration

To control the logs that are outputted by Kibana, you can use [Kibana ignore filters](https://www.elastic.co/docs/reference/kibana/configuration-reference/security-settings#audit-logging-ignore-filters). These are a list of filters that determine which events should be excluded from the audit log.
In self-managed systems, you can optionally configure audit logs location, and file/rolling file using [Kibana audit logging settings](https://www.elastic.co/docs/reference/kibana/configuration-reference/security-settings#audit-logging-settings).
<tip>
  To configure Kibana settings, follow the same [procedure](/docs/deploy-manage/security/logging-configuration/enabling-audit-logs#enable-audit-logging-procedure) as when enabling Kibana audit logs, but apply the relevant settings instead.
</tip>

For a complete description of auditing event details, such as `category`, `type`, or `action`, refer to [Kibana audit events](https://www.elastic.co/docs/reference/kibana/kibana-audit-events).

### General recommendations

- Consider starting with Elasticsearch [`xpack.security.audit.logfile.events.include`](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/auding-settings#xpack-sa-lf-events-include) and [Kibana ignore filters](https://www.elastic.co/docs/reference/kibana/configuration-reference/security-settings#audit-logging-ignore-filters) settings to specify the type of events you want to include or exclude in the auditing output.
- If you need a more granular control, refer to [Elasticsearch audit events ignore policies](https://www.elastic.co/docs/deploy-manage/security/logging-configuration/logfile-audit-events-ignore-policies) for a better understanding how ignore policies work and when they are beneficial.
- Refer to [auditing search queries](https://www.elastic.co/docs/deploy-manage/security/logging-configuration/auditing-search-queries) for details on logging request bodies in the Elasticsearch audit logs.
  <important>
  Sensitive data may be audited in plain text when including the request body in audit events, even though all the security APIs, such as those that change the user’s password, have the credentials filtered out when audited.
  </important>