﻿---
title: Security limitations
description: Review the following Elasticsearch security limitations. Depending on your organization's security requirements, you might want to restrict, adjust, or...
url: https://www.elastic.co/docs/deploy-manage/security/limitations
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Hosted: Generally available
  - Elastic Cloud on Kubernetes: Generally available
  - Elastic Cloud Enterprise: Generally available
  - Self-managed Elastic deployments: Generally available
---

# Security limitations
Review the following Elasticsearch security limitations. Depending on your organization's security requirements, you might want to restrict, adjust, or find workaround or alternatives for some of these features and resources.

## Plugins

Elasticsearch's plugin infrastructure is extremely flexible in terms of what can be extended. While it opens up Elasticsearch to a wide variety of (often custom) additional functionality, when it comes to security, this high extensibility level comes at a cost. We have no control over the third-party plugins' code (open source or not) and therefore we cannot guarantee their compliance with Elastic Stack security features. For this reason, third-party plugins are not officially supported on clusters with security features enabled.

## Changes in wildcard behavior

Elasticsearch clusters with the security features enabled apply `_all` and other wildcards to data streams, indices, and aliases the current user has privileges for, not all data streams, indices, and aliases on the cluster.

## Multi document APIs

Multi get and multi term vectors API throw `IndexNotFoundException` when trying to access non existing indices that the user is not authorized for. By doing that they leak information regarding the fact that the data stream or index doesn’t exist, while the user is not authorized to know anything about those data streams or indices.

## Filtered index aliases

Aliases containing filters are not a secure way to restrict access to individual documents, due to the limitations described in [Index and field names can be leaked when using aliases](#alias-limitations). The Elastic Stack security features provide a secure way to restrict access to documents through the [document-level security](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/controlling-access-at-document-field-level) feature.

## Field and document level security limitations

Field and document security is subject to the following limitations:

### Document level security limitations

When a user’s role enables [document level security](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/controlling-access-at-document-field-level) for a data stream or index:
- Document level security doesn’t affect global index statistics that relevancy scoring uses. This means that scores are computed without taking the role query into account. Documents that don’t match the role query are never returned.
- The `has_child` and `has_parent` queries aren’t supported as query parameters in the role definition. The `has_child` and `has_parent` queries can be used in the search API with document level security enabled.
- [Date math](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/common-options#date-math) expressions cannot contain `now` in [range queries with date fields](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-range-query#ranges-on-dates).
- Any query that makes remote calls to fetch query data isn’t supported, including the following queries:
  - `terms` query with terms lookup
- `geo_shape` query with indexed shapes
- `percolate` query
- If suggesters are specified and document level security is enabled, the specified suggesters are ignored.
- A search request cannot be profiled if document level security is enabled.
- The [terms enum API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-terms-enum) does not return terms if document level security is enabled.
- The [`multi_match`](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-multi-match-query) query does not support specifying fields using wildcards.

<note>
  While document-level security prevents users from viewing restricted documents, it’s still possible to write search requests that return aggregate information about the entire index. A user whose access is restricted to specific documents in an index could still learn about field names and terms that only exist in inaccessible documents, and count how many inaccessible documents contain a given term.
</note>


### Field level security limitations

When a user’s role enables document or [field level security](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/controlling-access-at-document-field-level) for a data stream or index:
- The user cannot perform write operations:
  - The update API isn’t supported.
- Update requests included in bulk requests aren’t supported.
- The user cannot perform operations that effectively make contents accessible under another name, including actions from the following APIs:
  - [Clone index API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-clone)
- [Shrink index API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-shrink)
- [Split index API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-split)
- [Aliases API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-update-aliases)
- The request cache is disabled for search requests if either of the following are true:
  - The role query that defines document level security is [templated](/docs/deploy-manage/users-roles/cluster-or-deployment-auth/controlling-access-at-document-field-level#templating-role-query) using a [stored script](https://www.elastic.co/docs/explore-analyze/scripting/modules-scripting-store-and-retrieve).
- The target indices are a mix of local and remote indices.


## Index and field names can be leaked when using aliases

Calling certain Elasticsearch APIs on an alias can potentially leak information about indices that the user isn’t authorized to access. For example, when you get the mappings for an alias with the `_mapping` API, the response includes the index name and mappings for each index that the alias applies to.
Until this limitation is addressed, avoid index and field names that contain confidential or sensitive information.

## LDAP realm

The [LDAP Realm](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/ldap) does not currently support the discovery of nested LDAP Groups. For example, if a user is a member of `group_1` and `group_1` is a member of `group_2`, only `group_1` will be discovered. However, the [Active Directory Realm](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/active-directory) **does** support transitive group membership.

## Resource sharing check for users and API keys

The result of [async search](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-async-search-submit) and [scroll](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-scroll) requests can be retrieved later by the same user or API key that submitted the initial request. The verification process involves comparing the username, authentication realm type, and (for realms other than file or native) realm name. If you used an API key to submit the request, only that key can retrieve the results. This logic also has a few limitations:
- Two different realms can have the same name on different nodes. This is not a recommended way to configure realms, therefore the resource sharing check does not attempt to detect this inconsistency.
- Realms can be renamed. This can cause inconsistency for the resource sharing check when you submit an async search or scroll then rename the realm and try to retrieve the results. Hence, changing realm names should be handled with care since it can cause complications for more than just the resource sharing check.
- The username is dynamically computed for realms backed by certain external authentication providers. For example, the username can be derived from part of the DN in an LDAP realm. It is in theory possible that two distinct users from the external system get mapped to the same username. Our recommendation is to avoid this situation in the first place. Hence, the resource sharing check does not account for this potential discrepancy.