﻿---
title: IP filtering
description: This section covers filtering network traffic by IP address or CIDR block. The way you configure IP filters, and how filtering is enforced, depends on...
url: https://www.elastic.co/docs/deploy-manage/security/ip-filtering
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Cloud Hosted: Generally available
  - Elastic Cloud on Kubernetes: Generally available
  - Elastic Cloud Enterprise: Generally available
  - Self-managed Elastic deployments: Generally available
---

# IP filtering
This section covers filtering network traffic by IP address or CIDR block.
The way you configure IP filters, and how filtering is enforced, depends on your deployment type.
<tip>
  If you use Elastic Cloud Hosted or Elastic Cloud on Kubernetes, then other [network security](https://www.elastic.co/docs/deploy-manage/security/network-security) methods are also available.
</tip>


## Serverless and ECH

In Elastic Cloud Serverless and Elastic Cloud Hosted, IP filters are a type of [network security policy](https://www.elastic.co/docs/deploy-manage/security/network-security-policies). They are created at the organization level, and then applied at the deployment level. Follow these guides to learn how to create, apply, and manage these filters using your preferred method:
- [In the Elastic Cloud console](https://www.elastic.co/docs/deploy-manage/security/ip-filtering-cloud)
- [Using the Elastic Cloud API](https://www.elastic.co/docs/deploy-manage/security/network-security-api)

To learn how multiple IP filters are processed, and how IP filters and [private connections](https://www.elastic.co/docs/deploy-manage/security/private-connectivity) work together in ECH, refer to [Network security policies in Elastic Cloud](https://www.elastic.co/docs/deploy-manage/security/network-security-policies).

## ECE

In Elastic Cloud Enterprise, filter rules are created at the platform level, and then applied at the deployment level. Follow these guides to learn how to create, apply, and manage these policies using your preferred method:
- [In the Cloud UI](https://www.elastic.co/docs/deploy-manage/security/ip-filtering-ece)
- [Using the Elastic Cloud API](https://www.elastic.co/docs/deploy-manage/security/network-security-api)

To learn how multiple rules are processed, refer to [IP filtering rules in Elastic Cloud Enterprise](https://www.elastic.co/docs/deploy-manage/security/ece-filter-rules).

## ECK and self managed

In Elastic Cloud on Kubernetes and self-managed clusters, IP filters are applied at the cluster level using `elasticsearch.yml`. [Learn how to configure IP filters at the cluster level](https://www.elastic.co/docs/deploy-manage/security/ip-filtering-basic).