﻿---
title: FIPS compliance
description: The Federal Information Processing Standard (FIPS) Publication 140, titled "Security Requirements for Cryptographic Modules" is a U.S. government computer...
url: https://www.elastic.co/docs/deploy-manage/security/fips
products:
  - APM
  - Beats
  - Elastic Agent
  - Elasticsearch
  - Fleet
  - Kibana
applies_to:
  - Self-managed Elastic deployments: Generally available
---

# FIPS compliance
The Federal Information Processing Standard (FIPS) Publication 140, titled "Security Requirements for Cryptographic Modules" is a U.S. government computer security standard used to approve cryptographic modules. FIPS 140-2 and its successor FIPS 140-3 define the security requirements that cryptographic modules must meet.
- [Elasticsearch](https://www.elastic.co/docs/deploy-manage/security/fips-es) can run in a JVM configured with a FIPS-certified security provider, and supports the following FIPS compliant modes:
  - FIPS 140-2
- <applies-to>Elastic Stack: Planned</applies-to> FIPS 140-3
- [Kibana](https://www.elastic.co/docs/deploy-manage/security/fips-kib) offers a FIPS 140-2 compliant mode and as such can run in a Node.js environment configured with a FIPS 140-2 compliant OpenSSL3 provider.
- Some [Ingest tools](https://www.elastic.co/docs/deploy-manage/security/fips-ingest), including Elastic Agent, Fleet, Filebeat, Metricbeat, and APM Server, are available as FIPS compatible binaries and can be configured to use FIPS 140-2 compliant cryptography.

<note>
  If you are running Elasticsearch through Elastic Cloud on Kubernetes, refer to [ECK FIPS compatibility](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/deploy-fips-compatible-version-of-eck).FIPS compliance is not officially supported in Elastic Cloud Enterprise (ECE). While ECE may function on FIPS-enabled systems, this configuration has not been validated through our testing processes and is not recommended for production environments.
</note>