﻿---
title: FIPS compliance for Kibana
description: To run Kibana in FIPS mode, you must have the appropriate subscription. For Kibana, adherence to FIPS 140-2 is ensured by: Using FIPS approved / NIST...
url: https://www.elastic.co/docs/deploy-manage/security/fips-kib
products:
  - Kibana
applies_to:
  - Self-managed Elastic deployments: Generally available
---

# FIPS compliance for Kibana
To run Kibana in FIPS mode, you must have the appropriate [subscription](https://www.elastic.co/subscriptions).
<important>
  The Node bundled with Kibana is not configured for FIPS 140-2. You must configure a FIPS 140-2 compliant OpenSSL3 provider. Consult the Node.js documentation to learn how to configure your environment.
</important>

For Kibana, adherence to FIPS 140-2 is ensured by:
- Using FIPS approved / NIST recommended cryptographic algorithms.
- Delegating the implementation of these cryptographic algorithms to a NIST validated cryptographic module (available via Node.js configured with an OpenSSL3 provider).
- Allowing the configuration of Kibana in a FIPS 140-2 compliant manner, as documented below.


## Configuring Kibana for FIPS 140-2

Apart from setting `xpack.security.fipsMode.enabled` to `true` in your Kibana config, a number of security related settings need to be reviewed and configured in order to run Kibana successfully in a FIPS 140-2 compliant Node.js environment.

### Kibana keystore

FIPS 140-2 (via NIST Special Publication 800-132) dictates that encryption keys should at least have an effective strength of 112 bits. As such, the Kibana keystore that stores the application’s secure settings needs to be password protected with a password that satisfies this requirement. This means that the password needs to be 14 bytes long which is equivalent to a 14 character ASCII encoded password, or a 7 character UTF-8 encoded password.
For more information on how to set this password, refer to the [keystore documentation](/docs/deploy-manage/security/secure-settings#change-password).

### TLS keystore and keys

Keystores can be used in a number of General TLS settings in order to conveniently store key and trust material. PKCS#12 keystores cannot be used in a FIPS 140-2 compliant Node.js environment. Avoid using these types of keystores. Your FIPS 140-2 provider may provide a compliant keystore implementation that can be used, or you can use PEM encoded files. To use PEM encoded key material, you can use the relevant `\*.key` and `*.certificate` configuration options, and for trust material you can use `*.certificate_authorities`.
As an example, avoid PKCS#12 specific settings such as:
- `server.ssl.keystore.path`
- `server.ssl.truststore.path`
- `elasticsearch.ssl.keystore.path`
- `elasticsearch.ssl.truststore.path`