﻿---
title: FIPS mode for Ingest tools
description: Elastic Agent, Fleet, Filebeat, Metricbeat, and APM Server binaries are built and configured to use FIPS 140-2 compliant cryptography. Generally speaking...
url: https://www.elastic.co/docs/deploy-manage/security/fips-ingest
products:
  - APM
  - Beats
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Stack: Preview since 9.1
---

# FIPS mode for Ingest tools
Elastic Agent, Fleet, Filebeat, Metricbeat, and APM Server binaries are built and configured to use FIPS 140-2 compliant cryptography.
Generally speaking FIPS 140-2 requirements can be summarized as:
- linking against a FIPS certified cryptographic library
- using only FIPS approved cryptographic functions
- ensuring that the configuration of the component is FIPS 140-2 compliant.


## FIPS-compatible binaries and configuration

FIPS compatible binaries for Elastic Agent, Fleet, Filebeat, Metricbeat, and APM Server are available for [download](https://www.elastic.co/downloads). Look for the `Linux 64-bit (FIPS)` or `Linux aarch64 (FIPS)` platform option on the product download pages for Elastic Agent and Fleet, Filebeat, and Metricbeat. Look for the `Linux x86_64 (FIPS)` or `Linux aarch64 (FIPS)` platform option on the APM Server download page.
<important>
  The default configurations provided in the binaries are FIPS compatible. Be sure to check and understand the implications of changing default configurations.
</important>


## Limitations


### TLS

Only FIPS 140-2 compliant TLS protocols, ciphers, and curve types are allowed to be used as listed below.
- The supported TLS versions are `TLS v1.2` and `TLS v1.3`.
- The supported cipher suites are:
  - `TLS v1.2`: `ECDHE-RSA-AES-128-GCM-SHA256`, `ECDHE-RSA-AES-256-GCM-SHA384`, `ECDHE-ECDSA-AES-128-GCM-SHA256`, `ECDHE-ECDSA-AES-256-GCM-SHA384`
- `TLS v1.3`: `TLS-AES-128-GCM-SHA256`, `TLS-AES-256-GCM-SHA384`
- The supported curve types are `P-256`, `P-384` and `P-521`.

Support for encrypted private keys is not available, as the cryptographic modules used for decrypting password protected keys are not FIPS validated. If an output or any other component with an SSL key that is password protected is configured, the components will fail to load the key. When running in FIPS mode, you must provide non-encrypted keys.
Be sure to enforce security in your FIPS environments through other means, such as strict file permissions and access controls on the key file itself, for example.
These TLS related restrictions apply to all components listed--Elastic Agent, Fleet, Filebeat, Metricbeat, and APM Server.

### General output and input limitations (Kerberos protocol)

The Kerberos protocol is not supported for any output or input, which also impacts the available `sasl.mechanism` for the Kafka output where only `PLAIN` is supported.
This impacts [Filebeat](https://www.elastic.co/docs/reference/beats/filebeat/configuration-kerberos), [Metricbeat](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-kerberos) and APM Server, as well as output configurations for Elastic Agent with Fleet Server.

### APM Server

- The [Secrets Keystore](https://www.elastic.co/docs/solutions/observability/apm/apm-server/secrets-keystore-for-secure-settings) is not supported.


### Filebeat

- The [Secrets Keystore](https://www.elastic.co/docs/reference/beats/filebeat/keystore) is not supported.
- The [Translate GUID processor](https://www.elastic.co/docs/reference/beats/filebeat/processor-translate-guid) is not supported.
- The [Fingerprint processor](https://www.elastic.co/docs/reference/beats/filebeat/fingerprint) does not support the md5 and sha1 method.
- The [Community ID Network Flowhash processor](https://www.elastic.co/docs/reference/beats/filebeat/community-id) is not supported.
- The [Azure module](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-azure) including the [Azure eventhub input](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-azure-eventhub) and the [Azure Blob Storage Input](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-azure-blob-storage) are not currently supported. The [Add Cloud Metadata processor](https://www.elastic.co/docs/reference/beats/filebeat/add-cloud-metadata) does not support the Azure Virtual Machine provider currently.
- The [Office 365 module (Beta)](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-module-o365) and the [Office 365 input (Deprecated)](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-o365audit) are not supported.
- The [GCP Pub/Sub input](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-gcp-pubsub) and the [Google Cloud Storage input](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-gcs) are not supported for now.
- The [Entity Analytics input](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-entity-analytics) is not supported.


### Metricbeat

- The [Secrets Keystore](https://www.elastic.co/docs/reference/beats/metricbeat/keystore) is not supported.
- The [Translate GUID processor](https://www.elastic.co/docs/reference/beats/metricbeat/processor-translate-guid) is not supported.
- The [Fingerprint processor](https://www.elastic.co/docs/reference/beats/metricbeat/fingerprint) does not support the md5 and sha1 method.
- The [Community ID Network Flowhash processor](https://www.elastic.co/docs/reference/beats/metricbeat/community-id) is not supported.
- The [Azure module](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-azure) is currently not supported. The [Add Cloud Metadata processor](https://www.elastic.co/docs/reference/beats/metricbeat/add-cloud-metadata) does not support the Azure Virtual Machine provider currently.
- The [Google Cloud Platform module](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-gcp) is currently not supported.
- The [Beta KVM module](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-kvm) is not yet supported.
- The [Mongo DB module](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-mongodb) is not supported.
- The [MySQL](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-mysql), [PostgreSQL](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-postgresql), [MSSQL](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-mssql) and [SQL](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-sql) modules are not supported.
- The [Oracle module](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-oracle) is not supported.


### Elastic Agent and Fleet Server

When you use Elastic Agent and Fleet Server, these limitations apply:
- Running Elastic Agent in [OpenTelemetry mode](https://github.com/elastic/elastic-agent/blob/main/internal/pkg/otel/README.md) is not yet supported. This includes all receivers, such as Filebeat Receiver, Metricbeat Receiver, [Prometheus Receiver](https://www.elastic.co/docs/reference/integrations/prometheus).
- Some Elastic Integrations are not FIPS compatible, as they depend on functionality that is not yet supported for FIPS configuration. In general, when using Elastic Agent and Fleet Server, the same restrictions listed previously for Metricbeat and Filebeat modules, inputs, and processors apply.


### Elastic Integrations that are not FIPS compatible

These Elastic Integrations have components that are **not** FIPS compatible, and **cannot** be used in FIPS environments, even if combined with other ingest tools that offer FIPS mode.
- [Azure Logs Integration (v2 preview)](https://www.elastic.co/docs/reference/integrations/azure/events)
- [Azure Event Hub Input](https://www.elastic.co/docs/reference/integrations/azure/eventhub)
- [Azure AI Foundry Integration](https://www.elastic.co/docs/reference/integrations/azure_ai_foundry)
- [Azure App Service Integration](https://www.elastic.co/docs/reference/integrations/azure_app_service)
- [Azure Application Insights Integration](https://www.elastic.co/docs/reference/integrations/azure_application_insights)
- [Azure Billing Metrics Integration](https://www.elastic.co/docs/reference/integrations/azure_billing)
- [Azure Functions Integration](https://www.elastic.co/docs/reference/integrations/azure_functions)
- [Custom Azure Logs Integration](https://www.elastic.co/docs/reference/integrations/azure_logs)
- [Azure Resource Metrics Integration](https://www.elastic.co/docs/reference/integrations/azure_metrics)
- [Azure OpenAI Integration](https://www.elastic.co/docs/reference/integrations/azure_openai)
- [SQL Input](https://www.elastic.co/docs/reference/integrations/sql)
- [PostgreSQL Integration](https://www.elastic.co/docs/reference/integrations/postgresql)
- [MongoDB Integration](https://www.elastic.co/docs/reference/integrations/mongodb)
- [MySQL Integration](https://www.elastic.co/docs/reference/integrations/mysql)
- [Microsoft SQL Server Integration](https://www.elastic.co/docs/reference/integrations/microsoft_sqlserver)
- [Oracle Integration](https://www.elastic.co/docs/reference/integrations/oracle)