﻿---
title: Manage TLS certificates on ECK
description: All Elastic Stack resources deployed by the ECK operator are secured by default. The operator sets up basic authentication and TLS to encrypt network...
url: https://www.elastic.co/docs/deploy-manage/security/eck-tls
products:
  - Elastic Cloud on Kubernetes
applies_to:
  - Elastic Cloud on Kubernetes: Generally available
---

# Manage TLS certificates on ECK
All Elastic Stack resources deployed by the ECK operator are secured by default. The operator sets up basic authentication and TLS to encrypt network traffic to, from, and within your Elasticsearch cluster and Kibana instances.
Refer to [Communication channels](/docs/deploy-manage/security/secure-cluster-communications#communication-channels) for an overview about the different endpoints and traffic flows to secure.

## Elasticsearch transport layer configuration

Elasticsearch transport security and TLS certificates are automatically configured by the operator, but you can still [customize the Elasticsearch transport service, certificate authority, and certificates](https://www.elastic.co/docs/deploy-manage/security/k8s-transport-settings).

## Elasticsearch and Kibana HTTP configuration

HTTP TLS is automatically enabled for Elasticsearch and Kibana using self-signed certificates, with [several options available for customization](https://www.elastic.co/docs/deploy-manage/security/k8s-https-settings), including custom certificates and domain names.
Kibana instances are automatically configured to connect securely to Elasticsearch, without requiring manual setup.

## Certificates lifecycle

ECK provides flexible options for managing SSL certificates in your deployments, including automatic certificate generation and rotation, integration with external tools like `cert-manager`, or using your own custom certificates. Custom HTTP certificates require manual management.
ECK automatically rotates any certificates and CAs that were generated by the operator and are under its management.
For certificate management configuration options, refer to [ECK configuration flags](https://www.elastic.co/docs/reference/cloud-on-k8s/eck-configuration-flags).