﻿---
title: Encrypt your deployment data
description: Elastic Cloud Hosted deployments and Elastic Cloud Serverless projects are already encrypted at rest by default. This includes their data, objects, and...
url: https://www.elastic.co/docs/deploy-manage/security/data-security
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Cloud Hosted: Generally available
---

# Encrypt your deployment data
Elastic Cloud Hosted deployments and Elastic Cloud Serverless projects are already encrypted at rest by default. This includes their data, objects, and settings.
For Elastic Cloud Serverless projects, security is fully-managed by Elastic.
For Elastic Cloud Hosted deployments, instead of the default, Elastic-managed encryption, you can choose to use a [customer-managed encryption key](https://www.elastic.co/docs/deploy-manage/security/encrypt-deployment-with-customer-managed-encryption-key) to encrypt your Elastic Cloud Hosted deployments.
<note>
  There is no encryption at rest out of the box for deployments orchestrated using Elastic Cloud Enterprise and Elastic Cloud on Kubernetessecure-your-eck-installation.md, or for self-managed clusters. You must instead configure disk-level encryption on your hosts.Configuring dm-crypt or similar technologies is outside the scope of the Elastic documentation, and issues related to disk encryption are outside the scope of support.
</note>

<tip>
  As an alternative to or in addition to encryption at rest, you can also use the following features to encrypt sensitive data and objects:
  - Store sensitive settings using the [Elasticsearch or Kibana keystores](https://www.elastic.co/docs/deploy-manage/security/secure-settings).
  - Enable [encryption for Kibana saved objects](https://www.elastic.co/docs/deploy-manage/security/secure-saved-objects).
</tip>