* [Manage TLS certificates](/deploy-manage/security/secure-cluster-communications.md): TLS certificates apply security controls to network communications. Elastic uses TLS certificates to secure communications in two places:
  * **The HTTP layer**: Used for communication between your cluster or deployment and the internet.
  * **The transport layer**: Used mainly for inter-node communications, and in certain cases for cluster to cluster communication.
  * In self-managed {{es}} clusters, you can also [Configure {{kib}} and {{es}} to use mutual TLS](/deploy-manage/security/kibana-es-mutual-tls.md).
* [Enable cipher suites for stronger encryption](/deploy-manage/security/enabling-cipher-suites-for-stronger-encryption.md): The TLS and SSL protocols use a cipher suite that determines the strength of encryption used to protect the data. You may want to enable the use of additional cipher suites, so you can use different cipher suites for your TLS communications or communications with authentication providers.
* [Add network security policies](/deploy-manage/security/network-security.md): Network security allows you to limit how your deployments can be accessed. Add another layer of security to your installation and deployments by restricting inbound traffic to only the sources that you trust. In both {{ech}} deployments and {{serverless-short}} projects, you can restrict access based on IP addresses or CIDR ranges. In {{ech}} deployments, you can secure connectivity through AWS PrivateLink, Azure Private Link, or GCP Private Service Connect and filter traffic using VPC filters.
* [Allow or deny {{ech}} IP ranges](/deploy-manage/security/elastic-cloud-static-ips.md): {{ecloud}} publishes a list of IP addresses used by its {{ech}} services for both incoming and outgoing traffic. Users can use these lists to configure their network firewalls as needed to allow or restrict traffic related to {{ech}} services.