﻿---
title: Migrate from the legacy cross-cluster search deployment template in Elastic Cloud Enterprise
description: The legacy cross-cluster search deployment template was removed in Elastic Cloud Enterprise 3.0. You no longer need a dedicated template to search across...
url: https://www.elastic.co/docs/deploy-manage/remote-clusters/ece-migrate-ccs
products:
  - Elastic Cloud Enterprise
applies_to:
  - Elastic Cloud Enterprise: Generally available
---

# Migrate from the legacy cross-cluster search deployment template in Elastic Cloud Enterprise
The legacy cross-cluster search deployment template was removed in Elastic Cloud Enterprise 3.0. You no longer need a dedicated template to search across deployments. Instead, you can now use any template to [configure remote clusters](https://www.elastic.co/docs/deploy-manage/remote-clusters/ece-enable-ccs) and search across them. Existing deployments created using this template are not affected, but they are required to migrate to another template before upgrading to Elastic Stack 8.x.
<important>
  This guide only applies to Elastic Cloud Enterprise 3.x installations and to deployments on Elastic Stack versions earlier than 8.0 that were created using the legacy cross-cluster search template.
</important>

Follow these instructions to migrate your existing CCS deployment that uses the legacy cross-cluster search template and its data to a new deployment.

## Use a snapshot to migrate deployments that use the cross-cluster search deployment template

You can make this change in the user Cloud UI. The only drawback of this method is that it changes the URL used to access the Elasticsearch cluster and Kibana.
1. The first step for any approach is to remove the remote clusters from your deployment. You will need to add them back later.
2. From the deployment menu, open the **Snapshots** page and click **Take Snapshot now**. Wait for the snapshot to finish.
3. From the main **Deployments** page, click **Create deployment**. Next to **Settings** toggle on **Restore snapshot data**, and then select your deployment and the snapshot that you created.
   ![Create a Deployment using a snapshot](https://www.elastic.co/docs/deploy-manage/images/cloud-enterprise-ce-create-from-snapshot-updated.png)
4. Finally, [configure the remote clusters](https://www.elastic.co/docs/deploy-manage/remote-clusters/ece-remote-cluster-other-ece).