﻿---
title: Manage trusted environments for remote connections in Elastic Cloud Enterprise
description: 
url: https://www.elastic.co/docs/deploy-manage/remote-clusters/ece-edit-remove-trusted-environment
products:
  - Elastic Cloud Enterprise
applies_to:
  - Elastic Cloud Enterprise: Generally available
---

# Manage trusted environments for remote connections in Elastic Cloud Enterprise
From a deployment's **Security** page, you can manage trusted environments that were created previously. This can happen when:
- You no longer need a trusted environment and want to remove it.
- You want to refresh the certificate, or add or remove trusted deployments of an existing trusted environment relying on certificates as a security model.
- You want to remove or update the access level granted by a cross-cluster API key.


## Remove a certificate-based trusted environment

By removing a trusted environment, this deployment will no longer be able to establish remote connections using certificate trust to clusters of that environment. The remote environment will also no longer be able to connect to this deployment using certificate trust.
<note>
  With this method, you can only remove trusted environments relying exclusively on certificates. To remove remote connections that use API keys for authentication, refer to [Change a cross-cluster API key used for a remote connection](#edit-remove-trusted-environment-api-key).
</note>

1. Go to the deployment's **Security** page.
2. In the list of trusted environments, locate the one you want to remove.
3. Remove it using the corresponding `delete` icon.
   ![button for deleting a trusted environment](https://www.elastic.co/docs/deploy-manage/images/cloud-delete-trust-environment.png)
4. Go to the **Remote Clusters** management page in the navigation menu or use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
5. In the list of existing remote clusters, delete the ones corresponding to the trusted environment you removed earlier.


## Update a certificate-based trusted environment

1. Go to the deployment's **Security** page.
2. In the list of trusted environments, locate the one you want to edit.
3. Open its details by selecting the `Edit` icon.
   ![button for editing a trusted environment](https://www.elastic.co/docs/deploy-manage/images/cloud-edit-trust-environment.png)
4. Edit the trust configuration for that environment:
   - From the **Trust level** tab, you can add or remove trusted deployments.
- From the **Environment settings** tab, you can manage the certificates and the label of the environment.
5. Save your changes.


## Change a cross-cluster API key used for a remote connection

This section describes the steps to change the API key used for an existing remote connection. For example, if the previous key expired and you need to rotate it with a new one.
<note>
  If you need to update the permissions granted by a cross-cluster API key for a remote connection, you only need to update the privileges granted by the API key directly in Kibana.
</note>

1. On the deployment you will use as remote, use the [Elasticsearch API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-security-create-cross-cluster-api-key) or [Kibana](https://www.elastic.co/docs/deploy-manage/api-keys/elasticsearch-api-keys) to create a cross-cluster API key with the appropriate permissions. Configure it with access to the indices you want to use for cross-cluster search or cross-cluster replication.
2. Copy the encoded key (`encoded` in the response) to a safe location. You will need it in the next steps.
3. From the navigation menu of your local deployment, select **Security** and locate the **Remote connections** section.
4. Locate the API key currently used for connecting to the remote cluster, copy its current alias, and delete it.
5. Add the new API key by selecting **Add API key**.
   - For the **Remote cluster name**, enter the same alias that was used for the previous key.
  <note>
  If you use a different alias, you also need to re-create the remote cluster in Kibana with a **Remote cluster name** that matches the new alias.
  </note>
- For the **Cross-cluster API key**, paste the encoded cross-cluster API key, then click **Add** to save the API key to the keystore.
6. Restart the local deployment to reload the keystore with its new setting. To do that, go to the deployment's main page (named after your deployment's name), locate the **Actions** menu, and select **Restart Elasticsearch**.
   <note>
   If the local deployment runs on version 8.14 or greater, you no longer need to perform this step because the keystore is reloaded automatically with the new API keys.
   </note>