﻿---
title: Connect Elastic Cloud Hosted deployments to self-managed clusters
description: This section explains how to configure a deployment to connect remotely to self-managed clusters. You can now connect remotely to the trusted clusters...
url: https://www.elastic.co/docs/deploy-manage/remote-clusters/ec-remote-cluster-self-managed
products:
  - Elastic Cloud Hosted
applies_to:
  - Elastic Cloud Hosted: Generally available
  - Self-managed Elastic deployments: Generally available
---

# Connect Elastic Cloud Hosted deployments to self-managed clusters
This section explains how to configure a deployment to connect remotely to self-managed clusters.
<admonition title="Note about terminology">
  In the case of remote clusters, the Elasticsearch cluster or deployment initiating the connection and requests is often referred to as the **local cluster**, while the Elasticsearch cluster or deployment receiving the requests is referred to as the **remote cluster**.
</admonition>


## Allow the remote connection

Before you start, consider the [security model](https://www.elastic.co/docs/deploy-manage/remote-clusters/security-models) that you would prefer to use for authenticating remote connections between clusters, and follow the corresponding steps.
<definitions>
  <definition term="API key">
    For deployments based on Elastic Stack 8.14 or later, you can use an API key to authenticate and authorize cross-cluster operations to a remote cluster. This model uses a dedicated service endpoint, on port `9443` by default, and gives administrators fine-grained control over remote access. The API key is created on the remote cluster and defines the permissions available to all cross-cluster requests, while local user roles can further restrict, but not extend, those permissions.
  </definition>
  <definition term="TLS certificate (deprecated in Elastic Stack 9.0.0)">
    This model uses mutual TLS authentication over the Elasticsearch transport interface for cross-cluster operations. User authentication is performed on the local cluster and a user's role names are passed to the remote cluster for authorization. Because a superuser on the local cluster automatically gains full read access to the remote cluster, this model is only suitable for clusters within the same security domain.
  </definition>
</definitions>

<tab-set>
  <tab-item title="API key">
    Follow these steps to configure the [API key security model](/docs/deploy-manage/remote-clusters/security-models#api-key) for remote clusters. If you run into any issues, refer to [Troubleshooting](https://www.elastic.co/docs/troubleshoot/elasticsearch/remote-clusters).

    ### Prerequisites and limitations

    - The local and remote deployments must be on Elastic Stack 8.14 or later.
    - Unlike the certificate-based security model, the API key model does not require mutual trust between clusters; only the local cluster is required to trust the remote cluster's certificate.


    ### Create a cross-cluster API key on the remote deployment

    1. On the remote cluster, use the [Elasticsearch API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-security-create-cross-cluster-api-key) or [Kibana](https://www.elastic.co/docs/deploy-manage/api-keys/elasticsearch-api-keys) to create a cross-cluster API key. Configure it to include access to the indices you want to use for cross-cluster search or cross-cluster replication.
    2. Copy the encoded key (`encoded` in the response) to a safe location. It is required for the local cluster configuration.


    ### Configure the local deployment

    The API key created previously is needed by the local deployment to authenticate with the corresponding set of permissions to the remote cluster. To enable this, add the API key to the local deployment's keystore.The steps to follow depend on whether the Certificate Authority (CA) of the remote environment’s Elasticsearch remote cluster server, proxy, or load balancing infrastructure is public or private.
    <dropdown title="The CA is public">
      1. Log in to the [Elastic Cloud Console](https://cloud.elastic.co?page=docs&placement=docs-body).
      2. On the home page, find your hosted deployment and select **Manage** to access it directly. Or, select **Hosted deployments** to go to the **Hosted deployments** page to view all of your deployments.
         On the **Hosted deployments** page you can narrow your deployments by name, ID, or choose from several other filters. To customize your view, use a combination of filters, or change the format from a grid to a list.
      3. From the navigation menu, select **Security**.
      4. Locate **Remote Connections > Trust management > Connections using API keys** and select **Add API key**.
         1. Fill both fields.
         - For the **Remote cluster name**, enter the alias of your choice. You will use this alias to connect to the remote cluster later. It must be lowercase and only contain letters, numbers, dashes and underscores.
      - For the **Cross-cluster API key**, paste the encoded cross-cluster API key.
      2. Click **Add** to save the API key.
      5. Restart the local deployment to reload the new setting. To do that, go to the deployment's main page, locate the **Actions** menu, and select **Restart Elasticsearch**.
         <note>
         If the local deployment runs on version 8.14 or greater, you no longer need to perform this step because the keystore is reloaded automatically with the new API keys.
         </note>

      If you need to update the remote connection with different permissions later, refer to [Change a cross-cluster API key used for a remote connection](/docs/deploy-manage/remote-clusters/ec-edit-remove-trusted-environment#edit-remove-trusted-environment-api-key).
    </dropdown>

    <dropdown title="The CA is private">
      1. Log in to the [Elastic Cloud Console](https://cloud.elastic.co?page=docs&placement=docs-body).
      2. On the home page, find your hosted deployment and select **Manage** to access it directly. Or, select **Hosted deployments** to go to the **Hosted deployments** page to view all of your deployments.
         On the **Hosted deployments** page you can narrow your deployments by name, ID, or choose from several other filters. To customize your view, use a combination of filters, or change the format from a grid to a list.
      3. From the navigation menu, select **Security**.
      4. Select **Remote Connections > Add trusted environment** and choose **Self-managed**. Then click **Next**.
      5. Select **API keys** as authentication mechanism and click **Next**.
      6. When asked whether the Certificate Authority (CA) of the remote environment’s proxy or load-balancing infrastructure is public, select **No, it is private**.
      7. Add the API key:
         1. Fill both fields.
         - For the **Remote cluster name**, enter the alias of your choice. You will use this alias to connect to the remote cluster later. It must be lowercase and only contain letters, numbers, dashes and underscores.
      - For the **Cross-cluster API key**, paste the encoded cross-cluster API key.
      2. Click **Add** to save the API key.
      3. Repeat these steps for each API key you want to add. For example, if you want to use several clusters of the remote environment for CCR or CCS.
      8. Add the CA certificate of the remote environment.
      9. Provide a name for the trusted environment. That name will appear in the trust summary of your deployment's **Security** page.
      10. Select **Create trust** to complete the configuration.
      11. Restart the local deployment to reload the new settings. To do that, go to the deployment's main page, locate the **Actions** menu, and select **Restart Elasticsearch**.
         <note>
         If the local deployment runs on version 8.14 or greater, you no longer need to perform this step because the keystore is reloaded automatically with the new API keys.
         </note>

      If you need to update the remote connection with different permissions later, refer to [Change a cross-cluster API key used for a remote connection](/docs/deploy-manage/remote-clusters/ec-edit-remove-trusted-environment#edit-remove-trusted-environment-api-key).
    </dropdown>
  </tab-item>

  <tab-item title="TLS certificate (deprecated)">
    To use [TLS certificates](/docs/deploy-manage/remote-clusters/security-models#tls-certificate-authentication) for remote clusters, you must establish mutual TLS trust. The local Elastic Cloud Hosted deployment must trust the Certificate Authority (CA) used by the remote self-managed cluster, and the remote self-managed cluster must trust the CA used by the local Elastic Cloud Hosted deployment.The steps below guide you through both sides of this configuration.

    #### Retrieve the CAs of both clusters

    1. Download the transport CA certificate associated with your deployment. This CA is required by the self-managed cluster to establish trust with the deployment.
       1. Open your deployment management page in the Elastic Cloud UI and go to **Security**.
    2. Under **CA certificates**, select the download icon to save the CA into a local file.
    2. Obtain the CA certificate of the self-managed cluster (the CA used to sign all transport certificates of your cluster). The CA needs to be in PEM format and should not contain the private key. If you only have the CA with the key in p12 format, then you can create the necessary file with the following command:
       ```sh
       openssl pkcs12 -in elastic-stack-ca.p12 -out newfile.crt.pem -clcerts -nokeys
       ```
       <tip>
       The transport CA used by your self-managed cluster is part of its existing [transport TLS/SSL configuration](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/security-settings#security-transport-tls-ssl-key-trusted-certificate-settings).
       </tip>


    #### Configure trust on the Elastic Cloud Hosted deployment

    A deployment can be configured to trust all or specific deployments in any environment:
    1. From the **Security** page, select **Remote Connections > Add trusted environment** and choose **Self-managed**. Then click **Next**.
    2. Select **Certificates** as authentication mechanism and click **Next**.
    3. Upload the transport CA certificate of the self-managed environment [you obtained earlier](#download-ca). The CA must be in PEM format and should not contain the private key.
    4. Select the clusters to trust. There are two options depending on the subject name of the certificates presented by the nodes in your self-managed cluster:
       - Following the Elastic Cloud pattern. In Elastic Cloud, the certificates of all Elasticsearch nodes follow this convention: `CN = {{node_id}}.node.{{cluster_id}}.cluster.{{scope_id}}`. If you follow the same convention in your self-managed environment, then choose this option and select the clusters to trust.
    - If your clusters don’t follow the previous convention for the certificates subject name of your nodes, you can still specify the node name of each of the nodes that should be trusted by this deployment.
      <tip>
      If possible, [reissue your self-managed node certificates to follow the Elastic Cloud subject name pattern](#self-reissue-certs). This greatly simplifies trust management, because otherwise you must keep the list of trusted node names up to date as your self-managed cluster topology changes.
      </tip>
      <important>
      Trust management based on certificate restrictions requires the certificates to include a specific X.509 Subject Alternative Name (SAN) entry of type `otherName`. This attribute is not present by default in certificates generated by an out-of-the-box [Elasticsearch installation](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/installing-elasticsearch).If your self-managed cluster certificates do not include `otherName`, you must reissue them. To generate compatible certificates, refer to [Optional: reissue self-managed node certificates](#self-reissue-certs).
      </important>
    5. Provide a name for the trusted environment. That name will appear in the trust summary of your deployment’s **Security** page.
    6. Select **Create trust** to complete the configuration.

    <dropdown title="Alternative method: using the API">
      You can update a deployment using the appropriate trust settings for the Elasticsearch payload.To trust a cluster whose nodes present certificates with the subject names: "CN = node1.<CLUSTER_FQDN>", "CN = node2.<CLUSTER_FQDN>" and "CN = node3.<CLUSTER_FQDN>" in a self-managed environment, you can update the trust settings with an additional direct trust relationship like this:
      ```json
      {
        "trust":{
          "accounts":[
            {
               "account_id":"ec38dd0aa45f4a69909ca5c81c27138a",
               "trust_all":true
            }
          ],
          "direct": [
            {
              "type" : "generic",
              "name" : "My Self-managed environment",
              "additional_node_names" : ["node1.<CLUSTER_FQDN>", "node2.<CLUSTER_FQDN>", "node3.<CLUSTER_FQDN>",],
              "certificates" : [
                  {
                      "pem" : "-----BEGIN CERTIFICATE-----\nMIIDTzCCA...H0=\n-----END CERTIFICATE-----"
                  }
               ],
               "trust_all":false
             }
          ]
        }
      }
      ```
    </dropdown>


    #### Optional: Reissue self-managed node certificates to follow the Elastic Cloud subject name pattern

    Reissuing the transport certificates for your self-managed nodes is recommended in the following cases:
    - Your current certificates do not include the required X.509 SAN entry of type `otherName`, which is needed for Elastic Cloud trust restrictions to work correctly.
    - You want your node certificates to follow the same subject name pattern used in Elastic Cloud, which simplifies trust management by allowing you to select clusters instead of listing individual node names.

    You can use the [Elasticsearch `certutil` tool](https://www.elastic.co/docs/reference/elasticsearch/command-line-tools/certutil) to generate new certificates that meet both requirements:
    1. Create a file called `instances.yaml` describing all the nodes in your self-managed cluster. The `dns` and `ip` fields are optional, but the `cn` field is required. When provided through this file, `certutil` automatically adds the corresponding `otherName` SAN entry used by Elasticsearch for trust restrictions:
       ```yaml
       instances:
         - name: "node1"
           dns: ["<NODE1_FQDN>"]
           ip: ["192.0.2.1"]
           cn: ["node1.node.1234567abcd.cluster.myscope.account"]
         - name: "node2"
           dns: ["<NODE2_FQDN>"]
           ip: ["192.0.2.2"]
           cn: ["node2.node.1234567abcd.cluster.myscope.account"]
       ```
       The value specified under cn should follow the Elastic Cloud naming pattern:
       ```
       <node_id>.node.<cluster_id>.cluster.<scope_id>.account
       ```
    2. Generate the new nodes certificates, using your existing self-managed transport CA:
       ```sh
       ./bin/elasticsearch-certutil cert --ca elastic-stack-ca.p12 -in instances.yaml
       ```
       This command generates a certificate and private key for each node listed in `instances.yaml`.
    3. Distribute the certificates to each node:
       Copy the generated certificate and key files to their corresponding nodes and update your Elasticsearch TLS configuration to use them. Then restart each node to apply the changes.

    After the new certificates are in place with the desired naming pattern, you can [configure trust on your Elastic Cloud deployment](#configure-trust-deployment) to align with the updated names.

    #### Configure trust on the self-managed cluster

    Follow these steps to configure trust in your self-managed cluster:
    1. Trust the [deployment CA you downloaded previously](#download-ca) by either configuring the [setting](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/security-settings) `xpack.security.transport.ssl.certificate_authorities` in [`elasticsearch.yml`](https://www.elastic.co/docs/deploy-manage/stack-settings), or by [adding it to the trust store](https://www.elastic.co/docs/deploy-manage/security/different-ca).
    2. Configure trust restrictions in the self-managed cluster:
       All the clusters in an Elastic Cloud Hosted region or an Elastic Cloud Enterprise environment are signed by the same certificate authority. As a result, if you only add this CA to your self-managed cluster, it would trust every cluster in that region or environment, including clusters that belong to other organizations.
       To avoid this, use the setting `xpack.security.transport.ssl.trust_restrictions.path`, which points to a file that limits the certificates that are trusted based on their `otherName` attribute.
       The following is an example of a trust restrictions file, with an explanation of what each entry allows:
       ```yaml
         trust.subject_name:
         - *.node.aaaabbbbaaaabbbb.cluster.1053523734.account 
         - *.node.xxxxyyyyxxxxyyyy.cluster.1053523734.account 
         - *.node.*.cluster.83988631.account 
         - node*.<CLUSTER_FQDN> 
       ```
       1. Two specific clusters with cluster ids `aaaabbbbaaaabbbb` and `xxxxyyyyxxxxyyyy` from an ECE environment or ECH organization with ID `1053523734`
    2. Any cluster from an ECE environment or ECH organization with ID `83988631`
    3. The nodes from its own cluster (whose certificates follow a different convention: `CN = node1.<CLUSTER_FQDN>`, `CN = node2.<CLUSTER_FQDN>` and `CN = node3.<CLUSTER_FQDN>`)
  </tab-item>
</tab-set>

You can now connect remotely to the trusted clusters.

## Connect to the remote cluster

On the local cluster, add the remote cluster using Kibana or the Elasticsearch API.

### Using Kibana

To add a remote cluster in Kibana:
1. Go to the **Remote Clusters** management page in the navigation menu or use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
2. Select **Add a remote cluster**.
3. In **Select connection type**, choose the authentication mechanism you prepared earlier (**API keys** or **Certificates**), and click **Next**.
4. In **Add connection information**, fill in the following fields:
   - **Remote cluster name**: This *cluster alias* is a unique identifier that represents the connection to the remote cluster and is used to distinguish local and remote indices.
  When using API key authentication, this alias must match the **Remote cluster name** you configured when [adding the API key](#configure-local-cluster).
- **Remote address**: Enter the endpoint of the remote cluster, including the hostname, FQDN, or IP address, and the port.
  Make sure you use the correct port for your authentication method:
  - **API keys**: Use the port configured in the remote cluster interface of the remote cluster (defaults to `9443`).
- **TLS Certificates**: Use the Elasticsearch transport port (defaults to `9300`).
  Starting with Kibana 9.2, this field also supports IPv6 addresses. When using an IPv6 address, enclose it in square brackets followed by the port number. For example: `[2001:db8::1]:9443`.
- **Configure advanced options** (optional): Expand this section if you need to customize additional settings.
  - **TLS server name**: Specify a value if the certificate presented by the remote cluster is signed for a different name than the remote address.
- **Socket connections**: Define the number of connections to open with the remote cluster.
5. Click **Next**.
6. In **Confirm setup**, click **Add remote cluster** (you have already established trust in a previous step).


### Using the Elasticsearch API

To add a remote cluster, use the [cluster update settings API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cluster-put-settings). Configure the following fields:
- **Remote cluster alias**: When using API key authentication, the cluster alias must match the one you configured when [adding the API key](#configure-local-cluster).
- **mode**: `proxy`
- **proxy_address**: Enter the endpoint of the remote cluster, including the hostname, FQDN, or IP address, and the port. Both IPv4 and IPv6 addresses are supported.
  Make sure you use the correct port for your authentication method:
  - **API keys**: Use the port configured in the remote cluster interface of the remote cluster (defaults to `9443`).
- **TLS Certificates**: Use the Elasticsearch transport port (defaults to `9300`).
  When using an IPv6 address, enclose it in square brackets followed by the port number. For example: `[2001:db8::1]:9443`.
- **server_name**: Specify a value if the certificate presented by the remote cluster is signed for a different name than the proxy_address.

This is an example of the API call to add or update a remote cluster:
```json
PUT /_cluster/settings
{
  "persistent": {
    "cluster": {
      "remote": {
        "alias-for-my-remote-cluster": {
          "mode":"proxy",
          "proxy_address": "<REMOTE_CLUSTER_ADDRESS>:9443",
          "server_name": "<REMOTE_CLUSTER_SERVER_NAME>"
        }
      }
    }
  }
}
```

For a full list of available client connection settings in proxy mode, refer to the [remote cluster settings reference](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/remote-clusters#remote-cluster-proxy-settings).

## Configure roles and users

If you're using the API key–based security model for cross-cluster replication or cross-cluster search, you can define user roles with [remote indices privileges](/docs/deploy-manage/users-roles/cluster-or-deployment-auth/role-structure#roles-remote-indices-priv) on the local cluster to further restrict the permissions granted by the API key. For more details, refer to [Configure roles and users](/docs/deploy-manage/remote-clusters/remote-clusters-api-key#remote-clusters-privileges-api-key).