﻿---
title: Connect to deployments in the same Elastic Cloud organization
description: This section explains how to configure a deployment to connect remotely to clusters belonging to the same Elastic Cloud organization. You can now connect...
url: https://www.elastic.co/docs/deploy-manage/remote-clusters/ec-remote-cluster-same-ess
products:
  - Elastic Cloud Hosted
applies_to:
  - Elastic Cloud Hosted: Generally available
---

# Connect to deployments in the same Elastic Cloud organization
This section explains how to configure a deployment to connect remotely to clusters belonging to the same Elastic Cloud organization.
<admonition title="Note about terminology">
  In the case of remote clusters, the Elasticsearch cluster or deployment initiating the connection and requests is often referred to as the **local cluster**, while the Elasticsearch cluster or deployment receiving the requests is referred to as the **remote cluster**.
</admonition>

<note>
  If network security policies are applied to the remote cluster, the remote cluster administrator must configure a [private connection policy of type remote cluster](https://www.elastic.co/docs/deploy-manage/security/remote-cluster-filtering), using either the organization ID or the Elasticsearch cluster ID of the local cluster as the filtering criteria. For more information, refer to [Remote clusters and network security](/docs/deploy-manage/remote-clusters#network-security).
</note>


## Allow the remote connection

Before you start, consider the [security model](https://www.elastic.co/docs/deploy-manage/remote-clusters/security-models) that you would prefer to use for authenticating remote connections between clusters, and follow the corresponding steps.
<definitions>
  <definition term="API key">
    For deployments based on Elastic Stack 8.14 or later, you can use an API key to authenticate and authorize cross-cluster operations to a remote cluster. This model uses a dedicated service endpoint, on port `9443` by default, and gives administrators fine-grained control over remote access. The API key is created on the remote cluster and defines the permissions available to all cross-cluster requests, while local user roles can further restrict, but not extend, those permissions.
  </definition>
  <definition term="TLS certificate (deprecated in Elastic Stack 9.0.0)">
    This model uses mutual TLS authentication over the Elasticsearch transport interface for cross-cluster operations. User authentication is performed on the local cluster and a user's role names are passed to the remote cluster for authorization. Because a superuser on the local cluster automatically gains full read access to the remote cluster, this model is only suitable for clusters within the same security domain.
  </definition>
</definitions>

<tab-set>
  <tab-item title="API key">
    Follow these steps to configure the [API key security model](/docs/deploy-manage/remote-clusters/security-models#api-key) for remote clusters. If you run into any issues, refer to [Troubleshooting](https://www.elastic.co/docs/troubleshoot/elasticsearch/remote-clusters).

    ### Prerequisites and limitations

    - The local and remote deployments must be on Elastic Stack 8.14 or later.
    - Unlike the certificate-based security model, the API key model does not require mutual trust between clusters; only the local cluster is required to trust the remote cluster's certificate.


    ### Create a cross-cluster API key on the remote deployment

    1. On the remote cluster, use the [Elasticsearch API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-security-create-cross-cluster-api-key) or [Kibana](https://www.elastic.co/docs/deploy-manage/api-keys/elasticsearch-api-keys) to create a cross-cluster API key. Configure it to include access to the indices you want to use for cross-cluster search or cross-cluster replication.
    2. Copy the encoded key (`encoded` in the response) to a safe location. It is required for the local cluster configuration.


    ### Add the cross-cluster API key to the local deployment

    The API key created previously is needed by the local deployment to authenticate with the corresponding set of permissions to the remote deployment. To enable this, add the API key to the local deployment's keystore.
    1. Log in to the [Elastic Cloud Console](https://cloud.elastic.co?page=docs&placement=docs-body).
    2. On the home page, find your hosted deployment and select **Manage** to access it directly. Or, select **Hosted deployments** to go to the **Hosted deployments** page to view all of your deployments.
       On the **Hosted deployments** page you can narrow your deployments by name, ID, or choose from several other filters. To customize your view, use a combination of filters, or change the format from a grid to a list.
    3. From the navigation menu, select **Security**.
    4. Locate **Remote Connections > Trust management > Connections using API keys** and select **Add API key**.
       1. Fill both fields.
       - For the **Remote cluster name**, enter the alias of your choice. You will use this alias to connect to the remote cluster later. It must be lowercase and only contain letters, numbers, dashes and underscores.
    - For the **Cross-cluster API key**, paste the encoded cross-cluster API key.
    2. Click **Add** to save the API key.
    5. Restart the local deployment to reload the new setting. To do that, go to the deployment's main page, locate the **Actions** menu, and select **Restart Elasticsearch**.
       <note>
       If the local deployment runs on version 8.14 or greater, you no longer need to perform this step because the keystore is reloaded automatically with the new API keys.
       </note>

    If you need to update the remote connection with different permissions later, refer to [Change a cross-cluster API key used for a remote connection](/docs/deploy-manage/remote-clusters/ec-edit-remove-trusted-environment#edit-remove-trusted-environment-api-key).
  </tab-item>

  <tab-item title="TLS certificate (deprecated)">
    ### Set the default trust with other clusters in the same Elastic Cloud organizationTo configure this behavior in the [Elastic Cloud Console](https://cloud.elastic.co?page=docs&placement=docs-body), go to **Trust management** from the lower navigation menu. The **Trust all deployments** option is switched on by default. You can keep it switched on or switch it off.

    - When **Trust all deployments** is switched on - All deployments trust all other deployments in the same organization, including new deployments when they are created. If you keep this setting switched on, you can jump to [Connect to the remote cluster](#ec_connect_to_the_remote_cluster) to finalize the CCS or CCR configuration.
    - When **Trust all deployments** is switched off - New deployments won’t trust any other deployments. Instead, you can configure trust for each of them in their security settings, as described in the next section.

    <note>
      - The level of trust of existing deployments is not modified when you change this setting. Instead, you must update the individual trust settings for each deployment you wish to change.
      - Deployments created before the Elastic Cloud February 2021 release trust only themselves. You have to update the trust setting for each deployment that you want to either use as a remote cluster or configure to work with a remote cluster.
    </note>


    ### Specify the deployments trusted to be used as remote clustersIf your organization’s deployments already trust each other by default, you can skip this section. If that’s not the case, follow these steps to configure which specific deployments should be trusted.

    1. Go to the **Security** page of your deployment.
    2. From the list of existing trust configurations, edit the one labeled as your organization.
    3. Choose one of following options to configure the level of trust on each of your deployments:
       - **All deployments** - This deployment trusts all other deployments in this environment, including new deployments when they are created.
    - **Specific deployments** - Choose which of the existing deployments from your environment you want to trust.
    - **None** - No deployment in this environment is trusted.
       <note>
       When trusting specific deployments, the more restrictive [CCS](/docs/deploy-manage/remote-clusters/remote-clusters-self-managed#sniff-mode) version policy is used (even if you only want to use [CCR](https://www.elastic.co/docs/deploy-manage/tools/cross-cluster-replication)). To work around this restriction for CCR-only trust, it is necessary to use the API as described below.
       </note>
    4. Repeat these steps from each of the deployments you want to use for CCS or CCR. You will only be able to connect two deployments successfully when both of them trust each other.

    <dropdown title="Using the API">
      You can update a deployment using the appropriate trust settings for the Elasticsearch payload.The current trust settings can be found in the path `.resources.elasticsearch[0].info.settings.trust` when calling:
      ```sh
      curl -k -X GET -H "Authorization: ApiKey $ECE_API_KEY" https://$COORDINATOR_HOST:12443/api/v1/deployments/$DEPLOYMENT_ID?show_settings=true
      ```
      For example:
      ```json
      {
        "accounts": [
          {
            "account_id": "ec38dd0aa45f4a69909ca5c81c27138a",
            "trust_all": true
          }
        ]
      }
      ```
      The `account_id` above represents the only account in an Elasticsearch environment, and therefore is the one used to update the trust level with deployments in the current Elasticsearch environment. For example, to update the trust level to trust only the deployment with cluster ID `cf659f7fe6164d9691b284ae36811be1` (NOTE: use the Elasticsearch cluster ID, not the deployment ID), the trust settings in the body would look like this:
      ```json
      {
        "trust":{
          "accounts":[
            {
               "account_id":"ec38dd0aa45f4a69909ca5c81c27138a",
               "trust_all":false,
               "trust_allowlist":[
                  "cf659f7fe6164d9691b284ae36811be1"
               ]
            }
          ]
        }
      }
      ```
    </dropdown>
  </tab-item>
</tab-set>

You can now connect remotely to the trusted clusters.

## Connect to the remote cluster

On the local cluster, add the remote cluster using Kibana, the Elasticsearch API, or the Elastic Cloud API.

### Using Kibana

To add a remote cluster in Kibana:
1. Go to the **Remote Clusters** management page in the navigation menu or use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
2. Select **Add a remote cluster**.
3. In **Select connection type**, choose the authentication mechanism you prepared earlier (**API keys** or **Certificates**), and then click **Next**.
4. In **Add connection information**, fill in the following fields:
   - **Remote cluster name**: This *cluster alias* is a unique identifier that represents the connection to the remote cluster and is used to distinguish local and remote indices.
  When using API key authentication, this alias must match the **Remote cluster name** you configured when [adding the API key](#configure-local-cluster) in the Cloud UI.
- **Remote address**: This value can be found on the **Security** page of the Elastic Cloud Hosted deployment you want to use as a remote. Copy the **Proxy address** from the **Remote cluster parameters** section.
  <note>
  If you’re using API keys as security model, change the port to `9443`.
  </note>
- **Configure advanced options** (optional): Expand this section if you need to customize additional settings.
  - **TLS server name**: Specify a value if the certificate presented by the remote cluster is signed for a different name than the remote address.
  This value can be found on the **Security** page of the Elastic Cloud Hosted deployment you want to use as a remote. Copy the **Server name** from the **Remote cluster parameters** section.
- **Socket connections**: Define the number of connections to open with the remote cluster.
   For a full list of available client connection settings, refer to the [remote cluster settings reference](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/remote-clusters#remote-cluster-proxy-settings).
5. Click **Next**.
6. In **Confirm setup**, click **Add remote cluster** (you have already established trust in a previous step).


### Using the Elasticsearch API

To add a remote cluster, use the [cluster update settings API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cluster-put-settings). Configure the following fields:
- **Remote cluster alias**: When using API key authentication, the cluster alias must match the one you configured when [adding the API key](#configure-local-cluster) in the Cloud UI as **Remote cluster name**.
- **mode**: `proxy`
- **proxy_address**: This value can be found on the **Security** page of the Elastic Cloud Hosted deployment you want to use as a remote. Copy the **Proxy address** from the **Remote cluster parameters** section.
  Using the API, this value can be obtained from the Elasticsearch resource info, concatenating the field `metadata.endpoint` and port `9400` using a semicolon.
  <note>
  If you’re using API keys as security model, change the port to `9443`.
  </note>
- **server_name**: This value can be found on the **Security** page of the Elastic Cloud Hosted deployment you want to use as a remote. Copy the **Server name** from the **Remote cluster parameters** section.
  Using the API, this can be obtained from the Elasticsearch resource info field `metadata.endpoint`.

This example shows the API call to add or update a remote cluster. The alias `alias-for-my-remote-cluster` must match the remote cluster name used when adding the API key to the deployment:
```json
PUT /_cluster/settings
{
  "persistent": {
    "cluster": {
      "remote": {
        "alias-for-my-remote-cluster": {
          "mode":"proxy",
          "proxy_address": "<REMOTE_CLUSTER_ADDRESS>:9443",
          "server_name": "<REMOTE_CLUSTER_SERVER_NAME>"
        }
      }
    }
  }
}
```

For a full list of available client connection settings in proxy mode, refer to the [remote cluster settings reference](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/remote-clusters#remote-cluster-proxy-settings).

### Using the Elastic Cloud API

<applies-to>
  - Elastic Cloud Hosted: Deprecated
</applies-to>

<note>
  This section only applies if you’re using TLS certificates as cross-cluster security model and when both clusters belong to the same organization. For other scenarios, the [Elasticsearch API](#ec_using_the_elasticsearch_api) should be used instead.
</note>

```sh
curl -H 'Content-Type: application/json' -X PUT -H "Authorization: ApiKey $EC_API_KEY" https://api.elastic-cloud.com/api/v1/deployments/$DEPLOYMENT_ID/elasticsearch/$REF_ID/remote-clusters -d '
{
  "resources" : [
    {
      "deployment_id": "$DEPLOYMENT_ID_REMOTE",
      "elasticsearch_ref_id": "$REF_ID_REMOTE",
      "alias": "alias-your-remote",
      "skip_unavailable" : true
    }
  ]
}'
```

<definitions>
  <definition term="DEPLOYMENT_ID_REMOTE">
    The ID of your remote deployment, as shown in the Cloud UI or obtained through the API.
  </definition>
  <definition term="REF_ID_REMOTE">
    The unique ID of the Elasticsearch resources inside your remote deployment (you can obtain these values through the API).
  </definition>
</definitions>

Note the following when using the Elastic Cloud RESTful API:
1. A cluster alias must contain only letters, numbers, dashes (-), or underscores (_).
2. To learn about skipping disconnected clusters, refer to the [Elasticsearch documentation](/docs/explore-analyze/cross-cluster-search#skip-unavailable-clusters).
3. When remote clusters are already configured for a deployment, the `PUT` request replaces the existing configuration with the new configuration passed. Passing an empty array of resources will remove all remote clusters.

The following API request retrieves the remote clusters configuration:
```sh
curl -X GET -H "Authorization: ApiKey $EC_API_KEY" https://api.elastic-cloud.com/api/v1/deployments/$DEPLOYMENT_ID/elasticsearch/$REF_ID/remote-clusters
```

<note>
  The response will include just the remote clusters from the same Elastic Cloud organization. In order to obtain the whole list of remote clusters, use Kibana or the [Elasticsearch API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cluster-remote-info) directly.
</note>


## Configure roles and users

If you're using the API key–based security model for cross-cluster replication or cross-cluster search, you can define user roles with [remote indices privileges](/docs/deploy-manage/users-roles/cluster-or-deployment-auth/role-structure#roles-remote-indices-priv) on the local cluster to further restrict the permissions granted by the API key. For more details, refer to [Configure roles and users](/docs/deploy-manage/remote-clusters/remote-clusters-api-key#remote-clusters-privileges-api-key).