﻿---
title: Remote clusters on Elastic Cloud Hosted
description: You can configure an Elastic Cloud Hosted deployment to either connect to remote clusters or accept connections from: Another Elastic Cloud Hosted deployment...
url: https://www.elastic.co/docs/deploy-manage/remote-clusters/ec-enable-ccs
products:
  - Elastic Cloud Hosted
applies_to:
  - Elastic Cloud Hosted: Generally available
---

# Remote clusters on Elastic Cloud Hosted
You can configure an Elastic Cloud Hosted deployment to either connect to remote clusters or accept connections from:
- Another Elastic Cloud Hosted deployment of your Elastic Cloud organization, across any region or cloud provider (AWS, GCP, Azure…)
- An Elastic Cloud Hosted deployment of another Elastic Cloud organization
- A deployment in an Elastic Cloud Enterprise installation
- A deployment in an Elastic Cloud on Kubernetes installation
- A self-managed installation.

<note>
  Refer to [Remote clusters and network security](/docs/deploy-manage/remote-clusters#network-security) for details on how remote clusters interact with network security policies and the implications for your deployments.
</note>


## Prerequisites

To use CCS or CCR, your deployments must meet the following criteria:
- The local and remote clusters must run on compatible versions of Elasticsearch. Review the version compatibility table.
  <dropdown title="Version compatibility table">
  - Any node can communicate with another node on the same major version. For example, 9.0 can talk to any 9.x node.
  - Version compatibility is symmetric, meaning that if 7.16 can communicate with 8.0, 8.0 can also communicate with 7.16. The following table depicts version compatibility between local and remote nodes.

  <note>
  Version 8.19 is the final minor release in the 8.x series. Unlike past releases, 8.18 was launched simultaneously with 9.0, allowing cross-version compatibility between them. Hence, as shown in the compatibility table, 8.18 can search 9.0 clusters, but only 8.19 supports searching 9.1 and later.
  </note>


  |                       |                        |     |     |     |     |     |     |     |     |     |     |      |      |      |      |      |      |      |      |      |      |     |     |     |     |
  |-----------------------|------------------------|-----|-----|-----|-----|-----|-----|-----|-----|-----|-----|------|------|------|------|------|------|------|------|------|------|-----|-----|-----|-----|
  |                       | Remote cluster version |     |     |     |     |     |     |     |     |     |     |      |      |      |      |      |      |      |      |      |      |     |     |     |     |
  | Local cluster version | 7.17                   | 8.0 | 8.1 | 8.2 | 8.3 | 8.4 | 8.5 | 8.6 | 8.7 | 8.8 | 8.9 | 8.10 | 8.11 | 8.12 | 8.13 | 8.14 | 8.15 | 8.16 | 8.17 | 8.18 | 8.19 | 9.0 | 9.1 | 9.2 | 9.3 |
  | 7.17                  | ✅                      | ✅   | ✅   | ✅   | ✅   | ✅   | ✅   | ✅   | ✅   | ✅   | ✅   | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ❌   | ❌   | ❌   | ❌   |
  | 8.0                   | ✅                      | ✅   | ✅   | ✅   | ✅   | ✅   | ✅   | ✅   | ✅   | ✅   | ✅   | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ❌   | ❌   | ❌   | ❌   |
  | 8.1                   | ❌                      | ✅   | ✅   | ✅   | ✅   | ✅   | ✅   | ✅   | ✅   | ✅   | ✅   | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ❌   | ❌   | ❌   | ❌   |
  | 8.2                   | ❌                      | ❌   | ✅   | ✅   | ✅   | ✅   | ✅   | ✅   | ✅   | ✅   | ✅   | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ❌   | ❌   | ❌   | ❌   |
  | 8.3                   | ❌                      | ❌   | ❌   | ✅   | ✅   | ✅   | ✅   | ✅   | ✅   | ✅   | ✅   | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ❌   | ❌   | ❌   | ❌   |
  | 8.4                   | ❌                      | ❌   | ❌   | ❌   | ✅   | ✅   | ✅   | ✅   | ✅   | ✅   | ✅   | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ❌   | ❌   | ❌   | ❌   |
  | 8.5                   | ❌                      | ❌   | ❌   | ❌   | ❌   | ✅   | ✅   | ✅   | ✅   | ✅   | ✅   | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ❌   | ❌   | ❌   | ❌   |
  | 8.6                   | ❌                      | ❌   | ❌   | ❌   | ❌   | ❌   | ✅   | ✅   | ✅   | ✅   | ✅   | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ❌   | ❌   | ❌   | ❌   |
  | 8.7                   | ❌                      | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ✅   | ✅   | ✅   | ✅   | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ❌   | ❌   | ❌   | ❌   |
  | 8.8                   | ❌                      | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ✅   | ✅   | ✅   | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ❌   | ❌   | ❌   | ❌   |
  | 8.9                   | ❌                      | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ✅   | ✅   | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ❌   | ❌   | ❌   | ❌   |
  | 8.10                  | ❌                      | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ✅   | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ❌   | ❌   | ❌   | ❌   |
  | 8.11                  | ❌                      | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ❌   | ❌   | ❌   | ❌   |
  | 8.12                  | ❌                      | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌    | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ❌   | ❌   | ❌   | ❌   |
  | 8.13                  | ❌                      | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌    | ❌    | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ❌   | ❌   | ❌   | ❌   |
  | 8.14                  | ❌                      | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌    | ❌    | ❌    | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ❌   | ❌   | ❌   | ❌   |
  | 8.15                  | ❌                      | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌    | ❌    | ❌    | ❌    | ✅    | ✅    | ✅    | ✅    | ✅    | ✅    | ❌   | ❌   | ❌   | ❌   |
  | 8.16                  | ❌                      | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌    | ❌    | ❌    | ❌    | ❌    | ✅    | ✅    | ✅    | ✅    | ✅    | ❌   | ❌   | ❌   | ❌   |
  | 8.17                  | ❌                      | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌    | ❌    | ❌    | ❌    | ❌    | ❌    | ✅    | ✅    | ✅    | ✅    | ❌   | ❌   | ❌   | ❌   |
  | 8.18                  | ❌                      | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌    | ❌    | ❌    | ❌    | ❌    | ❌    | ❌    | ✅    | ✅    | ✅    | ✅   | ❌   | ❌   | ❌   |
  | 8.19                  | ❌                      | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌    | ❌    | ❌    | ❌    | ❌    | ❌    | ❌    | ❌    | ✅    | ✅    | ✅   | ✅   | ✅   | ✅   |
  | 9.0                   | ❌                      | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌    | ❌    | ❌    | ❌    | ❌    | ❌    | ❌    | ❌    | ✅    | ❌    | ✅   | ✅   | ✅   | ✅   |
  | 9.1                   | ❌                      | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌    | ❌    | ❌    | ❌    | ❌    | ❌    | ❌    | ❌    | ❌    | ❌    | ✅   | ✅   | ✅   | ✅   |
  | 9.2                   | ❌                      | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌    | ❌    | ❌    | ❌    | ❌    | ❌    | ❌    | ❌    | ❌    | ❌    | ❌   | ✅   | ✅   | ✅   |
  | 9.3                   | ❌                      | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌   | ❌    | ❌    | ❌    | ❌    | ❌    | ❌    | ❌    | ❌    | ❌    | ❌    | ❌   | ❌   | ✅   | ✅   |
  </dropdown>
- If your deployment was created before February 2021, the **Remote clusters** page in Kibana must be enabled manually from the **Security** page of your deployment, by selecting **Enable CCR** under **Trust management**.


## Set up remote clusters with Elastic Cloud Hosted

The steps, information, and authentication method required to configure CCS and CCR can vary depending on where the clusters you want to use as remote are hosted.
- Connect remotely to other clusters from your Elastic Cloud Hosted deployments
  - [Access other deployments of the same Elastic Cloud organization](https://www.elastic.co/docs/deploy-manage/remote-clusters/ec-remote-cluster-same-ess)
- [Access deployments of a different Elastic Cloud organization](https://www.elastic.co/docs/deploy-manage/remote-clusters/ec-remote-cluster-other-ess)
- [Access deployments of an Elastic Cloud Enterprise environment](https://www.elastic.co/docs/deploy-manage/remote-clusters/ec-remote-cluster-ece)
- [Access clusters of a self-managed environment](https://www.elastic.co/docs/deploy-manage/remote-clusters/ec-remote-cluster-self-managed)
- [Access deployments of an ECK environment](https://www.elastic.co/docs/deploy-manage/remote-clusters/ec-enable-ccs-for-eck)
- Use clusters from your Elastic Cloud Hosted deployments as remote
  - [From another deployment of your Elastic Cloud organization](https://www.elastic.co/docs/deploy-manage/remote-clusters/ec-remote-cluster-same-ess)
- [From a deployment of another Elastic Cloud organization](https://www.elastic.co/docs/deploy-manage/remote-clusters/ec-remote-cluster-other-ess)
- [From an ECE deployment](https://www.elastic.co/docs/deploy-manage/remote-clusters/ece-remote-cluster-ece-ess)
- [From a self-managed cluster](https://www.elastic.co/docs/deploy-manage/remote-clusters/remote-clusters-self-managed)
- [From an ECK environment](https://www.elastic.co/docs/deploy-manage/remote-clusters/ec-enable-ccs-for-eck)


## Remote clusters and network security

If you have [network security policies](https://www.elastic.co/docs/deploy-manage/security/network-security-policies) applied to the remote cluster, you might need to take extra steps on the remote side to allow traffic from the local cluster. Some remote cluster configurations have limited compatibility with network security. To learn more, refer to [Remote clusters and network security](/docs/deploy-manage/remote-clusters#network-security).