﻿---
title: Remote cluster connection modes
description: When you configure a remote cluster, the local cluster needs a way to connect to the nodes of the remote cluster. Elasticsearch supports two connection...
url: https://www.elastic.co/docs/deploy-manage/remote-clusters/connection-modes
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Unavailable
  - Elastic Stack: Generally available
---

# Remote cluster connection modes
When you configure a remote cluster, the local cluster needs a way to connect to the nodes of the remote cluster. Elasticsearch supports two connection modes to handle different network architectures:
- **Proxy mode**: The local cluster connects through a reverse proxy or load balancer, which forwards traffic to the appropriate nodes in the remote cluster. You can configure this mode using either the Kibana UI or the Elasticsearch API.
- **Sniff mode**: The local cluster discovers the remote cluster’s gateway nodes and connects to them directly. This mode can only be configured using the Elasticsearch API.

<note>
  Connection modes work independently of [security models](https://www.elastic.co/docs/deploy-manage/remote-clusters/security-models). Both connection modes are compatible with either security model.
</note>

The choice between proxy and sniff mode depends on your network architecture and deployment type.
- **Self-managed clusters:** If the local cluster can reach the publish addresses of the remote cluster’s nodes, you can use sniff mode. If direct connectivity is difficult to implement—for example, when clusters are separated by NAT, firewalls, or in containerized environments—you can place a reverse proxy or load balancer in front of the remote cluster and use proxy mode instead.
- **Managed environments (Elastic Cloud Enterprise, Elastic Cloud Hosted, Elastic Cloud on Kubernetes):** Because node publish addresses are not exposed externally in these platforms, they usually rely on the proxy connection mode when used as remote clusters.

The following sections describe each method in more detail.

## Proxy mode

In proxy mode, a cluster alias is registered with a name of your choosing and the address of a TCP (layer 4) reverse proxy specified with the `cluster.remote.<cluster_alias>.proxy_address` setting. You must configure this proxy to route connections to one or more nodes of the remote cluster. The service port to forward traffic to depends on the [security model](https://www.elastic.co/docs/deploy-manage/remote-clusters/security-models) in use, as each model uses a different service port.
When you register a remote cluster using proxy mode, Elasticsearch opens several TCP connections to the proxy address and uses these connections to communicate with the remote cluster. In proxy mode, Elasticsearch disregards the publish addresses of the remote cluster nodes, which means that the publish addresses of the remote cluster nodes do not need to be accessible to the local cluster.
Proxy mode is not the default connection mode when adding remotes using the Elasticsearch API, so you must set `cluster.remote.<cluster_alias>.mode: proxy` to use it. Refer to [Proxy mode remote cluster settings](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/remote-clusters#remote-cluster-proxy-settings) for more information about configuring proxy mode.
<note>
  Remote clusters configured through **Kibana** support only proxy mode. You can’t select a connection mode or configure sniff mode from the UI.
</note>


## Sniff mode

In sniff mode, a cluster alias is registered with a name of your choosing and a list of addresses of *seed* nodes specified with the `cluster.remote.<cluster_alias>.seeds` setting. When you register a remote cluster using sniff mode, Elasticsearch retrieves from one of the seed nodes the addresses of up to three *gateway nodes*. Each `remote_cluster_client` node in the local Elasticsearch cluster then opens several TCP connections to the publish addresses of the gateway nodes. This mode therefore requires that the gateway nodes' publish addresses are accessible to nodes in the local cluster.
Sniff mode is the default connection mode when adding a remote cluster through the Elasticsearch API. Refer to [Sniff mode remote cluster settings](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/remote-clusters#remote-cluster-sniff-settings) for more information about configuring sniff mode.