<!--
This snippet is in use in the following locations:
- self-remote-cluster-eck.md
- eck-remote-clusters-to-other-eck.md
- ece-enable-ccs-for-eck.md
- ec-enable-ccs-for-eck.md
-->
The certificate authority (CA) used by ECK to issue certificates for the remote cluster server interface is stored in the `ca.crt` key of the secret named `<cluster_name>-es-transport-certs-public`.

If the external connections reach the {{es}} Pods on port `9443` without any intermediate TLS termination, you need to retrieve this CA because it is required in the local cluster configuration to establish trust.

If TLS is terminated by any intermediate component and the certificate presented is not the ECK-managed one, use the CA associated with that component, or omit the CA entirely if it uses a publicly trusted certificate.

To save the transport CA certificate of a cluster named `quickstart` into a local file, run the following command:

```sh
kubectl get secret quickstart-es-transport-certs-public \
-o go-template='{{index .data "ca.crt" | base64decode}}' > eck_transport_ca.crt
```

::::{important}
ECK-managed CA certificates are automatically rotated after one year by default, but you can [configure](/deploy-manage/deploy/cloud-on-k8s/configure-eck.md) a different validity period. When the CA certificate is rotated, ensure that this CA is updated in all environments where it's used to preserve trust.
::::

