<!--
This snippet is in use in the following locations:
- self-remote-cluster-eck.md
- eck-remote-clusters-to-other-eck.md
- ece-enable-ccs-for-eck.md
- ec-enable-ccs-for-eck.md
-->
Expose the transport service (defaults to port `9300`) of your ECK cluster to allow external {{es}} clusters to connect:

```yaml
apiVersion: elasticsearch.k8s.elastic.co/v1
kind: Elasticsearch
metadata:
  name: <remote-cluster-name>
spec:
  transport:
    service:
      spec:
        type: LoadBalancer <1>
```

1. On cloud providers which support external load balancers, setting the `type` field to `LoadBalancer` provisions a load balancer for your service. Alternatively, expose the service `<cluster-name>-es-transport` through one of the Kubernetes Ingress controllers that support TCP services.

:::{note}
If you change the service’s `port` to expose a different port externally, set `targetPort` explicitly to `9300`, which is the default transport service listening port. Otherwise, Kubernetes uses the same value for both fields, resulting in failed connections.
:::
