A deployment can be configured to trust all or specific deployments in any environment:

1. From the **Security** page, select **Remote Connections > Add trusted environment** and choose **Self-managed**. Then click **Next**.

2. Select **Certificates** as authentication mechanism and click **Next**.

3. Upload the transport CA certificate of the self-managed environment [you obtained earlier](#download-ca). The CA must be in PEM format and should not contain the private key.

4. Select the clusters to trust. There are two options depending on the subject name of the certificates presented by the nodes in your self-managed cluster:

    * Following the {{ecloud}} pattern. In {{ecloud}}, the certificates of all {{es}} nodes follow this convention: `CN = {{node_id}}.node.{{cluster_id}}.cluster.{{scope_id}}`. If you follow the same convention in your self-managed environment, then choose this option and select the clusters to trust.

    * If your clusters don’t follow the previous convention for the certificates subject name of your nodes, you can still specify the node name of each of the nodes that should be trusted by this deployment.
    
        ::::{tip}
        If possible, [reissue your self-managed node certificates to follow the {{ecloud}} subject name pattern](#self-reissue-certs). This greatly simplifies trust management, because otherwise you must keep the list of trusted node names up to date as your self-managed cluster topology changes.
        ::::

        ::::{important}
        Trust management based on certificate restrictions requires the certificates to include a specific X.509 Subject Alternative Name (SAN) entry of type `otherName`. This attribute is not present by default in certificates generated by an out-of-the-box [{{es}} installation](/deploy-manage/deploy/self-managed/installing-elasticsearch.md).

        If your self-managed cluster certificates do not include `otherName`, you must reissue them. To generate compatible certificates, refer to [Optional: reissue self-managed node certificates](#self-reissue-certs).
        ::::

5. Provide a name for the trusted environment. That name will appear in the trust summary of your deployment’s **Security** page.

6. Select **Create trust** to complete the configuration.

:::{dropdown} Alternative method: using the API
You can update a deployment using the appropriate trust settings for the {{es}} payload.

To trust a cluster whose nodes present certificates with the subject names: "CN = node1.<CLUSTER_FQDN>", "CN = node2.<CLUSTER_FQDN>" and "CN = node3.<CLUSTER_FQDN>" in a self-managed environment, you can update the trust settings with an additional direct trust relationship like this:

```json
{
  "trust":{
    "accounts":[
      {
         "account_id":"ec38dd0aa45f4a69909ca5c81c27138a",
         "trust_all":true
      }
    ],
    "direct": [
      {
        "type" : "generic",
        "name" : "My Self-managed environment",
        "additional_node_names" : ["node1.<CLUSTER_FQDN>", "node2.<CLUSTER_FQDN>", "node3.<CLUSTER_FQDN>",],
        "certificates" : [
            {
                "pem" : "-----BEGIN CERTIFICATE-----\nMIIDTzCCA...H0=\n-----END CERTIFICATE-----"
            }
         ],
         "trust_all":false
       }
    ]
  }
}
```
:::
