﻿---
title: Configure Kibana memory
description: Kibana has a default memory limit that scales based on total memory available. In some scenarios, such as large reporting jobs, detection rules, managing...
url: https://www.elastic.co/docs/deploy-manage/production-guidance/kibana-configure-memory
applies_to:
  - Self-managed Elastic deployments: Generally available
---

# Configure Kibana memory
Kibana has a default memory limit that scales based on total memory available. In some scenarios, such as large reporting jobs, detection rules, managing alerting workflows, or working with SLOs, it may make sense to tweak memory limits to meet more specific performance requirements.

## Limit memory usage

A limit can be defined by setting `--max-old-space-size` in the `node.options` config file found inside the `kibana/config` folder or any other folder configured with the environment variable `KBN_PATH_CONF`. For example, in the Debian-based system, the folder is `/etc/kibana`.
The option accepts a limit in MB:
```js
--max-old-space-size=2048
```

<note>
  In orchestrated environments like Elastic Cloud Hosted, Elastic Cloud Enterprise, or Elastic Cloud on Kubernetes, you should not override Kibana’s default memory limit using `--max-old-space-size`. Instead, set the desired Kibana memory size at the deployment level. This automatically adjusts the container’s memory allocation and ensures more consistent and predictable performance.
</note>