﻿---
title: Resiliency in ECH and ECE deployments
description: With Elastic Cloud Hosted (ECH) and Elastic Cloud Enterprise (ECE), your deployment can be spread across up to three separate availability zones, each...
url: https://www.elastic.co/docs/deploy-manage/production-guidance/availability-and-resilience/resilience-in-ech
applies_to:
  - Elastic Cloud Hosted: Generally available
  - Elastic Cloud Enterprise: Generally available
---

# Resiliency in ECH and ECE deployments
With Elastic Cloud Hosted (ECH) and Elastic Cloud Enterprise (ECE), your deployment can be spread across up to three separate availability zones, each hosted in an isolated infrastructure domain, such as separate data centers in the case of Elastic Cloud Hosted.
<note>
  While this document focuses on how ECH and ECE handle resilience, all the concepts and recommendations described in this section are also applicable to other deployment types. For example, in Elastic Cloud on Kubernetes, you can configure [availability zone distribution and node scheduling](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/advanced-elasticsearch-node-scheduling) through your Kubernetes platform.
</note>

Why this matters:
- Data centers can have issues with availability. Internet outages, earthquakes, floods, or other events could affect the availability of a single data center. With a single availability zone, you have a single point of failure that can bring down your deployment.
- Multiple availability zones help your deployment remain available. This includes your Elasticsearch cluster, provided that your cluster is sized so that it can sustain your workload on the remaining data centers and that your indices are configured to have at least one replica.
- Multiple availability zones enable you to perform changes to resize your deployment with zero downtime.

<important>
  ECH and ECE orchestators automatically handle several aspects of cluster resilience that are discussed in the self-managed resiliency guidance for [small](https://www.elastic.co/docs/deploy-manage/production-guidance/availability-and-resilience/resilience-in-small-clusters) and [large](https://www.elastic.co/docs/deploy-manage/production-guidance/availability-and-resilience/resilience-in-larger-clusters) clusters:
  - Configuring master-eligible nodes:
    - Setting up a [voting-only tiebreaker](/docs/deploy-manage/distributed-architecture/clusters-nodes-shards/node-roles#voting-only-node) when the cluster spans to two availability zones.
  - Promoting [dedicated master nodes](/docs/deploy-manage/distributed-architecture/clusters-nodes-shards/node-roles#dedicated-master-node) as the cluster grows to improve stability and fault tolerance.
  - Enabling [shard allocation awareness](https://www.elastic.co/docs/deploy-manage/distributed-architecture/shard-allocation-relocation-recovery/shard-allocation-awareness) to maintain resilience during whole-zone failures.
  - Automatically assigning [node roles](https://www.elastic.co/docs/deploy-manage/distributed-architecture/clusters-nodes-shards/node-roles) based on the configured [data tiers](https://www.elastic.co/docs/manage-data/lifecycle/data-tiers).
  - Creating [automatic snapshots](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore) at regular configurable intervals, to provide an extra level of redundancy.
</important>


## Recommendations

- For ECH, review [plan for production](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/elastic-cloud-hosted-planning) page for how to plan your deployment for production.
- For ECE, review [high availability in ECE](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/ece-ha) page for how to configure your ECE installation to be highly available.