﻿---
title: Collect monitoring data with Metricbeat
description: You can use Metricbeat to collect data about Kibana and ship it to the monitoring cluster. To learn about monitoring in general, refer to Stack monitoring...
url: https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/kibana-monitoring-metricbeat
products:
  - Kibana
applies_to:
  - Self-managed Elastic deployments: Generally available
---

# Collect monitoring data with Metricbeat
You can use Metricbeat to collect data about Kibana and ship it to the monitoring cluster.
To learn about monitoring in general, refer to [Stack monitoring](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring).
![Example monitoring architecture](https://www.elastic.co/docs/deploy-manage/images/kibana-metricbeat.png)

1. Disable the default collection of Kibana monitoring metrics.
   Add the following setting in the Kibana configuration file ([`kibana.yml`](https://www.elastic.co/docs/deploy-manage/stack-settings)):
   ```yaml
   monitoring.kibana.collection.enabled: false
   ```
   Leave the `monitoring.enabled` set to its default value (`true`). For more information, see [Monitoring settings in Kibana](https://www.elastic.co/docs/reference/kibana/configuration-reference/monitoring-settings).
2. [Start Kibana](https://www.elastic.co/docs/deploy-manage/maintenance/start-stop-services/start-stop-kibana).
3. Set the `xpack.monitoring.collection.enabled` setting to `true` on each node in the production cluster. By default, it is disabled (`false`).
   <note>
   You can specify this setting in either the [`elasticsearch.yml`](https://www.elastic.co/docs/deploy-manage/stack-settings) on each node or across the cluster as a dynamic cluster setting. If Elasticsearch security features are enabled, you must have `monitor` cluster privileges to view the cluster settings and `manage` cluster privileges to change them.
   </note>
   - In Kibana:
  1. Open Kibana in your web browser.
   If you are running Kibana locally, go to `http://localhost:5601/`.
   If the Elastic security features are enabled, log in.
2. In the side navigation, click **Stack Monitoring**. If data collection is disabled, you are prompted to turn it on.
- From the Console or command line, set `xpack.monitoring.collection.enabled` to `true` on the production cluster.
  For example, you can use the following APIs to review and change this setting:
  ```json
  ```
  ```json

  {
    "persistent": {
      "xpack.monitoring.collection.enabled": true
    }
  }
  ```
  For more information, see [Monitoring settings in Elasticsearch](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/monitoring-settings) and [the Cluster update settings API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cluster-put-settings).
4. [Install Metricbeat](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-installation-configuration) on the same server as Kibana.
5. Enable the Kibana X-Pack module in Metricbeat.
   For example, to enable the default configuration in the `modules.d` directory, run the following command:
   ```sh
   metricbeat modules enable kibana-xpack
   ```
   For more information, see [Specify which modules to run](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-metricbeat) and [Kibana module](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-kibana).
6. Configure the Kibana X-Pack module in Metricbeat.
   The `modules.d/kibana-xpack.yml` file contains the following settings:
   ```yaml
   - module: kibana
     metricsets:
       - stats
     period: 10s
     hosts: ["localhost:5601"]
     #basepath: ""
     #username: "user"
     #password: "secret"
     xpack.enabled: true
   ```
   By default, the module collects Kibana monitoring metrics from `localhost:5601`. If that host and port number are not correct, you must update the `hosts` setting. If you configured Kibana to use encrypted communications, you must access it via HTTPS. For example, use a `hosts` setting like `https://localhost:5601`.
   If the Elastic security features are enabled, you must also provide a user ID and password so that Metricbeat can collect metrics successfully:
   1. Create a user on the production cluster that has the `remote_monitoring_collector` [built-in role](https://www.elastic.co/docs/reference/elasticsearch/roles#built-in-roles-remote-monitoring-collector). Alternatively, use the `remote_monitoring_user` [built-in user](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/built-in-users).
2. Add the `username` and `password` settings to the Kibana module configuration file.
7. Optional: Disable the system module in Metricbeat.
   By default, the [system module](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-system) is enabled. The information it collects, however, is not shown on the **Monitoring** page in Kibana. Unless you want to use that information for other purposes, run the following command:
   ```sh
   metricbeat modules disable system
   ```
8. Identify where to send the monitoring data.
   <tip>
   In production environments, we strongly recommend using a separate cluster (referred to as the *monitoring cluster*) to store the data. Using a separate monitoring cluster prevents production cluster outages from impacting your ability to access your monitoring data. It also prevents monitoring activities from impacting the performance of your production cluster.For more information, refer to [Monitoring in a production environment](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/es-self-monitoring-prod).
   </tip>
   For example, specify the Elasticsearch output information in the Metricbeat configuration file (`metricbeat.yml`):
   ```yaml
   output.elasticsearch:
     # Array of hosts to connect to.
     hosts: ["<ES_MONITORING_HOST1_URL>:9200", "http://es-mon2:9200"] 

     # Optional protocol and basic auth credentials.
     #protocol: "https"
     #username: "elastic"
     #password: "changeme"
   ```
   If you configured the monitoring cluster to use encrypted communications, you must access it via HTTPS. For example, use a `hosts` setting like `https://es-mon-1:9200`.
   <important>
   The Elasticsearch monitoring features use ingest pipelines. The cluster that stores the monitoring data must have at least one node with the `ingest` role.
   </important>
   If the Elasticsearch security features are enabled on the monitoring cluster, you must provide a valid user ID and password so that Metricbeat can send metrics successfully:
   1. Create a user on the monitoring cluster that has the `remote_monitoring_agent` [built-in role](https://www.elastic.co/docs/reference/elasticsearch/roles#built-in-roles-remote-monitoring-collector). Alternatively, use the `remote_monitoring_user` [built-in user](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/built-in-users).
2. Add the `username` and `password` settings to the Elasticsearch output information in the Metricbeat configuration file.
   For more information about these configuration options, see [Configure the Elasticsearch output](https://www.elastic.co/docs/reference/beats/metricbeat/elasticsearch-output).
9. [Start Metricbeat](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-starting).
10. [View the monitoring data in Kibana](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/kibana-monitoring-data).