﻿---
title: Legacy collection methods for self-managed Kibana
description: If you enable the Elastic monitoring features in your cluster, you can optionally collect metrics about Kibana. The following method involves sending...
url: https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/kibana-monitoring-legacy
products:
  - Kibana
applies_to:
  - Self-managed Elastic deployments: Deprecated since 7.16
---

# Legacy collection methods for self-managed Kibana
If you enable the Elastic monitoring features in your cluster, you can optionally collect metrics about Kibana.
<important>
  Elastic Agent and Metricbeat are the recommended methods for collecting and shipping monitoring data to a monitoring cluster.If you have previously configured legacy collection methods, you should migrate to using Elastic Agent or Metricbeat collection. Do not use legacy collection alongside other collection methods.For more information, refer to [Collect monitoring data with Elastic Agent](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/kibana-monitoring-elastic-agent) and [Collect monitoring data with Metricbeat](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/kibana-monitoring-metricbeat).
</important>

The following method involves sending the metrics to the production cluster, which ultimately routes them to the monitoring cluster.
To learn about monitoring in general, refer to [Stack monitoring](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring).
1. Set the `xpack.monitoring.collection.enabled` setting to `true` on each node in the production cluster. By default, it is is disabled (`false`).
   <note>
   You can specify this setting in either the [`elasticsearch.yml`](https://www.elastic.co/docs/deploy-manage/stack-settings) on each node or across the cluster as a dynamic cluster setting. If Elastic Stack security features are enabled, you must have `monitor` cluster privileges to view the cluster settings and `manage` cluster privileges to change them.
   </note>
   - To update the cluster settings in Kibana:
  1. Open Kibana in your web browser.
   By default, if you are running Kibana locally, go to `http://localhost:5601/`.
   If security features are enabled, log in.
2. Go to the **Stack Monitoring** page using the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects). If data collection is disabled, you are prompted to turn it on.
- From the Console or command line, set `xpack.monitoring.collection.enabled` to `true` on the production cluster.
  For example, you can use the following APIs to review and change this setting:
  ```js
  GET _cluster/settings

  PUT _cluster/settings
  {
    "persistent": {
      "xpack.monitoring.collection.enabled": true
    }
  }
  ```
  For more information, see [Monitoring settings in Elasticsearch](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/monitoring-settings) and [Cluster update settings](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cluster-put-settings).
2. Verify that `monitoring.enabled` and `monitoring.kibana.collection.enabled` are set to `true` in the [`kibana.yml`](https://www.elastic.co/docs/deploy-manage/stack-settings) file. These are the default values. For more information, see [Monitoring settings in Kibana](https://www.elastic.co/docs/reference/kibana/configuration-reference/monitoring-settings).
3. Identify where to send monitoring data. Kibana automatically sends metrics to the Elasticsearch cluster specified in the `elasticsearch.hosts` setting in the [`kibana.yml`](https://www.elastic.co/docs/deploy-manage/stack-settings) file. This property has a default value of `http://localhost:9200`.
   <tip>
   In production environments, we strongly recommend using a separate cluster (referred to as the *monitoring cluster*) to store the data. Using a separate monitoring cluster prevents production cluster outages from impacting your ability to access your monitoring data. It also prevents monitoring activities from impacting the performance of your production cluster.If security features are enabled on the production cluster, use an HTTPS URL such as `https://<your_production_cluster>:9200` in this setting.
   </tip>
4. If security features are enabled on the production cluster:
   1. Verify that there is a valid user ID and password in the `elasticsearch.username` and `elasticsearch.password` settings in the [`kibana.yml`](https://www.elastic.co/docs/deploy-manage/stack-settings) file. These values are used when Kibana sends monitoring data to the production cluster.
2. [Configure encryption for traffic between Kibana and Elasticsearch](/docs/deploy-manage/security/set-up-basic-security-plus-https#encrypt-kibana-http).
5. [Start Kibana](https://www.elastic.co/docs/deploy-manage/maintenance/start-stop-services/start-stop-kibana).
6. [View the monitoring data in Kibana](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/kibana-monitoring-data).