﻿---
title: Collect monitoring data with Elastic Agent
description: You can use Elastic Agent to collect data about Kibana and ship it to the monitoring cluster. To learn about monitoring in general, refer to Stack monitoring...
url: https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/kibana-monitoring-elastic-agent
products:
  - Kibana
applies_to:
  - Self-managed Elastic deployments: Generally available
---

# Collect monitoring data with Elastic Agent
You can use Elastic Agent to collect data about Kibana and ship it to the monitoring cluster.
To learn about monitoring in general, refer to [Stack monitoring](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring).

## Prerequisites

- [Set up Elasticsearch monitoring](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/elasticsearch-monitoring-self-managed) and optionally [create a monitoring cluster](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/es-self-monitoring-prod).
- Create a user on the production cluster that has the `remote_monitoring_collector` [built-in role](https://www.elastic.co/docs/reference/elasticsearch/roles#built-in-roles-remote-monitoring-collector).


## Add Kibana monitoring data

To collect Kibana monitoring data, add a Kibana integration to an Elastic Agent and deploy it to the host where Kibana is running.
1. Go to the **Integrations** page.
   <note>
   If you’re using a monitoring cluster, use the Kibana instance connected to the monitoring cluster.
   </note>
2. In the query bar, search for and select the **Kibana** integration for Elastic Agent.
3. Read the overview to make sure you understand integration requirements and other considerations.
4. Click **Add Kibana**.
   <tip>
   If you’re installing an integration for the first time, you may be prompted to install Elastic Agent. Click **Add integration only (skip agent installation)**.
   </tip>
5. Configure the integration name and optionally add a description. Make sure you configure all required settings:
   - Under **Logs**, modify the log paths to match your Kibana environment.
- Under **Metrics (Stack Monitoring)**, make sure the hosts setting points to your Kibana host URLs. By default, the integration collects Kibana monitoring metrics from `localhost:5601`. If that host and port number are not correct, update the `hosts` setting. If you configured Kibana to use encrypted communications, you must access it via HTTPS. For example, use a `hosts` setting like `https://localhost:5601`.
- If the Elastic security features are enabled, expand **Advanced options** under the Hosts setting and enter the username and password of a user that has the `remote_monitoring_collector` role.
6. Choose where to add the integration policy. Click **New hosts** to add it to new agent policy or **Existing hosts** to add it to an existing agent policy.
7. Click **Save and continue**. This step takes a minute or two to complete. When it’s done, you’ll have an agent policy that contains an integration for collecting monitoring data from Kibana.
8. If an Elastic Agent is already assigned to the policy and deployed to the host where Kibana is running, you’re done. Otherwise, you need to deploy an Elastic Agent. To deploy an Elastic Agent:
   1. Go to **Fleet > Agents**, then click **Add agent**.
2. Follow the steps in the **Add agent** flyout to download, install, and enroll the Elastic Agent. Make sure you choose the agent policy you created earlier.
9. Wait a minute or two until incoming data is confirmed.
10. [View the monitoring data in Kibana](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/kibana-monitoring-data).