﻿---
title: Access monitoring data in Kibana
description: After you collect monitoring data for one or more products in the Elastic Stack, you can configure Kibana to retrieve that information and display it...
url: https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/kibana-monitoring-data
products:
  - Kibana
applies_to:
  - Elastic Cloud Hosted: Generally available
  - Elastic Cloud on Kubernetes: Generally available
  - Elastic Cloud Enterprise: Generally available
  - Self-managed Elastic deployments: Generally available
---

# Access monitoring data in Kibana
After you collect monitoring data for one or more products in the Elastic Stack, you can configure Kibana to retrieve that information and display it in on the **Stack Monitoring** page.
At a minimum, you must have monitoring data for the Elasticsearch production cluster. Once that data exists, Kibana can display monitoring data for other products in the cluster.
In Elastic Cloud Enterprise and Elastic Cloud Hosted, this configuration is performed automatically. Skip to [View monitoring data in Kibana](#view-monitoring-data-in-kibana).
<tip>
  If you use a separate monitoring cluster to store the monitoring data, it is strongly recommended that you use a separate Kibana instance to view it. If you log in to Kibana using SAML, Kerberos, PKI, OpenID Connect, or token authentication providers, a dedicated Kibana instance is **required**. The security tokens that are used in these contexts are cluster-specific, therefore you cannot use a single Kibana instance to connect to both production and monitoring clusters. For more information about the recommended configuration, see [Monitoring overview](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring).
</tip>


## Configure Kibana to consume monitoring data

<applies-to>
  - Elastic Cloud on Kubernetes: Generally available
  - Self-managed Elastic deployments: Generally available
</applies-to>

1. Identify where to retrieve monitoring data from.
   If the monitoring data is stored on a dedicated monitoring cluster, it is accessible even when the cluster you’re monitoring is not. If you have at least a gold license, you can send data from multiple clusters to the same monitoring cluster and view them all through the same instance of Kibana.
   By default, data is retrieved from the cluster specified in the `elasticsearch.hosts` value in the [`kibana.yml`](https://www.elastic.co/docs/deploy-manage/stack-settings) file. If you want to retrieve it from a different cluster, set `monitoring.ui.elasticsearch.hosts`.
   To learn more about typical monitoring architectures, see [How monitoring works](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring) and [Monitoring in a production environment](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/elasticsearch-monitoring-self-managed).
2. Verify that `monitoring.ui.enabled` is set to `true`, which is the default value, in the [`kibana.yml`](https://www.elastic.co/docs/deploy-manage/stack-settings) file. For more information, see [Monitoring settings](https://www.elastic.co/docs/reference/kibana/configuration-reference/monitoring-settings).
3. If the Elastic security features are enabled on the monitoring cluster, you must provide a user ID and password so Kibana can retrieve the data.
   1. Create a user that has the `monitoring_user` [built-in role](https://www.elastic.co/docs/reference/elasticsearch/roles#built-in-roles-monitoring-user) on the monitoring cluster.
   <note>
   Make sure the `monitoring_user` role has read privileges on `metrics-*` indices. If it doesn’t, create a new role with `read` and `read_cross_cluster` index privileges on `metrics-*`, then assign the new role (along with `monitoring_user`) to your user.
   </note>
2. Add the `monitoring.ui.elasticsearch.username` and `monitoring.ui.elasticsearch.password` settings in the [`kibana.yml`](https://www.elastic.co/docs/deploy-manage/stack-settings) file. If these settings are omitted, Kibana uses the `elasticsearch.username` and `elasticsearch.password` setting values. For more information, see [Configuring security in Kibana](https://www.elastic.co/docs/deploy-manage/security).
4. (Optional) If you're using a self-managed cluster, then optionally configure Kibana to encrypt communications between the Kibana server and the monitoring cluster. See [Encrypt TLS communications in Kibana](/docs/deploy-manage/security/set-up-basic-security-plus-https#encrypt-kibana-http).
5. If the Elastic security features are enabled on the Kibana server, only users that have the authority to access Kibana indices and to read the monitoring indices can use the monitoring dashboards.
   Create users that have the `monitoring_user` and `kibana_admin` [built-in roles](https://www.elastic.co/docs/reference/elasticsearch/roles). If you created a new role with read privileges on `metrics-*` indices, also assign that role to the users.
   <note>
   These users must exist on the monitoring cluster. If you are accessing a remote monitoring cluster, you must use credentials that are valid on both the Kibana server and the monitoring cluster.
   </note>


## View monitoring data in Kibana

<applies-switch>
  <applies-item title="{ eck:, self: }" applies-to="Elastic Cloud on Kubernetes: Generally available, Self-managed Elastic deployments: Generally available">
    1. Open the Kibana monitoring instance in your web browser.
       By default, if you are running Kibana locally, go to `http://localhost:5601/`.
       If the Elastic security features are enabled, log in.
    2. Go to the **Stack Monitoring** page using the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
       If data collection is disabled, you are prompted to turn on data collection. If Elasticsearch security features are enabled, you must have `manage` cluster privileges to turn on data collection.

    <note>
      If you are using a separate monitoring cluster, you do not need to turn on data collection. The dashboards appear when there is data in the monitoring cluster.
    </note>
  </applies-item>

  <applies-item title="{ ess:, ece: }" applies-to="Elastic Cloud Hosted: Generally available, Elastic Cloud Enterprise: Generally available">
    1. Log in to the [Elastic Cloud Console](https://cloud.elastic.co?page=docs&placement=docs-body) or ECE [Cloud UI](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/log-into-cloud-ui).
    2. On the home page, find your deployment.
       <tip>
       If you have many deployments, you can instead go to the **Hosted deployments** (Elastic Cloud Hosted) or **Deployments** (Elastic Cloud Enterprise) page. On that page, you can narrow your deployments by name, ID, or choose from several other filters.
       </tip>
    3. Select **Manage**.

    1. Under the deployment's name in the navigation menu, select **Logs and metrics**.
    2. Select the corresponding **View** button to check the logs or metrics data.

    Alternatively, you can access logs and metrics directly on the Kibana **Logs** and **Stack Monitoring** pages in the target monitoring deployment.
  </applies-item>
</applies-switch>

On the **Stack Monitoring** page, you’ll see cluster alerts that require your attention and a summary of the available monitoring metrics for Elasticsearch, Logstash, Kibana, and Beats. To view additional information, click the **Overview**, **Nodes**, **Indices**, or **Instances** links.  For more information about these metrics, refer to [Visualizing monitoring data](https://www.elastic.co/docs/deploy-manage/monitor/monitoring-data/visualizing-monitoring-data). For information about configuring alerts for these metrics, refer to [Stack monitoring alerts](https://www.elastic.co/docs/deploy-manage/monitor/monitoring-data/configure-stack-monitoring-alerts).
![Monitoring dashboard](https://www.elastic.co/docs/deploy-manage/images/kibana-monitoring-dashboard.png)

The Integrations Server monitoring component is available only on Elastic Cloud Hosted and Elastic Cloud Enterprise.
If you encounter problems, refer to [Troubleshooting visualizing monitoring data in Kibana](https://www.elastic.co/docs/deploy-manage/monitor/monitoring-data/monitor-troubleshooting).
<tip>
  If you're using Elastic Cloud Hosted or Elastic Cloud Enterprise, then you can also get a direct link to the relevant **Stack Monitoring** page from the deployment's **Logs and metrics** page. [Learn more](/docs/deploy-manage/monitor/stack-monitoring/ece-ech-stack-monitoring#access-kibana-monitoring).
</tip>