﻿---
title: Pausing data collection
description: To stop generating monitoring data in Elasticsearch, disable data collection: When this setting is false, Elasticsearch monitoring data is not collected...
url: https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/es-pause-export
products:
  - Elasticsearch
applies_to:
  - Self-managed Elastic deployments: Deprecated since 7.16
---

# Pausing data collection
<important>
  Elastic Agent and Metricbeat are the recommended methods for collecting and shipping monitoring data to a monitoring cluster.If you have previously configured legacy collection methods, you should migrate to using [Elastic Agent](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/collecting-monitoring-data-with-elastic-agent) or [Metricbeat](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/collecting-monitoring-data-with-metricbeat) collection. Do not use legacy collection alongside other collection methods.
</important>

To stop generating monitoring data in Elasticsearch, disable data collection:
```yaml
xpack.monitoring.collection.enabled: false
```

When this setting is `false`, Elasticsearch monitoring data is not collected and all monitoring data from other sources such as Kibana, Beats, and Logstash is ignored.
You can update this setting by using the [Cluster Update Settings API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cluster-put-settings).
If you want to collect data from sources such as Kibana, Beats, and Logstash but not collect data about your Elasticsearch cluster, you can disable data collection just for Elasticsearch:
```yaml
xpack.monitoring.collection.enabled: true
xpack.monitoring.elasticsearch.collection.enabled: false
```

If you want to separately disable a specific exporter, you can specify the `enabled` setting (which defaults to `true`) per exporter. For example:
```yaml
xpack.monitoring.exporters.my_http_exporter:
  type: http
  host: ["10.1.2.3:9200", "10.1.2.4:9200"]
  enabled: false 
```

<note>
  Defining a disabled exporter prevents the default exporter from being created.
</note>

To re-start data collection, re-enable these settings.