﻿---
title: HTTP exporters
description: The http exporter is the preferred exporter in the Elasticsearch monitoring features because it enables the use of a separate monitoring cluster. As a...
url: https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/es-http-exporter
products:
  - Elasticsearch
applies_to:
  - Self-managed Elastic deployments: Deprecated since 7.16
---

# HTTP exporters
<important>
  Elastic Agent and Metricbeat are the recommended methods for collecting and shipping monitoring data to a monitoring cluster.If you have previously configured legacy collection methods, you should migrate to using [Elastic Agent](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/collecting-monitoring-data-with-elastic-agent) or [Metricbeat](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/collecting-monitoring-data-with-metricbeat) collection. Do not use legacy collection alongside other collection methods.
</important>

The `http` exporter is the preferred exporter in the Elasticsearch monitoring features because it enables the use of a separate monitoring cluster. As a secondary benefit, it avoids using a production cluster node as a coordinating node for indexing monitoring data because all requests are HTTP requests to the monitoring cluster.
The `http` exporter uses the low-level Elasticsearch REST Client, which enables it to send its data to any Elasticsearch cluster it can access through the network. Its requests make use of the [`filter_path`](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/common-options#common-options-response-filtering) parameter to reduce bandwidth whenever possible, which helps to ensure that communications between the production and monitoring clusters are as lightweight as possible.
The `http` exporter supports a number of settings that control how it communicates over HTTP to remote clusters. In most cases, it is not necessary to explicitly configure these settings. For detailed descriptions, see [Monitoring settings](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/monitoring-settings).
```yaml
xpack.monitoring.exporters:
  my_local: 
    type: local
  my_remote: 
    type: http
    host: [ "10.1.2.3:9200", ... ] 
    auth: 
      username: my_username
      # "xpack.monitoring.exporters.my_remote.auth.secure_password" must be set in the keystore
    connection:
      timeout: 6s
      read_timeout: 60s
    ssl: ... 
    proxy:
      base_path: /some/base/path 
    headers: 
      My-Proxy-Header: abc123
      My-Other-Thing: [ def456, ... ]
    index.name.time_format: YYYY-MM 
```

<note>
  The `http` exporter accepts an array of `hosts` and it will round robin through the list. It is a good idea to take advantage of that feature when the monitoring cluster contains more than one node.
</note>

Unlike the `local` exporter, *every* node that uses the `http` exporter attempts to check and create the resources that it needs. The `http` exporter avoids re-checking the resources unless something triggers it to perform the checks again. These triggers include:
- The production cluster’s node restarts.
- A connection failure to the monitoring cluster.
- The license on the production cluster changes.
- The `http` exporter is dynamically updated (and it is therefore replaced).

The easiest way to trigger a check is to disable, then re-enable the exporter.
<warning>
  This resource management behavior can create a hole for users that delete monitoring resources. Since the `http` exporter does not re-check its resources unless one of the triggers occurs, this can result in malformed index mappings.
</warning>

Unlike the `local` exporter, the `http` exporter is inherently routing requests outside of the cluster. This situation means that the exporter must provide a username and password when the monitoring cluster requires one (or other appropriate security configurations, such as TLS/SSL settings).
<important>
  When discussing security relative to the `http` exporter, it is critical to remember that all users are managed on the monitoring cluster. This is particularly important to remember when you move from development environments to production environments, where you often have dedicated monitoring clusters.
</important>

For more information about the configuration options for the `http` exporter, see [HTTP exporter settings](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/monitoring-settings#http-exporter-settings).