﻿---
title: Enable stack monitoring for Elasticsearch on a self-managed cluster
description: The Elastic Stack monitoring features consist of two components: an agent that you install on each Elasticsearch and Logstash node, and a Monitoring UI...
url: https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/elasticsearch-monitoring-self-managed
products:
  - Elasticsearch
applies_to:
  - Self-managed Elastic deployments: Generally available
---

# Enable stack monitoring for Elasticsearch on a self-managed cluster
The Elastic Stack monitoring features consist of two components: an agent that you install on each Elasticsearch and Logstash node, and a Monitoring UI in Kibana. The monitoring agent collects and indexes metrics from the nodes and you visualize the data through the Monitoring dashboards in Kibana. The agent can index data on the same Elasticsearch cluster, or send it to an external monitoring cluster.

## Requirements

To use the monitoring features with the security features enabled, you need to [set up Kibana to work with the security features](https://www.elastic.co/docs/deploy-manage/security) and create at least one user for the Monitoring UI. If you are using an external monitoring cluster, you also need to configure a user for the monitoring agent and configure the agent to use the appropriate credentials when communicating with the monitoring cluster.

## Collection methods

You can collect monitoring and logging data in the following ways:
- [Collect monitoring data with Elastic Agent](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/collecting-monitoring-data-with-elastic-agent) (recommended)
- [Collect monitoring data with Metricbeat](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/collecting-monitoring-data-with-metricbeat)
- [Collect log data with Filebeat](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/collecting-log-data-with-filebeat)

If you're building a production environment, then you should send monitoring data to a separate monitoring cluster so that historical data is available even when the nodes you are monitoring are not. To learn how to store monitoring data in a separate cluster, refer to [Monitoring in a production environment](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/es-self-monitoring-prod).

### Legacy collection methods

You can also monitor your stack using legacy Elasticsearch monitoring features. This method is deprecated and should not be used. To learn more, refer to [Legacy collection methods for self-managed Elasticsearch](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/es-legacy-collection-methods).
<important>
  Elastic Agent and Metricbeat are the recommended methods for collecting and shipping monitoring data to a monitoring cluster.If you have previously configured legacy collection methods, you should migrate to using [Elastic Agent](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/collecting-monitoring-data-with-elastic-agent) or [Metricbeat](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/collecting-monitoring-data-with-metricbeat) collection. Do not use legacy collection alongside other collection methods.
</important>