﻿---
title: Enable stack monitoring on ECK deployments
description: You can enable Stack Monitoring on Elasticsearch, Kibana, Beats and Logstash to collect and ship their metrics and logs to a monitoring cluster. Although...
url: https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/eck-stack-monitoring
products:
  - Elastic Cloud on Kubernetes
applies_to:
  - Elastic Cloud on Kubernetes: Generally available
---

# Enable stack monitoring on ECK deployments
You can enable [Stack Monitoring](https://www.elastic.co/docs/deploy-manage/monitor) on Elasticsearch, Kibana, Beats and Logstash to collect and ship their metrics and logs to a monitoring cluster. Although self-monitoring is possible, it is advised to use a [separate monitoring cluster](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring).

## How stack monitoring works in ECK

In the background, Metricbeat and Filebeat are deployed as sidecar containers in the same Pod as Elasticsearch and Kibana.
Metricbeat is used to collect monitoring metrics, and Filebeat to monitor the Elasticsearch log files and collect log events.
The two Beats are configured to ship data directly to the monitoring cluster(s) using HTTPS and dedicated Elastic users managed by ECK.

## When to use it

This feature is a good solution if you need to monitor your Elastic applications in restricted Kubernetes environments where you cannot grant the following advanced permissions:
- To Metricbeat, to allow querying the k8s API
- To Filebeat, to deploy a privileged DaemonSet

However, for maximum efficiency and minimizing resource consumption, or advanced use cases that require specific Beats configurations, you can deploy a standalone Metricbeat deployment and a Filebeat DaemonSet. Refer to [Beats configuration examples](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/configuration-examples-beats) for more information.

## Enable stack monitoring

To enable stack monitoring, reference the monitoring Elasticsearch cluster in the `spec.monitoring` section of their specification.
The monitoring cluster must be managed by ECK in the same Kubernetes cluster as the monitored one. To learn how to connect an external monitoring cluster, refer to [Connect to an external monitoring Elasticsearch cluster](#k8s_connect_to_an_external_monitoring_elasticsearch_cluster).
The following example shows how Elastic Stack components can be configured to send their monitoring data to a separate Elasticsearch cluster in the same Kubernetes cluster.
You can also do the following:
- Configure an Elasticsearch cluster to monitor itself. This is not recommended for production deployments.
- Send metrics and logs to two different Elasticsearch monitoring clusters.
- Enable stack monitoring on a single Elastic Stack component only. If Elasticsearch is not monitored, other Elastic Stack components will not be available on the [Stack Monitoring](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/kibana-monitoring-data) Kibana page.

```yaml
apiVersion: elasticsearch.k8s.elastic.co/v1
kind: Elasticsearch
metadata:
  name: monitored-sample
  namespace: production
spec:
  version: 8.16.1
  monitoring:
    metrics:
      elasticsearchRefs:
      - name: monitoring 
        namespace: observability 
    logs:
      elasticsearchRefs:
      - name: monitoring 
        namespace: observability 
  nodeSets:
  - name: default
    count: 1
    config:
      node.store.allow_mmap: false

apiVersion: beat.k8s.elastic.co/v1beta1
kind: Beat
metadata:
  name: monitored-sample
spec:
  type: filebeat
  version: 8.16.1
  monitoring:
    metrics:
      elasticsearchRefs:
      - name: monitoring
        namespace: observability 
    logs:
      elasticsearchRefs:
      - name: monitoring
        namespace: observability 
---
apiVersion: logstash.k8s.elastic.co/v1alpha1
kind: Logstash
metadata:
    name: monitored-sample
spec:
  version: 8.16.1
  monitoring:
    metrics:
      elasticsearchRefs:
      - name: monitoring
        namespace: observability 
    logs:
      elasticsearchRefs:
      - name: monitoring
        namespace: observability 
```

<note>
  If stack monitoring is configured for a Beat, but the corresponding Elasticsearch cluster is not monitored, the Kibana stack monitoring page will not show the Beats data.
</note>

<note>
  If Logs stack monitoring is configured for a Beat, and custom container arguments (`podTemplate.spec.containers[].args`) include `-e`, which enables logging to stderr and disables log file output, this argument will be removed from the Pod to allow the Filebeat sidecar to consume the Beat’s log files.
</note>


## Connect to an external monitoring Elasticsearch cluster

If you want to connect to a monitoring Elasticsearch cluster not managed by ECK, you can reference a Secret instead of an Elasticsearch cluster in the `monitoring` section through the `secretName` attribute.
The next example sends cluster metrics to a remote monitoring cluster not managed by ECK, whereas cluster logs are sent to a remote cluster handled by ECK:
```yaml
apiVersion: elasticsearch.k8s.elastic.co/v1
kind: Elasticsearch
metadata:
  name: monitored-sample
  namespace: production
spec:
  version: 8.16.1
  monitoring:
    metrics:
      elasticsearchRefs:
      - secretName: monitoring-metrics-es-ref 
    logs:
      elasticsearchRefs:
      - name: monitoring-logs
        namespace: observability 
        serviceName: monitoring-logs-es-coordinating-nodes 
  nodeSets:
  - name: default
    count: 1
    config:
      node.store.allow_mmap: false
```

The referenced Secret must contain the following connection information:
- `url`: The URL to reach the Elasticsearch cluster
- `username`: The username of the user to be authenticated to the Elasticsearch cluster
- `password`: The password of the user to be authenticated to the Elasticsearch cluster
- `ca.crt`: The contents of the CA certificate in PEM format to secure communication to the Elasticsearch cluster (optional)

```yaml
apiVersion: v1
kind: Secret
metadata:
  name: monitoring-metrics-es-ref
stringData:
  url: <ELASTIC_CLOUD_URL>:9243
  username: monitoring-user
  password: <password>
```

The user referenced in the Secret must have been created beforehand.

## Override the Beats Pod template

You can customize the Filebeat and Metricbeat containers through the Pod template. Your configuration is merged with the values of the default Pod template that ECK uses.
```yaml
apiVersion: elasticsearch.k8s.elastic.co/v1
kind: Elasticsearch
spec:
  monitoring:
    metrics:
      elasticsearchRef:
        name: monitoring
        namespace: observability
    logs:
      elasticsearchRef:
        name: monitoring
        namespace: observability
  nodeSets:
  - name: default
    podTemplate:
      spec:
        containers:
        - name: metricbeat
          env:
          - foo: bar
        - name: filebeat
          env:
          - foo: bar
```