﻿---
title: Collecting monitoring data with Metricbeat
description: You can use Metricbeat to collect data about Elasticsearch and ship it to the monitoring cluster. Install Metricbeat.Ideally, install a single Metricbeat...
url: https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/collecting-monitoring-data-with-metricbeat
products:
  - Elasticsearch
applies_to:
  - Self-managed Elastic deployments: Generally available
---

# Collecting monitoring data with Metricbeat
You can use Metricbeat to collect data about Elasticsearch and ship it to the monitoring cluster.
<tip>
  Want to use Elastic Agent instead? Refer to [Collecting monitoring data with Elastic Agent](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/collecting-monitoring-data-with-elastic-agent).
</tip>

![Example monitoring architecture](https://www.elastic.co/docs/deploy-manage/images/elasticsearch-reference-metricbeat.png)

1. [Install Metricbeat](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-installation-configuration).
   Ideally, install a single Metricbeat instance configured with `scope: cluster` and configure `hosts` to point to an endpoint, such as a load-balancing proxy, which directs requests to the master-ineligible nodes in the cluster.
   If this is not possible, then install one Metricbeat instance for each Elasticsearch node in the production cluster and use the default `scope: node`. When Metricbeat is monitoring Elasticsearch with `scope: node` then you must install a Metricbeat instance for each Elasticsearch node. If you don’t, some metrics will not be collected.
   Metricbeat with `scope: node` collects most of the metrics from the elected master of the cluster, so you must scale up all your master-eligible nodes to account for this extra load. You should not use this mode if you have dedicated master nodes.
2. Enable the Elasticsearch module in Metricbeat on each Elasticsearch node.
   For example, to enable the default configuration for the Elastic Stack monitoring features in the `modules.d` directory, run the following command:
   ```sh
   metricbeat modules enable elasticsearch-xpack
   ```
   For more information, refer to [Elasticsearch module](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-elasticsearch).
3. Configure the Elasticsearch module in Metricbeat on each Elasticsearch node.
   The `modules.d/elasticsearch-xpack.yml` file contains the following settings:
   ```yaml
     - module: elasticsearch
       xpack.enabled: true
       period: 10s
       hosts: ["http://localhost:9200"] 
       #scope: node 
       #username: "user"
       #password: "secret"
       #ssl.enabled: true
       #ssl.certificate_authorities: ["/etc/pki/root/ca.pem"]
       #ssl.certificate: "/etc/pki/client/cert.pem"
       #ssl.key: "/etc/pki/client/cert.key"
       #ssl.verification_mode: "full"
   ```
   If Elastic security features are enabled, you must also provide a user ID and password so that Metricbeat can collect metrics successfully:
   1. Create a user on the production cluster that has the [`remote_monitoring_collector` built-in role](https://www.elastic.co/docs/reference/elasticsearch/roles). Alternatively, use the [`remote_monitoring_user` built-in user](https://www.elastic.co/docs/reference/elasticsearch/roles).
2. Add the `username` and `password` settings to the Elasticsearch module configuration file.
3. If TLS is enabled on the HTTP layer of your Elasticsearch cluster, you must either use https as the URL scheme in the `hosts` setting or add the `ssl.enabled: true` setting. Depending on the TLS configuration of your Elasticsearch cluster, you might also need to specify [additional ssl.*](https://www.elastic.co/docs/reference/beats/metricbeat/configuration-ssl) settings.
4. Optional: Disable the system module in Metricbeat.
   By default, the [system module](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-system) is enabled. The information it collects, however, is not shown on the **Monitoring** page in Kibana. Unless you want to use that information for other purposes, run the following command:
   ```sh
   metricbeat modules disable system
   ```
5. Identify where to send the monitoring data.
   <tip>
   In production environments, we strongly recommend using a separate cluster (referred to as the *monitoring cluster*) to store the data. Using a separate monitoring cluster prevents production cluster outages from impacting your ability to access your monitoring data. It also prevents monitoring activities from impacting the performance of your production cluster.For more information, refer to [Monitoring in a production environment](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/es-self-monitoring-prod).
   </tip>
   For example, specify the Elasticsearch output information in the Metricbeat configuration file (`metricbeat.yml`):
   ```yaml
   output.elasticsearch:
     # Array of hosts to connect to.
     hosts: ["<ES_MONITORING_HOST1_URL>:9200", "<ES_MONITORING_HOST2_URL>:9200"] 

     # Optional protocol and basic auth credentials.
     #protocol: "https"
     #username: "elastic"
     #password: "changeme"
   ```
   If you configured the monitoring cluster to use encrypted communications, you must access it via HTTPS. For example, use a `hosts` setting like `https://es-mon-1:9200`.
   <important>
   The Elasticsearch monitoring features use ingest pipelines, therefore the cluster that stores the monitoring data must have at least one [ingest node](https://www.elastic.co/docs/manage-data/ingest/transform-enrich/ingest-pipelines).
   </important>
   If Elasticsearch security features are enabled on the monitoring cluster, you must provide a valid user ID and password so that Metricbeat can send metrics successfully:
   1. Create a user on the monitoring cluster that has the [`remote_monitoring_agent` built-in role](https://www.elastic.co/docs/reference/elasticsearch/roles). Alternatively, use the [`remote_monitoring_user` built-in user](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/built-in-users).
2. Add the `username` and `password` settings to the Elasticsearch output information in the Metricbeat configuration file.
   For more information about these configuration options, see [Configure the Elasticsearch output](https://www.elastic.co/docs/reference/beats/metricbeat/elasticsearch-output).
6. [Start Metricbeat](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-starting) on each node.
7. [View the monitoring data in Kibana](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/kibana-monitoring-data).