﻿---
title: Stack monitoring
description: Each monitored Elastic Stack component is considered unique in the cluster based on its persistent UUID, which is written to the path.data directory when...
url: https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Hosted: Generally available
  - Elastic Cloud on Kubernetes: Generally available
  - Elastic Cloud Enterprise: Generally available
  - Self-managed Elastic deployments: Generally available
---

# Stack monitoring
Stack monitoring allows you to collect logs and metrics from various Elastic products, including Elasticsearch nodes, Logstash nodes, Kibana instances, APM Server, and Beats in your cluster. You can also collect logs.
All of the monitoring metrics are stored in Elasticsearch, which enables you to easily visualize the data in Kibana.
<admonition title="Simplify monitoring with AutoOps">
  Use [AutoOps](https://www.elastic.co/docs/deploy-manage/monitor/autoops) in your Elastic Cloud Hosted deployments, Serverless projects, and ECE, ECK, or self-managed clusters.AutoOps is a monitoring tool that simplifies cluster management through performance recommendations, resource utilization visibility, and real-time issue detection with resolution paths.To help you make your decision, refer to [AutoOps and Stack Monitoring comparison](https://www.elastic.co/docs/deploy-manage/monitor/autoops-vs-stack-monitoring).
</admonition>


## How it works

Each monitored Elastic Stack component is considered unique in the cluster based on its persistent UUID, which is written to the [`path.data`](/docs/deploy-manage/deploy/self-managed/important-settings-configuration#path-settings) directory when the node or instance starts.
Monitoring documents are just ordinary JSON documents built by monitoring each Elastic Stack component at a specified collection interval. If you want to alter how these documents are structured or stored, refer to [Configuring data streams/indices for monitoring](https://www.elastic.co/docs/deploy-manage/monitor/monitoring-data/configuring-data-streamsindices-for-monitoring).
You can use Elastic Agent or Metricbeat to collect monitoring data and to ship it directly to the monitoring cluster.
In Elastic Cloud Hosted, Elastic Cloud Enterprise, and Elastic Cloud on Kubernetes, Elastic manages the installation and configuration of the monitoring agent for you.

## Production architecture

You can collect and ship data directly to your monitoring cluster rather than routing it through your production cluster.
The following diagram illustrates a typical monitoring architecture with separate production and monitoring clusters. This example shows Metricbeat, but you can use Elastic Agent instead.
![A typical monitoring environment](https://www.elastic.co/docs/deploy-manage/images/elasticsearch-reference-architecture.png)

If you have the appropriate license, you can route data from multiple production clusters to a single monitoring cluster. [Learn about the differences between various subscription levels](https://www.elastic.co/subscriptions).
<important>
  In general, the monitoring cluster and the clusters being monitored should be running the same version of the stack. A monitoring cluster cannot monitor production clusters running newer versions of the stack. If necessary, the monitoring cluster can monitor production clusters running the latest release of the previous major version.
</important>


## Configure and use stack monitoring

Refer to the following topics to learn how to configure stack monitoring:

### Configure for ECH, ECE, and ECK deployments

- [Enable stack monitoring on ECH and ECE deployments](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/ece-ech-stack-monitoring)
- [Enable stack monitoring on ECK deployments](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/eck-stack-monitoring)


### Configure for self-managed deployments

- **Elasticsearch**:
  - [Collecting monitoring data with Elastic Agent](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/collecting-monitoring-data-with-elastic-agent) (recommended): Uses a single agent to gather logs and metrics. Can be managed from a central location in Fleet.
- [Collecting monitoring data with Metricbeat](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/collecting-monitoring-data-with-metricbeat): Uses a lightweight Beats shipper to gather metrics. May be preferred if you have an existing investment in Beats or are not yet ready to use Elastic Agent.
- [Collecting log data with Filebeat](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/collecting-log-data-with-filebeat): Uses a lightweight Beats shipper to gather logs.
- [Legacy collection methods for self-managed Elasticsearch](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/es-legacy-collection-methods): Uses internal exporters to gather metrics. Not recommended. If you have previously configured legacy collection methods, you should migrate to using Elastic Agent or Metricbeat.
- **Kibana**:
  - [Collect monitoring data with Elastic Agent](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/kibana-monitoring-elastic-agent) (recommended): Uses a single agent to gather logs and metrics. Can be managed from a central location in Fleet.
- [Collect monitoring data with Metricbeat](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/kibana-monitoring-metricbeat): Uses a lightweight Beats shipper to gather metrics. May be preferred if you have an existing investment in Beats or are not yet ready to use Elastic Agent.
- [Legacy collection methods for self-managed Kibana](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/kibana-monitoring-legacy): Uses internal exporters to gather metrics. Not recommended. If you have previously configured legacy collection methods, you should migrate to using Elastic Agent or Metricbeat.


### Monitor other Elastic Stack components

<tip>
  Most of these methods require that you configure monitoring of Elasticsearch before monitoring other components.
</tip>

- **Logstash**:
  - [Monitoring Logstash with Elastic Agent](https://www.elastic.co/docs/reference/logstash/monitoring-logstash-with-elastic-agent) (recommended): Uses a single agent to gather logs and metrics. Can be managed from a central location in Fleet.
- [Monitoring Logstash with legacy collection methods](https://www.elastic.co/docs/reference/logstash/monitoring-logstash-legacy): Use Metricbeat or legacy methods to collect monitoring data from Logstash.
- **Beats**:
  - [Auditbeat](https://www.elastic.co/docs/reference/beats/auditbeat/monitoring)
- [Filebeat](https://www.elastic.co/docs/reference/beats/filebeat/monitoring)
- [Heartbeat](https://www.elastic.co/docs/reference/beats/heartbeat/monitoring)
- [Metricbeat](https://www.elastic.co/docs/reference/beats/metricbeat/monitoring)
- [Packetbeat](https://www.elastic.co/docs/reference/beats/packetbeat/monitoring)
- [Winlogbeat](https://www.elastic.co/docs/reference/beats/winlogbeat/monitoring)
- [**APM Server**](https://www.elastic.co/docs/solutions/observability/apm/apm-server/monitor)
- **Elastic Agents**:
  - [Fleet-managed Elastic Agents](https://www.elastic.co/docs/reference/fleet/monitor-elastic-agent)
- [Standalone Elastic Agents](https://www.elastic.co/docs/reference/fleet/elastic-agent-monitoring-configuration)


### Access, view, and use monitoring data

- [Access monitoring data in Kibana](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/kibana-monitoring-data): After you collect monitoring data for one or more products in the Elastic Stack, configure Kibana to retrieve that information and display it in on the **Stack Monitoring** page.
- [Visualizing monitoring data](https://www.elastic.co/docs/deploy-manage/monitor/monitoring-data/visualizing-monitoring-data): View health and performance data for Elastic Stack components in real time, as well as analyze past performance.
- [Stack monitoring alerts](https://www.elastic.co/docs/deploy-manage/monitor/monitoring-data/configure-stack-monitoring-alerts): Configure alerts that trigger based on stack monitoring metrics.
- [Configuring monitoring data streams and indices](https://www.elastic.co/docs/deploy-manage/monitor/monitoring-data/configuring-data-streamsindices-for-monitoring): Adjust the data streams and indices used by stack monitoring.