﻿---
title: ECE platform monitoring
description: By default, Elastic Cloud Enterprise collects monitoring data for your installation using Filebeat and Metricbeat. This data gets sent as monitoring indices...
url: https://www.elastic.co/docs/deploy-manage/monitor/orchestrators/ece-platform-monitoring
products:
  - Elastic Cloud Enterprise
applies_to:
  - Elastic Cloud Enterprise: Generally available
---

# ECE platform monitoring
By default, Elastic Cloud Enterprise collects monitoring data for your installation using Filebeat and Metricbeat. This data gets sent as monitoring indices to a dedicated `logging-and-metrics` deployment that is created whenever you install Elastic Cloud Enterprise on your first host. Data is collected on every host that is part of your Elastic Cloud Enterprise installation and includes:
- Logs for all core services that are a part of Elastic Cloud Enterprise
- Monitoring metrics for core Elastic Cloud Enterprise services, system processes on the host, and any third-party software
- Logs and monitoring metrics for Elasticsearch clusters and for Kibana instances

These monitoring indices are collected in addition to the [stack monitoring you might have enabled for specific clusters](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/ece-ech-stack-monitoring), which also provides monitoring metrics that you can access in Kibana.
In this section, you'll learn the following about using ECE platform monitoring:
- [Platform monitoring deployment logs and metrics](https://www.elastic.co/docs/deploy-manage/monitor/orchestrators/ece-monitoring-ece-access): The types of logs and metrics that are collected for deployments, and where to find them.

- [Proxy log fields](https://www.elastic.co/docs/deploy-manage/monitor/orchestrators/ece-proxy-log-fields): The fields that are included in proxy logs. Proxy logs capture the search and indexing requests that proxies have sent to the Elasticsearch cluster, and requests that proxies have sent to the Kibana instance.
- [Set the retention period for logging and metrics indices](https://www.elastic.co/docs/deploy-manage/monitor/orchestrators/ece-monitoring-ece-set-retention): How to set the retention period for the indices that Elastic Cloud Enterprise collects.

For information about troubleshooting Elastic Cloud Enterprise using these metrics, and guidance on capturing other diagnostic information like heap dumps and thread dumps, refer to [Troubleshoot Elastic Cloud Enterprise](https://www.elastic.co/docs/troubleshoot/deployments/cloud-enterprise/cloud-enterprise).
<important>
  The `logging-and-metrics` deployment is for use by your ECE installation only. You must not use this deployment to index monitoring data from your own Elasticsearch clusters or use it to index data from Beats and Logstash. Always create a separate, dedicated monitoring deployment for your own use.
</important>