﻿---
title: Monitoring orchestrators
description: Your orchestrator is an important part of your Elastic architecture. It automates the deployment and management of multiple Elastic clusters, handling...
url: https://www.elastic.co/docs/deploy-manage/monitor/orchestrators
applies_to:
  - Elastic Cloud on Kubernetes: Generally available
  - Elastic Cloud Enterprise: Generally available
---

# Monitoring orchestrators
Your [orchestrator](/docs/deploy-manage/deploy#about-orchestration) is an important part of your Elastic architecture. It automates the deployment and management of multiple Elastic clusters, handling tasks like scaling, upgrades, and monitoring. Like your cluster or deployment, you need to monitor your orchestrator to ensure that it is healthy and performant. Monitoring is especially important for orchestrators hosted on infrastructure that you control.
In this section, you'll learn how to enable monitoring of your orchestrator.
- [ECK operator metrics](https://www.elastic.co/docs/deploy-manage/monitor/orchestrators/eck-metrics-configuration): Open and secure a metrics endpoint that can be used to monitor the operator’s performance and health. This endpoint can be scraped by third-party Kubernetes monitoring tools.
- [ECK platform monitoring](https://www.elastic.co/docs/deploy-manage/monitor/orchestrators/ece-platform-monitoring): Learn about how ECE collects monitoring data for your installation in the `logging-and-metrics` deployment, and how to access monitoring data.

<admonition title="Monitoring Elastic Cloud">
  Elastic monitors Elastic Cloud service metrics and performance as part of [our shared responsibility](https://www.elastic.co/cloud/shared-responsibility). We provide service availability information on our [service status page](https://www.elastic.co/docs/deploy-manage/cloud-organization/service-status).
</admonition>

<note>
  Orchestrator monitoring can sometimes augment cluster or deployment monitoring, but doesn't replace it. For information about monitoring your cluster or deployment, refer to [Monitoring](https://www.elastic.co/docs/deploy-manage/monitor).
</note>